/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.workflow;

import com.cloudpath.assess.pojo.Network;
import com.cloudpath.assess.pojo.NetworkItem;
import com.cloudpath.assess.pojo.Profile;
import com.cloudpath.common.app.gui.GuiTabChangeListener;
import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.ResponseHandler;
import com.cloudpath.common.dispatch.StartOverRequest;
import com.cloudpath.common.dispatch.StartingPoint;
import com.cloudpath.common.pojo.Content;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.Arguments;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.workflow.common.WorkflowConstants;
import com.cloudpath.workflow.common.block.selection.StartOverSelection;
import com.cloudpath.workflow.common.util.WorkflowBuilder;
import com.cloudpath.workflow.common.util.WorkflowChain;
import com.cloudpath.workflow.common.util.WorkflowChainImpl;
import org.apache.log4j.Logger;

public class Workflow
implements ResponseHandler {
    private static final Logger log = Logger.getLogger(Workflow.class);
    private final SelectionHandler cls_SelectionHandler;
    private final GuiTabChangeListener cls_TabListener;
    private final WorkflowChain cls_WorkflowChain;

    public Workflow(SelectionHandler selectionHandler, GuiTabChangeListener guiTabChangeListener, AsyncHandler asyncHandler, WorkflowBuilder workflowBuilder) {
        this.cls_SelectionHandler = selectionHandler;
        this.cls_TabListener = guiTabChangeListener;
        this.cls_WorkflowChain = new WorkflowChainImpl(this.cls_TabListener, asyncHandler);
        workflowBuilder.populateWorkflow(this.cls_WorkflowChain);
    }

    public DispatchRequest doProcess() {
        DispatchRequest dispatchRequest = this.cls_WorkflowChain.doProcess();
        log.debug((Object)("Workflow.doProcess received response " + dispatchRequest + ".  Will handle the request..."));
        DispatchRequest dispatchRequest2 = this.handleRequest(dispatchRequest);
        log.debug((Object)("Workflow.doProcess handled response and now will respond with " + dispatchRequest2));
        return dispatchRequest2;
    }

    public DispatchRequest addResponse(DispatchResponse dispatchResponse) {
        DispatchRequest dispatchRequest;
        if (dispatchResponse instanceof StartOverSelection) {
            log.info((Object)"Dispatcher.addResponse: Workflow received a StartOver selection.");
            dispatchRequest = this.startOver(((StartOverSelection)dispatchResponse).getStartingPoint());
        } else {
            log.info((Object)("Dispatcher.addResponse: Workflow received selection: " + dispatchResponse));
            dispatchRequest = this.cls_WorkflowChain.addSelection(dispatchResponse);
        }
        log.debug((Object)("Dispatcher.addResponse: Request received from non-bootstrap block: " + dispatchRequest));
        DispatchRequest dispatchRequest2 = this.handleRequest(dispatchRequest);
        log.info((Object)("Displatcher.addResponse: Returning: " + dispatchRequest2));
        return dispatchRequest2;
    }

    private DispatchRequest handleRequest(DispatchRequest dispatchRequest) {
        log.debug((Object)("Dispatcher.handleRequest: Workflow will process: " + dispatchRequest));
        if (dispatchRequest instanceof StartOverRequest) {
            log.info((Object)"Dispatcher.handleRequest: \n\nWILL PROCESS START OVER REQUEST \n\n");
            dispatchRequest = this.processStartOver((StartOverRequest)dispatchRequest);
            log.info((Object)"Dispatcher.handleRequest: \n\n**** DONE PROCESSING START OVER RESQUEST\n\n");
        }
        log.info((Object)("Dispatcher.handleRequest: HandleRequest is returning: " + dispatchRequest));
        return dispatchRequest;
    }

    public DispatchRequest startOver(StartingPoint startingPoint) {
        if (startingPoint == null) {
            startingPoint = StartingPoint.CONFIGURE;
        }
        this.cls_SelectionHandler.reset();
        this.cls_WorkflowChain.restart();
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.ARGUMENTS, new Arguments(new String[0]));
        this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.STARTING_POINT, (Object)startingPoint);
        DispatchRequest dispatchRequest = this.cls_WorkflowChain.doProcess();
        log.debug((Object)("Workflow.startOver will return: " + dispatchRequest));
        return dispatchRequest;
    }

    public DispatchRequest processStartOver(StartOverRequest startOverRequest) {
        DispatchRequest dispatchRequest = null;
        if (!startOverRequest.getKeepSelectionHandler()) {
            log.info((Object)"StartOverRequest received with keep selectionhandler set to false.");
            dispatchRequest = this.startOver(startOverRequest.getStartingPoint());
        } else {
            log.info((Object)"StartOverRequest received with keep SelectionHandler set to true.");
            log.info((Object)"\n\nWILL RESET INFORMATION....");
            SelectionHandler selectionHandler = this.cls_SelectionHandler;
            Network network = (Network)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK);
            NetworkItem networkItem = (NetworkItem)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM);
            String string = networkItem.getName();
            Profile profile = (Profile)selectionHandler.getObject(WorkflowConstants.DataType.SELECTED_PROFILE);
            Content content = (Content)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_CONTENT);
            NetworkInterface networkInterface = (NetworkInterface)this.cls_SelectionHandler.getObject(WorkflowConstants.DataType.SELECTED_INTERFACE);
            this.cls_WorkflowChain.restart();
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CONTENT, content);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.STARTING_POINT, (Object)StartingPoint.CONFIGURE);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_BEHAVIOR, (Object)WorkflowConstants.WorkflowBehavior.CONFIGURE);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_INTERFACE, networkInterface);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK, network);
            NetworkItem networkItem2 = network.getNextNetworkItem(string);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_NETWORK_ITEM, networkItem2);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SSID_NAME, null);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.DESIRED_PSK, null);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SECURITY_TYPE, null);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SUPPLICANT_PROFILE_NAME, null);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.DESIRED_SSID_IS_PSK, null);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.IS_SECONDARY_PASS, Boolean.TRUE);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.CURRENT_SNAPSHOT, null);
            this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.MODIFICATIONS, null);
            boolean bl = false;
            if (profile == null || profile.getShowPreCredentials() == -1) {
                bl = networkItem != null ? networkItem.getShowPreCredentials() : false;
            } else {
                boolean bl2 = bl = profile.getShowPreCredentials() == 1;
            }
            if (!bl) {
                this.cls_SelectionHandler.setObject(WorkflowConstants.DataType.SELECTED_CREDENTIAL, null);
            }
            log.debug((Object)("Before calling workchain.doProcess:\n" + this.cls_SelectionHandler.print()));
            dispatchRequest = this.cls_WorkflowChain.doProcess();
            if (dispatchRequest instanceof StartOverRequest) {
                log.debug((Object)"Workflow.processStartOver received a StartOverRequest response.  Will process again...");
                dispatchRequest = this.processStartOver((StartOverRequest)dispatchRequest);
            }
            log.debug((Object)("Workflow.processStartOver will return request: " + dispatchRequest));
        }
        return dispatchRequest;
    }
}

