/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.report.client;

import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.pojo.NetworkInterfaces;
import com.cloudpath.common.util.HttpResult;
import com.cloudpath.common.util.UrlLoader2;
import com.cloudpath.common.util.Util;
import com.cloudpath.report.client.pojo.ClientApi;
import com.cloudpath.report.client.pojo.ClientCommand;
import com.cloudpath.report.client.pojo.ClientOs;
import com.cloudpath.report.client.pojo.Driver;
import com.cloudpath.report.client.pojo.Hardware;
import com.cloudpath.report.client.pojo.Nic;
import com.cloudpath.report.client.pojo.Session;
import com.cloudpath.report.client.pojo.SessionUpdate;
import java.util.Locale;
import java.util.UUID;
import org.apache.log4j.Logger;

public class ReportHandler {
    private static final Logger log = Logger.getLogger(ReportHandler.class);
    private String cls_SessionId = "";
    private final String cls_ClientId;
    private final String cls_Key;
    private String cls_Url = null;
    private String cls_SourceId = null;
    private long cls_PreviousState = 0L;
    private boolean cls_WaitForResponse = false;

    public ReportHandler(String string, String string2) {
        this.cls_ClientId = string;
        this.cls_Key = string2;
    }

    public String getSessionId() {
        return this.cls_SessionId;
    }

    public String getClientId() {
        return this.cls_ClientId;
    }

    public void setUrl(String string) {
        this.cls_Url = string != null ? string : "";
        log.info((Object)("Reporting URL set to '" + this.cls_Url + "'."));
    }

    public SendResponse startSession(OsProvider osProvider, String string, boolean bl, String string2, String string3, Session session, boolean bl2, String string4) {
        Session session2;
        this.cls_PreviousState = 0L;
        this.cls_SessionId = string3 != null && string3.length() > 0 ? string3 : UUID.randomUUID().toString();
        log.info((Object)("Reporting Session Id is '" + this.cls_SessionId + "'."));
        this.cls_SourceId = string2;
        log.info((Object)("Reporting Source Id is '" + this.cls_SourceId + "'."));
        this.cls_WaitForResponse = bl2;
        if (session != null) {
            session2 = session;
        } else {
            Object object;
            session2 = new Session();
            session2.setNicId(string);
            log.info((Object)("Session NIC ID is '" + session2.getNicId() + "'."));
            Hardware hardware = new Hardware();
            hardware.setClientIsOnDomain(osProvider.isOnDomain());
            hardware.setComputerManufacturerName(osProvider.getComputerManufacturer());
            hardware.setComputerModel(osProvider.getComputerModel());
            hardware.setCpuName(osProvider.getComputerCpuName());
            hardware.setInstalledRam(osProvider.getComputerInstalledRam());
            hardware.setComputerName(string4);
            hardware.setLanguage(Locale.getDefault().getISO3Language());
            hardware.setCountry(Locale.getDefault().getISO3Country());
            try {
                object = osProvider.getNicProvider().getAllInterfaces(false);
                for (int i = 0; i < ((NetworkInterfaces)object).getInterfaceCount(); ++i) {
                    NetworkInterface networkInterface = ((NetworkInterfaces)object).getInterface(i);
                    Nic nic = new Nic();
                    nic.setNicId(networkInterface.getMacAddress());
                    nic.setNicLogicalName(networkInterface.getName());
                    nic.setNicDescription(networkInterface.getPhysicalCardName());
                    nic.setNicManufacturer(networkInterface.getManufacturer());
                    nic.setNicType("" + networkInterface.getInterfaceType());
                    nic.setWifiAuthenticationSupported("");
                    nic.setWifiEncryptionSupported("");
                    nic.setWifiPhysSupported("");
                    Driver driver = new Driver();
                    driver.setDate("");
                    driver.setName(networkInterface.getPhysicalCardName());
                    driver.setProvider(networkInterface.getDriverProvider());
                    driver.setVersion(networkInterface.getDriverVersion());
                    driver.setWifiAuthenticationSupported("");
                    driver.setWifiEncryptionSupported("");
                    driver.setWifiPhysSupported("");
                    nic.setDriver(driver);
                    hardware.addNic(nic);
                }
            }
            catch (Exception exception) {
                log.error((Object)"An exception occurred while loading NICs for startSession reporting.", (Throwable)exception);
            }
            session2.setHardware(hardware);
            object = new ClientOs();
            ((ClientOs)object).setBits(osProvider.getOsBits());
            String string5 = osProvider.getOsInfo().getOsName();
            if (string5.length() > 0) {
                string5 = string5.substring(0, 1).toUpperCase() + string5.substring(1);
            }
            ((ClientOs)object).setFamily(string5);
            ((ClientOs)object).setName(System.getProperty("os.name"));
            ((ClientOs)object).setServicePack(osProvider.getOsServicePack());
            ((ClientOs)object).setVersion(osProvider.getOsInfo().getOsVersion());
            session2.setOperatingSystem((ClientOs)object);
            session2.setStatusWillBeUpdated(bl);
        }
        return this.send(session2, "Start Session", this.cls_Key);
    }

    public SendResponse updateSession_Complete() {
        return this.updateSession(20000L);
    }

    public SendResponse updateSession_CredsRecieved() {
        return this.updateSession(1000L);
    }

    public SendResponse updateSession_AdminElevated() {
        if (this.cls_PreviousState <= 1500L) {
            return this.updateSession(1500L);
        }
        return new SendResponse(false, "");
    }

    public SendResponse updateSession_ConfigComplete() {
        return this.updateSession(1800L);
    }

    public SendResponse updateSession(long l) {
        log.info((Object)("Will update session status to " + l + "..."));
        this.cls_PreviousState = l;
        SessionUpdate sessionUpdate = new SessionUpdate(l + "");
        return this.send(sessionUpdate, "Update Session", this.cls_Key);
    }

    private SendResponse send(ClientCommand clientCommand, final String string, String string2) {
        String string3 = null;
        try {
            string3 = this.getXmlForSend(clientCommand, string, string2);
            log.info((Object)("DATA:\n" + string3));
            if (this.cls_Url == null) {
                log.error((Object)"The URL has not yet been set.", (Throwable)new Exception("URL Missing"));
                return new SendResponse(false, string3);
            }
            log.info((Object)("URL: " + this.cls_Url));
            final byte[] byArray = ("xmlData=" + string3).getBytes();
            Thread thread = Util.runThread("ReportHandler.Send", new Runnable(){

                public void run() {
                    HttpResult httpResult = UrlLoader2.fetchURL(ReportHandler.this.cls_Url, "", "", true, byArray, 0, null);
                    if (httpResult.getStatusCode() == 200L) {
                        System.err.println(httpResult.getContent());
                        log.info((Object)("Reporting Result:  Successful.  (Action: " + string + ")"));
                    } else {
                        log.error((Object)("Reporting Result:  Error occurred.  Action: " + string + " StatusCode: " + httpResult.getStatusCode() + " Message: " + httpResult.getStatusText()));
                    }
                }
            });
            if (this.cls_WaitForResponse) {
                long l = System.currentTimeMillis();
                thread.join();
                long l2 = System.currentTimeMillis();
                System.err.println("WAITED: " + (l2 - l));
            }
            return new SendResponse(true, string3);
        }
        catch (Throwable throwable) {
            log.error((Object)"An error occurred while sending reporting information.", throwable);
            return new SendResponse(false, string3 != null ? string3 : "");
        }
    }

    private String getXmlForSend(ClientCommand clientCommand, String string, String string2) {
        ClientApi clientApi = new ClientApi();
        clientApi.setClientId(this.cls_ClientId);
        clientApi.setSessionId(this.cls_SessionId);
        clientApi.setSourceId(this.cls_SourceId);
        clientApi.setKey(string2);
        clientApi.addCommand(clientCommand);
        log.info((Object)("Will " + string));
        String string3 = clientApi.getXml();
        return string3;
    }

    public static class SendResponse {
        private final boolean cls_Result;
        private final String cls_Xml;

        public SendResponse(boolean bl, String string) {
            this.cls_Result = bl;
            this.cls_Xml = string;
        }

        public boolean getResult() {
            return this.cls_Result;
        }

        public String getXml() {
            return this.cls_Xml;
        }
    }
}

