/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.util;

import com.cloudpath.common.util.Resources;
import com.cloudpath.common.util.Util;
import com.cloudpath.common.util.XmlUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class GuiConstants {
    private static final Logger log = Logger.getLogger(GuiConstants.class);
    public static final int ICON_INFO_ID = 1;
    public static final int ICON_WARNING_ID = 2;
    public static final int ICON_ERROR_ID = 3;
    public static final Cursor CURSOR_HAND = new Cursor(12);
    public static final Cursor CURSOR_DEFAULT = new Cursor(0);
    public static final Cursor CURSOR_BUSY = new Cursor(3);
    private static final String XIMAGE_CUSTOM_LOGO = "/customlogo";
    public static final String XIMAGE_APPLICATION_LOGO = "/ApplicationLogo.gif";
    public static final String XIMAGE_ACTIVE_TAB_ICON = "/ApplicationTabArrow.gif";
    public static final String XIMAGE_INACTIVE_TAB_ICON = "/ApplicationTabCheck.gif";
    public static final String IMAGE_LOADING_ICON = "/loading.gif";
    public static final String IMAGE_WARNING_ICON = "/warning.gif";
    public static final String IMAGE_ERROR_ICON = "/error.gif";
    public static final String IMAGE_SUCCESS_ICON = "/success.gif";
    public static final String IMAGE_QUESTION_ICON = "/question.gif";
    private static final String IMAGE_PATH_FIX_REQUIRED = "/fix_required.gif";
    private static final String IMAGE_PATH_FIX_OPTIONAL = "/fix_optional.gif";
    private static final String IMAGE_PATH_FIX = "/fix.gif";
    public static final String IMAGE_HELP = "/help.gif";
    public static final String IMAGE_INFO = "/info.gif";
    public static final String IMAGE_MAC_AUTHENTICATE = "/mac_authenticate.gif";
    public static final String IMAGE_MAC_ENABLE_AIRPORT = "/mac_enable_airport.gif";
    public static final String IMAGE_MAC_ADMIN_PASSWORD = "/mac_password.gif";
    public static final String IMAGE_MAC_LOCK = "/mac_lock.gif";
    public static final ImageIcon IMAGE_FIX_REQUIRED = new ImageIcon(GuiConstants.getImage("/fix_required.gif").getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon IMAGE_FIX_OPTIONAL = new ImageIcon(GuiConstants.getImage("/fix_optional.gif").getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon IMAGE_FIX = new ImageIcon(GuiConstants.getImage("/fix.gif").getImage().getScaledInstance(16, 16, 4));
    public static final String DEFAULT_HEADING = "Network Wizard";
    public static final String DEFAULT_POWERED_BY = "Powered By";
    public static final int LEFT_PANEL_WIDTH = 184;
    public static final int LEFT_PANEL_LOGO_HEIGHT = 78;
    public static final int LEFT_PANEL_BOTTOM_HEIGHT = 150;
    public static final int TAB_HEIGHT = 32;
    public static final int BORDER_TOP = 8;
    public static final int BORDER_BOTTOM = 16;
    public static final int BORDER_RIGHT = 16;
    public static final int BORDER_LEFT = 16;
    public static final boolean WORKAREA_BORDER_ROUNDED = true;
    public static final Color COLOR_MENU_BACKGROUND = Util.getColor(Resources.ResourceString.APPLICATION_BACKGROUND_COLOR.getValue());
    public static final Color COLOR_BACKGROUND = Util.getColor(Resources.ResourceString.APPLICATION_BACKGROUND_COLOR.getValue());
    public static final Color COLOR_WORKAREA_BORDER = Util.getColor(Resources.ResourceString.APPLICATION_OUTLINE_COLOR.getValue());
    public static final Color COLOR_ACTIVE_FOREGROUND = Util.getColor(Resources.ResourceString.APPLICATION_ACTIVE_TAB_FONT_COLOR.getValue());
    public static final Color COLOR_ACTIVE_BACKGROUND = Util.getColor(Resources.ResourceString.APPLICATION_ACTIVE_TAB_BACKGROUND_COLOR.getValue());
    public static final Color COLOR_ACTIVE_BORDER = Util.getColor(Resources.ResourceString.APPLICATION_ACTIVE_TAB_BORDER_COLOR.getValue());
    public static final Color COLOR_INACTIVE_FOREGROUND = Util.getColor(Resources.ResourceString.APPLICATION_INACTIVE_TAB_FONT_COLOR.getValue());
    public static final Color COLOR_INACTIVE_BACKGROUND = Util.getColor(Resources.ResourceString.APPLICATION_INACTIVE_TAB_BACKGROUND_COLOR.getValue());
    public static final Color COLOR_INACTIVE_BORDER = Util.getColor(Resources.ResourceString.APPLICATION_INACTIVE_TAB_BORDER_COLOR.getValue());
    public static final Color COLOR_LINE = Util.getColor(Resources.ResourceString.APPLICATION_LINE_COLOR.getValue());
    public static final Color COLOR_ERROR = new Color(11145279);
    public static final Color COLOR_ERROR_BACKGROUND = new Color(0xFF9999);
    public static final Color COLOR_WORKAREA = Color.white;
    public static final Color COLOR_LICENSED_TEXT = Util.getColor(Resources.ResourceString.APPLICATION_MAIN_TEXT_COLOR.getValue());
    public static final Color COLOR_UNLICENSED_TEXT = Color.red;
    public static final Color COLOR_ACCENT_LINE = new Color(0xCCCCCC);
    public static final Color COLOR_LIST_SELECTION = Util.getColor(Resources.ResourceString.APPLICATION_SELECTION_COLOR.getValue());
    public static final Color COLOR_LINK = new Color(0, 0, 204);
    public static final Color COLOR_LINK_PRESSED = new Color(189, 116, 255);
    public static final Color COLOR_LINK_HOVER = new Color(85, 26, 139);
    public static final int APPLICATION_SHADOW_WIDTH = (int)XmlUtil.getStringAsLong(Resources.ResourceString.APPLICATION_SHADOW_WIDTH.getValue(), 1L) / 12;
    public static final Font FONT_VERDANA_11_BOLD = new Font("Verdana", 1, 11);
    public static final Font FONT_VERDANA_12_PLAIN = new Font("Verdana", 0, 12);
    public static final Font FONT_VERDANA_11_PLAIN = new Font("Verdana", 0, 11);
    public static final Font FONT_VERDANA_18_PLAIN = new Font("Verdana", 0, 18);
    public static final Font FONT_VERDANA_20_PLAIN = new Font("Verdana", 0, 20);
    public static final Font FONT_ARIAL_12_PLAIN = new Font("Arial", 0, 12);
    public static final Font FONT_ARIAL_11_PLAIN = new Font("Arial", 0, 11);
    public static final Font FONT_ARIAL_11_BOLD = new Font("Arial", 1, 11);
    public static final Font MENU_FONT = new Font("Arial", 0, 11);
    public static final Font FONT_ARIAL_10_PLAIN = new Font("Arial", 0, 10);
    public static final Font FONT_ARIAL_12_BOLD = new Font("Arial", 1, 12);
    public static final Font FONT_ARIAL_13_BOLD = new Font("Arial", 1, 13);
    public static final Font FONT_ARIAL_13_PLAIN = new Font("Arial", 0, 13);
    public static final Font FONT_ARIAL_14_PLAIN = new Font("Arial", 0, 14);
    public static final Font FONT_ARIAL_15_PLAIN = new Font("Arial", 0, 15);

    public static ImageIcon getImage(String string) {
        log.debug((Object)("Will load image '" + string + "'"));
        URL uRL = GuiConstants.class.getResource(string);
        log.debug((Object)("  -- URL: " + uRL));
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public static JPanel wrapForLeft(JLabel jLabel) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.setOpaque(false);
        jPanel.add(jLabel);
        return jPanel;
    }

    public static void makeBold(Component component) {
        component.setFont(component.getFont().deriveFont(1));
    }

    public static String createMessage(String string) {
        if (string == null) {
            string = "";
        }
        string = Util.getSplitLines(string);
        return string;
    }

    public static ImageIcon getCustomLogo() {
        ImageIcon imageIcon = GuiConstants.getImage("/customlogo.gif");
        if (imageIcon == null && (imageIcon = GuiConstants.getImage("/customlogo.jpg")) == null && (imageIcon = GuiConstants.getImage("/customlogo.GIF")) == null) {
            imageIcon = GuiConstants.getImage("/customlogo.JPG");
        }
        return imageIcon;
    }

    public static String getIcon(int n) {
        if (n == 2) {
            return IMAGE_WARNING_ICON;
        }
        if (n == 3) {
            return IMAGE_ERROR_ICON;
        }
        if (n == 1) {
            return IMAGE_INFO;
        }
        return null;
    }

    public static final String getFontAsStyle(Font font) {
        String string = font.isBold() ? "bold" : "normal";
        return "<font style='font-weight: " + string + "; font-family: " + font.getName() + "; font-size: " + font.getSize() + ";'>";
    }
}

