/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.form;

import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.WaitRequest;
import com.cloudpath.common.os.common.BrowserProvider;
import com.cloudpath.common.util.Util;
import com.cloudpath.gui.component.StatusPanel;
import com.cloudpath.gui.component.XpcForm;
import com.cloudpath.gui.form.UpdatableForm;
import com.cloudpath.gui.template.XpcPromptForm;
import com.cloudpath.gui.util.FormListener;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;

public class WaitForm
extends XpcPromptForm
implements XpcForm,
UpdatableForm,
HyperlinkListener {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(WaitForm.class);
    private final StatusPanel cls_StatusPanel;
    private DispatchResponse cls_LeftButtonSelection;
    private DispatchResponse cls_RightButtonSelection;
    private final BrowserProvider cls_BrowserProvider;

    public WaitForm(FormListener formListener, WaitRequest waitRequest, BrowserProvider browserProvider) {
        super(formListener, (JPanel)null, waitRequest.getLeftButtonCaption(), waitRequest.getRightButtonCaption());
        this.cls_BrowserProvider = browserProvider;
        if (browserProvider != null) {
            // empty if block
        }
        this.cls_LeftButtonSelection = waitRequest.getLeftButtonSelection();
        this.cls_RightButtonSelection = waitRequest.getRightButtonSelection();
        this.cls_StatusPanel = new StatusPanel(waitRequest.getTitle(), waitRequest.getDetailText(), waitRequest.getIcon());
        if (browserProvider != null) {
            this.cls_StatusPanel.addHyperlinkListener(this);
        }
        this.add((Component)this.cls_StatusPanel, "Center");
        this.setButtonsVisible(waitRequest.getLeftButtonCaption() != null && waitRequest.getLeftButtonCaption().length() > 0, waitRequest.getRightButtonCaption() != null && waitRequest.getRightButtonCaption().length() > 0);
        log.debug((Object)(this.getClass().getSimpleName() + " initialized."));
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.cls_StatusPanel.addHyperlinkListener(hyperlinkListener);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && !hyperlinkEvent.getDescription().startsWith("CPN-")) {
            try {
                this.cls_BrowserProvider.openBrowser(hyperlinkEvent.getDescription());
            }
            catch (Exception exception) {
                log.warn((Object)("Error occurred while opening browser to '" + hyperlinkEvent.getDescription() + "'."), (Throwable)exception);
            }
        }
    }

    public boolean update(DispatchRequest dispatchRequest) {
        if (dispatchRequest instanceof WaitRequest) {
            this.update((WaitRequest)dispatchRequest);
            return true;
        }
        return false;
    }

    public void update(WaitRequest waitRequest) {
        log.info((Object)("Wait form updated: " + waitRequest.getLeftButtonCaption() + " -" + waitRequest.getLeftButtonSelection()));
        if (waitRequest.getTitle() != null && waitRequest.getTitle().length() > 0) {
            this.cls_StatusPanel.setTitle(waitRequest.getTitle());
        }
        String string = waitRequest.getDetailText();
        string = Util.getSplitLines(string);
        this.cls_StatusPanel.setMessage(string);
        this.cls_LeftButtonSelection = waitRequest.getLeftButtonSelection();
        this.cls_RightButtonSelection = waitRequest.getRightButtonSelection();
        this.getLeftButton().setText(waitRequest.getLeftButtonCaption());
        this.getRightButton().setText(waitRequest.getRightButtonCaption());
        this.setButtonsVisible(waitRequest.getLeftButtonCaption() != null && waitRequest.getLeftButtonCaption().length() > 0, waitRequest.getRightButtonCaption() != null && waitRequest.getRightButtonCaption().length() > 0);
        if (waitRequest.getIcon() != null) {
            this.cls_StatusPanel.setIcon(waitRequest.getIcon());
        }
    }

    public DispatchResponse getSelection() {
        return this.cls_RightButtonSelection;
    }

    public void nextClicked() {
        log.debug((Object)"Right button clicked.");
        this.selectionMade(this.cls_RightButtonSelection);
    }

    public void backClicked() {
        log.debug((Object)"Left clicked.");
        this.selectionMade(this.cls_LeftButtonSelection);
    }

    protected StatusPanel getStatusPanel() {
        return this.cls_StatusPanel;
    }
}

