/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.factor;

import com.cloudpath.common.util.GuiShutdownListener;
import com.cloudpath.common.util.Resources;
import com.cloudpath.common.util.Util;
import com.cloudpath.gui.MainPanel;
import com.cloudpath.gui.util.GuiConstants;
import com.cloudpath.gui.util.MenuProvider;
import com.cloudpath.gui.util.XpcFocusTraversalPolicy;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.apache.log4j.Logger;

public class XpcGuiFrame
extends JFrame
implements ActionListener,
KeyListener,
WindowListener {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(XpcGuiFrame.class);
    private final GuiShutdownListener cls_GuiShutdownListener;
    private final JMenuBar cls_MenuBar;
    private final MainPanel cls_MainPanel;
    private final XpcFocusTraversalPolicy cls_FocusPolicy = new XpcFocusTraversalPolicy(this);
    private final MenuProvider cls_MenuProvider;

    public XpcGuiFrame(MenuProvider menuProvider, GuiShutdownListener guiShutdownListener) {
        log.debug((Object)(Util.getClassName(this) + " initializing..."));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.cls_GuiShutdownListener = guiShutdownListener;
        this.cls_MenuProvider = menuProvider;
        this.setTitle(Resources.ResourceString.PRODUCT_NAME.getValue());
        this.setResizable(true);
        this.setFocusable(true);
        this.setFocusTraversalPolicy(this.cls_FocusPolicy);
        this.addWindowListener(this);
        this.cls_MainPanel = new MainPanel(this.getRootPane(), this.cls_FocusPolicy);
        this.getContentPane().add(this.cls_MainPanel);
        this.cls_MenuBar = this.createMenuBar();
        this.setJMenuBar(this.cls_MenuBar);
        this.addKeyListener(this);
        this.pack();
        int n = (int)(toolkit.getScreenSize().getHeight() - this.getSize().getHeight()) / 3;
        this.setLocation(50, n);
    }

    public JMenuBar getMenu() {
        return this.cls_MenuBar;
    }

    public MainPanel getMainPanel() {
        return this.cls_MainPanel;
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBackground(GuiConstants.COLOR_MENU_BACKGROUND);
        jMenuBar.setBorder(null);
        if (this.cls_MenuProvider != null) {
            this.cls_MenuProvider.createMenu(jMenuBar, this);
        }
        return jMenuBar;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        System.out.println("Focus Owner: " + this.getFocusOwner());
        this.cls_MainPanel.keyReleased(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.cls_MenuProvider != null) {
            this.cls_MenuProvider.menuSelected(this, actionEvent.getActionCommand());
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("Window & system are closing...");
        if (this.cls_GuiShutdownListener != null) {
            this.cls_GuiShutdownListener.shutdown();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

