/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.factor;

import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.pojo.Contact;
import com.cloudpath.common.util.Resources;
import com.cloudpath.gui.component.XpcButtonPanel;
import com.cloudpath.gui.component.XpcForm;
import com.cloudpath.gui.component.XpcLinkListener;
import com.cloudpath.gui.component.XpcPartialLinkLabel;
import com.cloudpath.gui.component.XpcSpacer;
import com.cloudpath.gui.factor.FrameUtil;
import com.cloudpath.gui.util.GuiConstants;
import com.cloudpath.gui.util.XpcFocusTraversalPolicy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;

public class HelpdeskFrame
extends JFrame
implements WindowListener,
XpcForm,
XpcLinkListener {
    public static final long serialVersionUID = 1L;
    private final XpcButtonPanel cls_Buttons;
    private final Contact cls_Contact;
    private final OsProvider cls_OsProvider;

    public HelpdeskFrame(OsProvider osProvider, Contact contact) {
        JPanel jPanel;
        this.cls_Contact = contact;
        this.cls_OsProvider = osProvider;
        Dimension dimension = new Dimension(500, 400);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.getContentPane().setBackground(GuiConstants.COLOR_BACKGROUND);
        this.setTitle(Resources.ResourceString.PRODUCT_NAME.getValue());
        this.setResizable(false);
        this.setFocusable(true);
        this.addWindowListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new XpcSpacer(10, 1), "West");
        this.getContentPane().add((Component)new XpcSpacer(10, 1), "East");
        this.getContentPane().add((Component)new XpcSpacer(1, 10), "North");
        this.getContentPane().add((Component)new XpcSpacer(1, 10), "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new CompoundBorder(new LineBorder(GuiConstants.COLOR_ACTIVE_BACKGROUND, GuiConstants.APPLICATION_SHADOW_WIDTH), new MatteBorder(10, 10, 10, 10, (Color)null)));
        jPanel2.setOpaque(true);
        jPanel2.setBackground(GuiConstants.COLOR_WORKAREA);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel2.add(FrameUtil.createLabel("Help Desk Information", true, false));
        jPanel2.add(new XpcSpacer(1, 10));
        JTextArea jTextArea = new JTextArea(contact != null ? contact.getMessage() : "No information is available.");
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setOpaque(true);
        jTextArea.setFont(GuiConstants.FONT_ARIAL_11_PLAIN);
        jTextArea.setRows(15);
        jTextArea.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setOpaque(false);
        jPanel2.add(jScrollPane);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setOpaque(false);
        jPanel2.add(jPanel3);
        jPanel2.add(new XpcSpacer(20, 8));
        if (contact != null) {
            if (contact.getName() != null && contact.getName().length() > 0) {
                jPanel2.add(FrameUtil.createLabel("Name: " + contact.getName(), false, false));
                jPanel2.add(new XpcSpacer(1, 6));
            }
            if (contact.getPhone() != null && contact.getPhone().length() > 0) {
                jPanel2.add(FrameUtil.createLabel("Phone: " + contact.getPhone(), false, false));
                jPanel2.add(new XpcSpacer(1, 6));
            }
            if (contact.getEmail() != null && contact.getEmail().length() > 0) {
                jPanel2.add(FrameUtil.createLabel("Email: " + contact.getEmail(), false, false));
                jPanel2.add(new XpcSpacer(1, 6));
            }
            if (contact.getIm() != null && contact.getIm().length() > 0) {
                jPanel2.add(FrameUtil.createLabel("IM: " + contact.getIm(), false, false));
                jPanel2.add(new XpcSpacer(1, 6));
            }
            if (contact.getUrl() != null && contact.getUrl().length() > 0) {
                jPanel = new XpcPartialLinkLabel();
                ((XpcPartialLinkLabel)jPanel).addText("Network information is available at ");
                ((XpcPartialLinkLabel)jPanel).addLink(contact.getUrl(), 1, this);
                ((XpcPartialLinkLabel)jPanel).addText(".");
                jPanel2.add(jPanel);
                jPanel2.add(new XpcSpacer(20, 8));
            }
        }
        jPanel2.add(new XpcSpacer(1, 20));
        jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel2.add(jPanel);
        this.cls_Buttons = new XpcButtonPanel(this, null, "OK");
        jPanel2.add(this.cls_Buttons);
        this.getRootPane().setDefaultButton(this.getDefaultButton());
        this.pack();
    }

    public void close() {
        this.setVisible(false);
    }

    public void backClicked() {
    }

    public void nextClicked() {
        this.close();
    }

    public void populateFocusTraversal(XpcFocusTraversalPolicy xpcFocusTraversalPolicy) {
        this.cls_Buttons.populateFocusTraversal(xpcFocusTraversalPolicy);
    }

    public void doFocus() {
        this.cls_Buttons.getRightButton().requestFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public JButton getDefaultButton() {
        return this.cls_Buttons.getDefaultButton();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void linkClicked(int n) {
        try {
            this.cls_OsProvider.openBrowser(this.cls_Contact.getUrl());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

