/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.component;

import com.cloudpath.gui.component.XpcFixedPanel;
import com.cloudpath.gui.component.XpcTab;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BoxLayout;
import org.apache.log4j.Logger;

public class XpcTabs
extends XpcFixedPanel {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(XpcTabs.class);
    private static final int MAX_TAB_COUNT = 20;
    private static final int LEFT_PADDING = 0;
    private final Vector<XpcTab> cls_Tabs = new Vector();
    private int cls_SelectedTab = -1;
    private int cls_TabCount = 0;

    public XpcTabs(Component component, String[] stringArray) {
        super(component.getWidth() - 0, 32 * stringArray.length, true, false);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        for (int i = 0; i < 20; ++i) {
            XpcTab xpcTab = new XpcTab(component.getBackground(), "");
            xpcTab.setVisible(false);
            this.cls_Tabs.add(xpcTab);
        }
        this.setTabNames(stringArray, stringArray != null && stringArray.length > 0 ? 0 : -1);
    }

    public void setTabNames(String[] stringArray, int n) {
        XpcTab xpcTab;
        int n2;
        this.cls_TabCount = stringArray.length;
        String string = null;
        if (n < 0 && (n2 = this.getSelectedTab()) >= 0 && (xpcTab = this.cls_Tabs.get(n2)) != null) {
            string = xpcTab.getName();
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.cls_Tabs.elementAt(n2).setCaption(stringArray[n2]);
            this.setTabVisible(n2, true);
            if (string == null || !string.equals(stringArray[n2])) continue;
            n = n2;
        }
        for (n2 = stringArray.length; n2 < this.cls_Tabs.size(); ++n2) {
            this.setTabVisible(n2, false);
        }
        this.setSelectedTab(n);
    }

    public int getTabCount() {
        return this.cls_TabCount;
    }

    public int getVisibleTabCount() {
        int n = 0;
        for (int i = 0; i < this.cls_Tabs.size(); ++i) {
            if (!this.cls_Tabs.elementAt(i).isVisible()) continue;
            ++n;
        }
        return n;
    }

    public String getSelectedTabCaption() {
        return this.cls_Tabs.elementAt(this.getSelectedTab()).getName();
    }

    public int getSelectedTab() {
        return this.cls_SelectedTab;
    }

    public void setSelectedTab(String string) {
        log.debug((Object)("Selected tab set to '" + string + "'."));
        int n = -1;
        for (int i = 0; n < 0 && i < this.cls_Tabs.size(); ++i) {
            if (!string.equals(this.cls_Tabs.get(i).getName())) continue;
            n = i;
        }
        if (n >= 0) {
            this.setSelectedTab(n);
        }
    }

    public void setSelectedTab(int n) {
        if (n < 0 || n >= this.cls_Tabs.size()) {
            n = -1;
        }
        if (this.cls_SelectedTab != n) {
            this.cls_SelectedTab = n;
            for (int i = 0; i < this.cls_Tabs.size(); ++i) {
                if (i < n) {
                    this.cls_Tabs.elementAt(i).setStatus(-1);
                    continue;
                }
                if (i > n) {
                    this.cls_Tabs.elementAt(i).setStatus(1);
                    continue;
                }
                this.cls_Tabs.elementAt(i).setStatus(0);
            }
        }
    }

    public void setTabVisible(int n, boolean bl) {
        this.setTabVisible(new int[]{n}, bl);
    }

    public void setTabVisible(int[] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= this.cls_Tabs.size() || this.cls_Tabs.elementAt(n).isVisible() == bl) continue;
            log.debug((Object)("Will set visible for " + n + " to " + bl));
            this.cls_Tabs.elementAt(n).setVisible(bl);
            if (!bl) {
                this.getContentPane().remove(this.cls_Tabs.elementAt(n));
            } else {
                this.getContentPane().removeAll();
                for (int j = 0; j < this.cls_Tabs.size(); ++j) {
                    if (!this.cls_Tabs.elementAt(j).isVisible()) continue;
                    this.getContentPane().add(this.cls_Tabs.elementAt(j));
                }
            }
            this.setFixedSize(this.getParent().getWidth() - 0, 32 * this.getContentPane().getComponentCount());
            this.getContentPane().revalidate();
        }
    }

    public boolean isTabVisible(int n) {
        if (n >= 0 && n < this.cls_Tabs.size()) {
            return this.cls_Tabs.elementAt(n).isVisible();
        }
        return false;
    }
}

