/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.component;

import com.cloudpath.gui.util.GuiConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class XpcTab
extends JPanel {
    public static final long serialVersionUID = 1L;
    public static final int STATUS_BEFORE_SELECTED_TAB = -1;
    public static final int STATUS_IS_SELECTED_TAB = 0;
    public static final int STATUS_AFTER_SELECTED_TAB = 1;
    private static final int IMAGE_SIZE = 16;
    private static final Dimension PADDING_SIZE = new Dimension(30, 0);
    private static final Border BORDER_ACTIVE = new CustomLineBorder(GuiConstants.COLOR_ACTIVE_BORDER, 1, true);
    private static final Border BORDER_INACTIVE = new CustomLineBorder(GuiConstants.COLOR_INACTIVE_BORDER, 1, true);
    private static final ImageIcon ICON_ACTIVE_TAB;
    private static final ImageIcon ICON_INACTIVE_TAB;
    private final Color cls_BackgroundColor;
    private final JLabel cls_Label;
    private final JPanel cls_LeftPadding;
    private final JLabel cls_LabelIcon;
    private int cls_Status = 1;
    private boolean cls_IsVisible = true;

    public XpcTab(Color color, String string) {
        this.cls_BackgroundColor = color;
        this.setLayout(new BorderLayout());
        this.cls_LeftPadding = new JPanel();
        this.cls_LeftPadding.setOpaque(false);
        this.cls_LeftPadding.setMinimumSize(PADDING_SIZE);
        this.cls_LeftPadding.setMaximumSize(PADDING_SIZE);
        this.cls_LeftPadding.setPreferredSize(PADDING_SIZE);
        this.cls_LeftPadding.setSize(PADDING_SIZE);
        this.cls_LeftPadding.setLayout(new BorderLayout());
        this.add((Component)this.cls_LeftPadding, "Before");
        this.cls_Label = new JLabel(string);
        this.cls_Label.setFont(GuiConstants.FONT_VERDANA_11_BOLD);
        this.add((Component)this.cls_Label, "Center");
        this.cls_LabelIcon = new JLabel();
        this.cls_LabelIcon.setAlignmentY(0.5f);
        this.cls_LabelIcon.setAlignmentX(0.5f);
        this.cls_LabelIcon.setHorizontalAlignment(0);
        this.cls_LeftPadding.add((Component)this.cls_LabelIcon, "Center");
        this.setStatus(1);
    }

    public String getName() {
        return this.getCaption();
    }

    public String getCaption() {
        return this.cls_Label.getText();
    }

    public void setCaption(String string) {
        this.cls_Label.setText(string);
    }

    public boolean isSelected() {
        return this.cls_Status == 0;
    }

    public void setVisible(boolean bl) {
        this.cls_IsVisible = bl;
    }

    public boolean isVisible() {
        return this.cls_IsVisible;
    }

    public void setStatus(int n) {
        if (n < 0) {
            this.setBackground(GuiConstants.COLOR_INACTIVE_BACKGROUND);
            this.setBorder(BORDER_INACTIVE);
            this.cls_Label.setForeground(GuiConstants.COLOR_INACTIVE_FOREGROUND);
            this.cls_LabelIcon.setIcon(ICON_INACTIVE_TAB);
        } else if (n > 0) {
            this.setBackground(GuiConstants.COLOR_INACTIVE_BACKGROUND);
            this.setBorder(BORDER_INACTIVE);
            this.cls_Label.setForeground(GuiConstants.COLOR_INACTIVE_FOREGROUND);
            this.cls_LabelIcon.setIcon(null);
        } else {
            this.setBackground(GuiConstants.COLOR_ACTIVE_BACKGROUND);
            this.setBorder(BORDER_ACTIVE);
            this.cls_Label.setForeground(GuiConstants.COLOR_ACTIVE_FOREGROUND);
            this.cls_LabelIcon.setIcon(ICON_ACTIVE_TAB);
        }
    }

    public void paintComponent(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.cls_BackgroundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(this.getBackground());
        graphics.fillRoundRect(0, 0, 20, this.getHeight(), 10, 10);
        graphics.fillRect(10, 0, this.getWidth(), this.getHeight());
        graphics.setColor(color);
    }

    static {
        ImageIcon imageIcon = GuiConstants.getImage("/ApplicationTabArrow.gif");
        ICON_ACTIVE_TAB = imageIcon == null ? null : new ImageIcon(imageIcon.getImage().getScaledInstance(16, 16, 4));
        imageIcon = GuiConstants.getImage("/ApplicationTabCheck.gif");
        ICON_INACTIVE_TAB = imageIcon == null ? null : new ImageIcon(imageIcon.getImage().getScaledInstance(16, 16, 4));
    }

    public static class CustomLineBorder
    extends LineBorder {
        public static final long serialVersionUID = 1L;

        public CustomLineBorder(Color color, int n, boolean bl) {
            super(color, n, bl);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.getLineColor());
            int n5 = 5;
            graphics.drawLine(n5, 0, n3, 0);
            graphics.drawLine(n5, n4 - 1, n3, n4 - 1);
            graphics.drawLine(0, n5, 0, n4 - n5);
            graphics.drawArc(0, 0, 10, 10, 90, 90);
            graphics.drawArc(0, n4 - 11, 10, 10, 180, 90);
            graphics.setColor(color);
        }
    }
}

