/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.component;

import com.cloudpath.gui.util.GuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class XpcListItemPanel
extends JPanel
implements MouseListener {
    public static final long serialVersionUID = 1L;
    private static final Dimension ITEM_MINIMUM_SIZE = new Dimension(99999, 32);
    private final int cls_Index;
    private final String cls_Caption;
    private final String cls_Description;
    private final ActionListener cls_Listener;
    private final JButton cls_Button;
    private boolean cls_Selected = true;

    public XpcListItemPanel(int n, String string, String string2, int n2, ActionListener actionListener) {
        this.cls_Index = n2;
        this.cls_Caption = string;
        this.cls_Description = string2;
        this.cls_Listener = actionListener;
        this.setMinimumSize(ITEM_MINIMUM_SIZE);
        this.setMaximumSize(new Dimension(99999, n));
        this.setPreferredSize(ITEM_MINIMUM_SIZE);
        this.setOpaque(true);
        this.setBackground(GuiConstants.COLOR_WORKAREA);
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        this.cls_Button = new JButton(string);
        this.cls_Button.setBorder(null);
        this.cls_Button.setHorizontalAlignment(2);
        if (n > 32) {
            this.cls_Button.setVerticalAlignment(1);
        } else {
            this.cls_Button.setVerticalAlignment(0);
        }
        this.cls_Button.setFont(GuiConstants.FONT_ARIAL_11_PLAIN);
        this.cls_Button.setAlignmentX(0.5f);
        this.cls_Button.setOpaque(true);
        this.cls_Button.setBackground(GuiConstants.COLOR_WORKAREA);
        this.cls_Button.addActionListener(actionListener);
        this.cls_Button.setDefaultCapable(false);
        this.cls_Button.setActionCommand("" + n2);
        this.cls_Button.setFocusable(false);
        this.cls_Button.addMouseListener(this);
        this.add((Component)this.cls_Button, "Center");
        this.setSelected(false);
    }

    public void setSelected(boolean bl) {
        if (bl != this.cls_Selected) {
            this.cls_Button.setText(XpcListItemPanel.formatTitle(bl, this.cls_Caption, this.cls_Description));
            if (bl) {
                this.cls_Button.setBackground(GuiConstants.COLOR_LIST_SELECTION);
                this.setBackground(GuiConstants.COLOR_LIST_SELECTION);
            } else {
                this.cls_Button.setBackground(GuiConstants.COLOR_WORKAREA);
                this.setBackground(GuiConstants.COLOR_WORKAREA);
            }
            this.cls_Selected = bl;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        System.out.println("Mouse clicked.");
        this.cls_Listener.actionPerformed(new ActionEvent(this.cls_Button, this.cls_Index, this.cls_Button.getActionCommand()));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private static String formatTitle(boolean bl, String string, String string2) {
        String string3;
        if (bl) {
            string3 = "<html><table><tr><td>&nbsp;&nbsp;&nbsp;</td><td><font color='black'><b>" + string + "</b></font>";
            if (string2 != null && string2.length() > 0) {
                string3 = string3 + "<br><table><tr><td>&nbsp;&nbsp;&nbsp;</td><td><font color='black'>" + string2 + "</font></td></tr></table>";
            }
            string3 = string3 + "</td></tr></table></html>";
        } else {
            string3 = "<html><table><tr><td>&nbsp;&nbsp;&nbsp;</td><td><font color='#404040'>" + string + "</font>";
            if (string2 != null && string2.length() > 0) {
                string3 = string3 + "<br><table><tr><td>&nbsp;&nbsp;&nbsp;</td><td><font color='#808080'>" + string2 + "</font></td></tr></table>";
            }
            string3 = string3 + "</td></tr></table></html>";
        }
        return string3;
    }
}

