/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.component;

import com.cloudpath.gui.component.XpcLinkListener;
import com.cloudpath.gui.util.GuiConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;

public class XpcLink
extends JLabel
implements MouseListener {
    public static final long serialVersionUID = 1L;
    private final int cls_Id;
    private final XpcLinkListener cls_Listener;
    private boolean cls_IsLink;
    private Rectangle2D cls_TextBounds = null;

    public XpcLink(String string, int n, XpcLinkListener xpcLinkListener, boolean bl) {
        super(string);
        this.setOpaque(false);
        this.setFont(GuiConstants.FONT_ARIAL_11_PLAIN);
        this.setAlignmentX(0.0f);
        this.cls_Id = n;
        this.cls_Listener = xpcLinkListener;
        boolean bl2 = this.cls_IsLink = bl && xpcLinkListener != null;
        if (this.cls_IsLink) {
            this.setForeground(GuiConstants.COLOR_LINK);
            this.addMouseListener(this);
        }
    }

    public void removeLink(String string) {
        this.setForeground(Color.BLACK);
        this.cls_IsLink = false;
        this.removeMouseListener(this);
        this.setText(string);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.cls_IsLink) {
            if (this.cls_TextBounds == null) {
                this.cls_TextBounds = this.getFontMetrics(this.getFont()).getStringBounds(this.getText(), graphics);
            }
            int n = this.getHeight() / 2 + (int)(this.cls_TextBounds.getHeight() / 2.0);
            int n2 = (int)this.cls_TextBounds.getWidth();
            int n3 = 0;
            Color color = graphics.getColor();
            graphics.setColor(this.getForeground());
            graphics.drawLine(0, n, n3 + n2, n);
            graphics.setColor(color);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.setCursor(GuiConstants.CURSOR_BUSY);
        this.cls_Listener.linkClicked(this.cls_Id);
        this.setCursor(GuiConstants.CURSOR_HAND);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setForeground(GuiConstants.COLOR_LINK_HOVER);
        this.setCursor(GuiConstants.CURSOR_HAND);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setForeground(GuiConstants.COLOR_LINK);
        this.setCursor(GuiConstants.CURSOR_DEFAULT);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setForeground(GuiConstants.COLOR_LINK_PRESSED);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setForeground(GuiConstants.COLOR_LINK);
    }
}

