/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.component;

import com.cloudpath.gui.util.GuiConstants;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.parser.ParserDelegator;
import org.apache.log4j.Logger;

public class XpcHtmlDisplay
extends JEditorPane {
    public static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(XpcHtmlDisplay.class);
    private String cls_Message = "";
    private Font cls_Font = GuiConstants.FONT_ARIAL_11_PLAIN;

    public XpcHtmlDisplay(HyperlinkListener hyperlinkListener) {
        super("text/html", "");
        this.addHyperlinkListener(hyperlinkListener);
        this.setBorder(null);
        this.setEditable(false);
        this.setOpaque(false);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.cls_Font = font;
    }

    public String getMessage() {
        return this.cls_Message;
    }

    public void setMessage(String string) {
        this.cls_Message = string;
        this.setText(XpcHtmlDisplay.wrapIfNecessary(string));
    }

    public void appendMessage(String string) {
        this.appendMessage(string, this.cls_Font);
    }

    public void appendMessage(String string, Font font) {
        this.setFont(font);
        if (string.length() > 0) {
            string = GuiConstants.getFontAsStyle(font) + string + "</font>";
            string = "<div>" + string + "</div>";
            this.cls_Message = this.cls_Message + string;
        }
        this.setText(XpcHtmlDisplay.wrapIfNecessary(this.cls_Message));
    }

    private static final String wrapIfNecessary(String string) {
        if (string == null) {
            return "";
        }
        if (!string.toLowerCase().startsWith("<html>")) {
            string = "<html>" + string;
        }
        if (!string.toLowerCase().endsWith("</html>")) {
            string = string + "</html>";
        }
        return string;
    }

    public void setText(String string) {
        try {
            super.setText(string);
        }
        catch (Exception exception) {
            log.info((Object)"Java bug with nullPtr hit.  Will try to work-around.");
            ParserDelegator parserDelegator = new ParserDelegator();
            try {
                super.setText(string);
            }
            catch (Exception exception2) {
                log.info((Object)"Workaround didn't work.  Will try non-html.", (Throwable)exception2);
                if (string != null) {
                    string = string.replace("<html>", "");
                    string = string.replace("</html>", "");
                }
                try {
                    super.setText(string);
                }
                catch (Exception exception3) {
                    log.error((Object)("A null ptr exception was thrown by JEditorPane while setting text: \n" + string + "\n\n"), (Throwable)exception3);
                    try {
                        super.setText("");
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

