/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.component;

import com.cloudpath.gui.component.XpcComponentConstants;
import com.cloudpath.gui.component.XpcListItem;
import com.cloudpath.gui.component.XpcSpacer;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.gui.util.GuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class XpcComboListItem
extends JPanel
implements XpcListItem,
MouseListener {
    public static final long serialVersionUID = 1L;
    private static final Dimension ITEM_MINIMUM_SIZE = new Dimension(99999, 32);
    private final FormListener cls_FormListener;
    private final int cls_Index;
    private final String cls_Caption;
    private final JButton cls_Button;
    private boolean cls_Selected = true;
    private ActionListener cls_Listener = null;

    public XpcComboListItem(int n, String string, Component component, int n2, FormListener formListener) {
        this.cls_Index = n2;
        this.cls_Caption = string;
        this.cls_FormListener = formListener;
        this.setMinimumSize(ITEM_MINIMUM_SIZE);
        this.setMaximumSize(new Dimension(99999, n));
        this.setPreferredSize(ITEM_MINIMUM_SIZE);
        this.setOpaque(true);
        this.setBackground(GuiConstants.COLOR_WORKAREA);
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        this.cls_Button = new JButton(string);
        this.cls_Button.setBorder(null);
        this.cls_Button.setHorizontalAlignment(2);
        if (n > 32) {
            this.cls_Button.setVerticalAlignment(1);
        } else {
            this.cls_Button.setVerticalAlignment(0);
        }
        this.cls_Button.setFont(GuiConstants.FONT_ARIAL_11_PLAIN);
        this.cls_Button.setAlignmentX(0.5f);
        this.cls_Button.setOpaque(true);
        this.cls_Button.setBackground(GuiConstants.COLOR_ERROR);
        this.cls_Button.setDefaultCapable(false);
        this.cls_Button.setActionCommand("" + n2);
        this.cls_Button.setFocusable(false);
        this.cls_Button.addMouseListener(this);
        this.add((Component)this.cls_Button, "North");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)new XpcSpacer(100, 1), "West");
        jPanel.add((Component)new XpcSpacer(50, 1), "East");
        jPanel.add((Component)new XpcSpacer(1, 5), "North");
        jPanel.add((Component)new XpcSpacer(1, 5), "South");
        jPanel.add(component, "Center");
        this.add((Component)jPanel, "Center");
        this.setSelected(false);
    }

    public void addListener(ActionListener actionListener) {
        this.cls_Listener = actionListener;
        this.cls_Button.addActionListener(actionListener);
    }

    public boolean isSelected() {
        return this.cls_Selected;
    }

    public void setSelected(boolean bl) {
        if (bl != this.cls_Selected) {
            this.cls_Button.setText(XpcComboListItem.formatTitle(bl, this.cls_Caption, ""));
            if (bl) {
                this.cls_Button.setBackground(GuiConstants.COLOR_LIST_SELECTION);
                this.setBackground(GuiConstants.COLOR_LIST_SELECTION);
            } else {
                this.cls_Button.setBackground(GuiConstants.COLOR_WORKAREA);
                this.setBackground(GuiConstants.COLOR_WORKAREA);
                if (XpcComponentConstants.isMac()) {
                    this.cls_Button.setBorder(null);
                }
            }
            this.cls_Selected = bl;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.cls_Listener.actionPerformed(new ActionEvent(this.cls_Button, this.cls_Index, this.cls_Button.getActionCommand()));
        if (this.cls_FormListener != null && mouseEvent.getClickCount() > 1) {
            this.cls_FormListener.selectionMade(null);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(GuiConstants.CURSOR_HAND);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(GuiConstants.CURSOR_DEFAULT);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private static String formatTitle(boolean bl, String string, String string2) {
        String string3;
        String string4 = "<td>&nbsp;&nbsp;&nbsp;</td>";
        if (XpcComponentConstants.isMac()) {
            string4 = "";
        }
        if (bl) {
            string3 = "<html><table><tr>" + string4 + "<td><font color='black'><b>" + string + "</b></font>";
            if (string2 != null && string2.length() > 0) {
                string3 = string3 + "<br><table><tr>" + string4 + "<td><font color='black'>" + string2 + "</font></td></tr></table>";
            }
            string3 = string3 + "</td></tr></table></html>";
        } else {
            string3 = "<html><table><tr><td>&nbsp;&nbsp;&nbsp;</td><td><font color='#404040'>" + string + "</font>";
            if (string2 != null && string2.length() > 0) {
                string3 = string3 + "<br><table><tr><td>&nbsp;&nbsp;&nbsp;</td><td><font color='#808080'>" + string2 + "</font></td></tr></table>";
            }
            string3 = string3 + "</td></tr></table></html>";
        }
        return string3;
    }
}

