/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui.component;

import com.cloudpath.common.util.Util;
import com.cloudpath.gui.component.XpcComponentConstants;
import com.cloudpath.gui.component.XpcForm;
import com.cloudpath.gui.util.GuiConstants;
import com.cloudpath.gui.util.GuiUtil;
import com.cloudpath.gui.util.XpcFocusTraversalPolicy;
import com.cloudpath.gui.util.XpcKeyClickedDelegator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

public class XpcButtonPanel
extends JPanel {
    public static final long serialVersionUID = 1L;
    public static final Font BUTTON_FONT_MAC = new Font("Dialog", 0, 12);
    private final XpcForm cls_XpcForm;
    private final XpcButton cls_LeftButton;
    private final XpcButton cls_RightButton;

    public XpcButtonPanel(XpcForm xpcForm, String string, String string2) {
        this.cls_XpcForm = xpcForm;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.add(GuiUtil.getVerticalPadding(10));
        this.add(GuiUtil.getLine());
        this.add(GuiUtil.getVerticalPadding(10));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new MatteBorder(0, 30, 0, 30, (Color)null));
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        this.cls_LeftButton = new XpcButton(string, xpcForm);
        this.cls_LeftButton.setDefaultCapable(false);
        this.cls_LeftButton.setVisible(string != null && string.length() > 0);
        this.cls_LeftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.runThread("BackClicked", new Runnable(){

                    public void run() {
                        XpcButtonPanel.this.cls_XpcForm.backClicked();
                    }
                });
            }
        });
        this.cls_LeftButton.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 37) {
                    Util.runThread("BackClickedByKeyCode2", new Runnable(){

                        public void run() {
                            XpcButtonPanel.this.cls_XpcForm.backClicked();
                        }
                    });
                } else if (XpcButtonPanel.this.cls_RightButton != null && keyEvent.getKeyCode() == 39) {
                    Util.runThread("NextClickedByKeyCode2", new Runnable(){

                        public void run() {
                            XpcButtonPanel.this.cls_XpcForm.nextClicked();
                        }
                    });
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        jPanel.add((Component)this.cls_LeftButton, "West");
        this.cls_RightButton = new XpcButton(string2, xpcForm);
        this.cls_RightButton.setDefaultCapable(true);
        this.cls_RightButton.setVisible(string2 != null && string2.length() > 0);
        this.cls_RightButton.setRequestFocusEnabled(true);
        this.cls_RightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.runThread("NextClicked", new Runnable(){

                    public void run() {
                        XpcButtonPanel.this.cls_XpcForm.nextClicked();
                    }
                });
            }
        });
        this.cls_RightButton.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 39) {
                    Util.runThread("NextClickedByKeyCode", new Runnable(){

                        public void run() {
                            XpcButtonPanel.this.cls_XpcForm.nextClicked();
                        }
                    });
                } else if (XpcButtonPanel.this.cls_LeftButton != null && (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 37)) {
                    Util.runThread("BackClickedByKeyCode", new Runnable(){

                        public void run() {
                            XpcButtonPanel.this.cls_XpcForm.backClicked();
                        }
                    });
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        jPanel.add((Component)this.cls_RightButton, "East");
        this.add(jPanel);
        this.add(GuiUtil.getVerticalPadding(10));
    }

    public void populateFocusTraversal(XpcFocusTraversalPolicy xpcFocusTraversalPolicy) {
        if (this.cls_RightButton != null) {
            xpcFocusTraversalPolicy.addComponent(this.cls_RightButton);
        }
        if (this.cls_LeftButton != null) {
            xpcFocusTraversalPolicy.addComponent(this.cls_LeftButton);
        }
    }

    public JButton getRightButton() {
        return this.cls_RightButton;
    }

    public JButton getLeftButton() {
        return this.cls_LeftButton;
    }

    public JButton getDefaultButton() {
        if (this.getRightButton() != null) {
            return this.getRightButton();
        }
        if (this.getLeftButton() != null) {
            return this.getLeftButton();
        }
        return null;
    }

    public static class XpcButton
    extends JButton
    implements MouseListener {
        public static final long serialVersionUID = 1L;

        public XpcButton(String string, XpcForm xpcForm) {
            super(string);
            Dimension dimension;
            this.setDefaultCapable(true);
            this.setBackground(GuiConstants.COLOR_WORKAREA);
            this.setOpaque(false);
            this.addMouseListener(this);
            if (XpcComponentConstants.isMac()) {
                dimension = new Dimension(110, 32);
                this.setFont(BUTTON_FONT_MAC);
            } else {
                dimension = new Dimension(78, 24);
                this.setMargin(new Insets(3, 0, 3, 0));
            }
            this.setMaximumSize(dimension);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.setSize(dimension);
            if (xpcForm != null) {
                this.addKeyListener(new XpcKeyClickedDelegator(xpcForm));
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.setCursor(GuiConstants.CURSOR_HAND);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.setCursor(GuiConstants.CURSOR_DEFAULT);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

