/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlUtil2 {
    private static final Logger log = Logger.getLogger(XmlUtil2.class);
    private static final DocumentBuilder DOCUMENT_BUILDER;
    private static final TransformerFactory TRANSFORMER_FACTORY;

    public static final Document createDocument(String string) {
        Document document = DOCUMENT_BUILDER.newDocument();
        Element element = document.createElement(string);
        document.appendChild(element);
        return document;
    }

    public static final Element createRoot(Document document, String string) {
        Element element = document.createElement(string);
        document.appendChild(element);
        return element;
    }

    public static final Attr createAttribute(Document document, Element element, String string, String string2) {
        Attr attr = document.createAttribute(string);
        attr.setValue(string2);
        element.setAttributeNode(attr);
        return attr;
    }

    public static final Element createElement(Document document, String string) {
        return XmlUtil2.createElement(document, string, null);
    }

    public static final Element createElement(Document document, String string, boolean bl) {
        return XmlUtil2.createElement(document, string, bl ? "1" : "0");
    }

    public static final Element createElement(Document document, String string, String string2) {
        Element element = document.createElement(string);
        if (string2 != null) {
            element.setTextContent(string2);
        }
        return element;
    }

    public static final String getXml(Document document) {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            log.error((Object)"Error occurred while transforming XML Document object to string.", (Throwable)exception);
            return null;
        }
    }

    static {
        TRANSFORMER_FACTORY = TransformerFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        DOCUMENT_BUILDER = documentBuilder;
    }
}

