/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import com.cloudpath.common.util.BinaryUtil;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import sun.misc.BASE64Decoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilBasic {
    public static final long MILLIS_IN_SECOND = 1000L;
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final long SECONDS_IN_MINUTE = 60L;
    public static final long SECONDS_IN_HOUR = 3600L;
    public static final long SECONDS_IN_DAY = 86400L;
    public static final long SECONDS_IN_WEEK = 604800L;
    public static final long SECONDS_IN_MONTH = 2592000L;
    public static final SimpleDateFormat FULL_DATE = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss", Locale.US);
    public static final SimpleDateFormat FILE_DATE = new SimpleDateFormat("yyyyMMdd", Locale.US);
    public static final SimpleDateFormat FILE_DATE_GMT = new SimpleDateFormat("yyyyMMdd", Locale.US);
    public static final String CERT_HEADER = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_FOOTER = "-----END CERTIFICATE-----";

    public static boolean isBlank(String string) {
        return string == null || string.length() == 0;
    }

    public static String getNonNull(String string) {
        return string == null ? "" : string;
    }

    public static String replaceVariable(String string, String string2, String string3) {
        return UtilBasic.replaceVariable(string, string2, string3, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replaceVariables(String string, HashMap<String, String> hashMap, boolean bl) {
        if (string != null && string.contains("${") && hashMap != null) {
            HashMap<String, String> hashMap2 = hashMap;
            synchronized (hashMap2) {
                Set<String> set = hashMap.keySet();
                String[] stringArray = new String[set.size()];
                hashMap.keySet().toArray(stringArray);
                for (int i = 0; i < stringArray.length; ++i) {
                    string = UtilBasic.replaceVariable(string, stringArray[i], hashMap.get(stringArray[i]), bl);
                }
            }
        }
        return string;
    }

    public static String replaceVariablesWithSmartUrl(String string, HashMap<String, String> hashMap) {
        if (string != null && string.length() > 0 && (string.toUpperCase().startsWith("HTTP://") || string.toUpperCase().startsWith("HTTPS://"))) {
            String[] stringArray = string.split("\\?");
            String string2 = "";
            if (stringArray != null && stringArray.length > 0) {
                string2 = string2 + UtilBasic.replaceVariables(stringArray[0], hashMap, false);
            }
            for (int i = 1; stringArray != null && i < stringArray.length; ++i) {
                string2 = string2 + "?" + UtilBasic.replaceVariables(stringArray[i], hashMap, true);
            }
            return string2;
        }
        String string3 = UtilBasic.replaceVariables(string, hashMap, true);
        if (string3 != null && (string3.toUpperCase().startsWith("HTTP%3A%2F%2F") || string3.toUpperCase().startsWith("HTTPS%3A%2F%2F"))) {
            return UtilBasic.replaceVariables(string, hashMap, false);
        }
        return string3;
    }

    public static String replaceVariable(String string, String string2, String string3, boolean bl) {
        if (string3 != null && !bl) {
            string3 = string3.replaceAll("\\Q\\\\E", "\\\\\\\\");
            string3 = string3.replaceAll("\\Q$\\E", "\\\\\\$");
        }
        string = string != null ? string : "";
        string3 = string3 != null ? string3 : "";
        String string4 = string2 = string2 != null ? string2 : "";
        if (bl) {
            try {
                string3 = URLEncoder.encode(string3, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string.replaceAll("\\Q${" + string2 + "}\\E", string3);
    }

    public static final Thread runThread(String string, Runnable runnable) {
        return UtilBasic.runThread(Thread.currentThread().getThreadGroup(), string, runnable);
    }

    public static final Thread runThread(ThreadGroup threadGroup, String string, Runnable runnable) {
        Thread thread = new Thread(threadGroup, runnable);
        thread.setName(string);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public static final String createToString(Class<?> clazz) {
        return UtilBasic.createToString(clazz, null, null);
    }

    public static final String createToString(Class<?> clazz, String string, Object object) {
        return "[" + UtilBasic.getShortName(clazz) + (string != null ? " " + string + "=" + object : "") + "]";
    }

    public static final String join(long[] lArray) {
        String[] stringArray = new String[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            stringArray[i] = "" + lArray[i];
        }
        return UtilBasic.join(stringArray);
    }

    public static final String join(String[] stringArray) {
        return UtilBasic.join(stringArray, '\n');
    }

    public static final String join(String[] stringArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(c);
                }
                stringBuffer.append(stringArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public static final String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    public static String getShortName(Class<?> clazz) {
        if (clazz == null) {
            return "[NULL]";
        }
        int n = clazz.getName().lastIndexOf(46);
        n = n >= 0 ? n + 1 : 0;
        return clazz.getName().substring(n);
    }

    public static String getClassName(Object object) {
        return object != null ? UtilBasic.getShortName(object.getClass()) : "NULL";
    }

    public static boolean contains(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0 || string == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static void deleteOnExit(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    UtilBasic.deleteOnExit(fileArray[i]);
                }
            }
            file.deleteOnExit();
        }
    }

    public static void delete(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    UtilBasic.delete(fileArray[i]);
                }
            }
            file.delete();
        }
    }

    public static void unzip(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[512];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
    }

    public static String trimQuotes(String string) {
        if (string != null) {
            if (string.startsWith("\"")) {
                string = string.substring(1);
            }
            if (string.indexOf("\"") > 0) {
                string = string.substring(0, string.indexOf("\""));
            }
        }
        return string;
    }

    public static int convertHex(String string, int n) {
        try {
            return Integer.parseInt(string, 16);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static Color getColor(String string) {
        int n = UtilBasic.convertHex(string, 0);
        return new Color(n);
    }

    public static File getTempDirectory() {
        String string = System.getProperty("java.io.tmpdir");
        return new File(string);
    }

    public static final String generateGuid() {
        return UUID.randomUUID().toString().toUpperCase(Locale.US);
    }

    public static String getSplitLines(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = string;
        string2 = string2.replaceAll("\n", "<br>");
        string2 = string2.replaceAll("//", "<br>");
        string2 = string2.replaceAll("http:<br>", "http://");
        string2 = string2.replaceAll("https:<br>", "https://");
        return string2;
    }

    public static String formatCertificateThumbprint(String string) {
        if (string == null) {
            string = "";
        }
        return string.replace(":", "").replace(" ", "").toUpperCase();
    }

    public static String getThumbprintFromCertFile(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        return UtilBasic.getThumbprintFromCert(fileInputStream);
    }

    public static String getThumbprintFromCert(String string) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return UtilBasic.getThumbprintFromCert(byteArrayInputStream);
    }

    public static String getThumbprintFromCert(InputStream inputStream) throws Exception {
        String string = "";
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try {
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(inputStream);
            Iterator<? extends Certificate> iterator = collection.iterator();
            if (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                string = UtilBasic.getThumbprint(x509Certificate);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        inputStream.close();
        return string;
    }

    private static String getThumbprint(Certificate certificate) throws Exception {
        byte[] byArray = certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        byte[] byArray2 = messageDigest.digest(byArray);
        return BinaryUtil.convertToHexByBytes(byArray2, false);
    }

    public static X509Certificate getCertificateFromFile(InputStream inputStream) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            return x509Certificate;
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
            return null;
        }
    }

    public static X509Certificate[] getCertificatesFromFile(InputStream inputStream) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(inputStream);
            X509Certificate[] x509CertificateArray = new X509Certificate[collection.size()];
            collection.toArray(x509CertificateArray);
            return x509CertificateArray;
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
            return null;
        }
    }

    public static X509Certificate[] getCertificatesFromBase64(String string) throws Exception {
        string = string.replace(CERT_HEADER, "");
        string = string.replace(CERT_FOOTER, "");
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray = bASE64Decoder.decodeBuffer(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
        return UtilBasic.getCertificatesFromFile(bufferedInputStream);
    }

    public static Pattern convertRegexToPattern(String string) {
        Pattern pattern = null;
        if (string != null && string.length() != 0) {
            pattern = "*".equals(string) ? Pattern.compile(".*") : Pattern.compile(string);
        }
        return pattern;
    }

    static {
        FILE_DATE_GMT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

