/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import com.cloudpath.common.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;

public abstract class UrlLoader {
    private static final Logger log = Logger.getLogger(UrlLoader.class);

    public static UrlResponse getTextFileFromUrl(String string) {
        return UrlLoader.getTextFileFromUrl(string, 40000L);
    }

    public static UrlResponse getTextFileFromUrl(String string, long l) {
        Object object;
        log.debug((Object)("Will load text file from '" + string + "'."));
        UrlHandler urlHandler = new UrlHandler(string);
        if (l > 0L) {
            object = Util.runThread("Load_URL_" + string, urlHandler);
            try {
                ((Thread)object).join(l);
            }
            catch (InterruptedException interruptedException) {
                while (((Thread)object).isAlive()) {
                    System.err.println("Sleeping for url wait.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            urlHandler.run();
        }
        object = urlHandler.getResponse();
        if (object == null) {
            object = new UrlResponse(UrlResponse.UrlResponseType.ERROR_404);
        }
        return object;
    }

    public static void getBytesFromUrl(URL uRL, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        UrlLoader.getBytesFromUrl(uRL, fileOutputStream, null);
        fileOutputStream.close();
    }

    public static void getBytesFromUrl(URL uRL, File file, DownloadListener downloadListener) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        UrlLoader.getBytesFromUrl(uRL, fileOutputStream, downloadListener);
        fileOutputStream.close();
    }

    public static void getBytesFromUrl(URL uRL, OutputStream outputStream, DownloadListener downloadListener) throws IOException {
        log.debug((Object)("Will get bytes from URL: " + uRL));
        URLConnection uRLConnection = uRL.openConnection();
        log.info((Object)("Http Response Headers: " + uRLConnection.getHeaderFields()));
        log.info((Object)("Http Response Code: " + ((HttpURLConnection)uRLConnection).getResponseCode() + " - " + ((HttpURLConnection)uRLConnection).getResponseMessage()));
        uRLConnection.setReadTimeout(360000);
        String string = uRLConnection.getContentType();
        int n = uRLConnection.getContentLength();
        if (string != null && (string.startsWith("text/") || n == -1)) {
            log.warn((Object)("URL '" + uRL + "' is not a binary file. (" + string + ", " + n + ")"));
        }
        if (n < 0) {
            n = 0;
        }
        int n2 = 100000000;
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        log.debug((Object)("Download Size: " + n));
        int n3 = n < n2 ? n : n2;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n5 < n && (n4 = ((InputStream)bufferedInputStream).read(byArray, n7, n - n5 > byArray.length - n7 ? byArray.length - n7 : n - n5)) != -1) {
            n5 += n4;
            n7 += n4;
            ++n6;
            if (downloadListener != null) {
                downloadListener.updateDownload(n5, n);
            }
            if (n7 != byArray.length) continue;
            outputStream.write(byArray);
            n7 = 0;
            byArray = new byte[n3];
        }
        if (n7 != 0) {
            outputStream.write(byArray, 0, n7);
        }
        ((InputStream)bufferedInputStream).close();
        outputStream.flush();
        if (n5 != n) {
            throw new IOException("Only read " + n5 + " bytes; Expected " + n + " bytes");
        }
    }

    public static interface DownloadListener {
        public void updateDownload(int var1, int var2);
    }

    public static class UrlHandler
    implements Runnable {
        private final String cls_Url;
        private UrlResponse cls_Response = null;

        public UrlHandler(String string) {
            this.cls_Url = string;
        }

        public UrlResponse getResponse() {
            return this.cls_Response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            String string;
            BufferedReader bufferedReader = null;
            URL uRL = new URL(this.cls_Url);
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            this.cls_Response = new UrlResponse(stringBuffer.toString());
            Object var6_8 = null;
            if (bufferedReader == null) return;
            try {
                bufferedReader.close();
                return;
            }
            catch (Exception exception) {}
            return;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    log.debug((Object)("File not found at url " + this.cls_Url), (Throwable)fileNotFoundException);
                    this.cls_Response = new UrlResponse(UrlResponse.UrlResponseType.ERROR_404);
                    Object var6_9 = null;
                    if (bufferedReader == null) return;
                    try {
                        bufferedReader.close();
                        return;
                    }
                    catch (Exception exception) {}
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    log.warn((Object)("URL '" + this.cls_Url + "' is invalid."), (Throwable)malformedURLException);
                    this.cls_Response = null;
                    Object var6_10 = null;
                    if (bufferedReader == null) return;
                    try {
                        bufferedReader.close();
                        return;
                    }
                    catch (Exception exception) {}
                    return;
                }
                catch (IOException iOException) {
                    log.warn((Object)("Error occurred while loading text file from URL " + this.cls_Url + "."), (Throwable)iOException);
                    this.cls_Response = null;
                    Object var6_11 = null;
                    if (bufferedReader == null) return;
                    try {
                        bufferedReader.close();
                        return;
                    }
                    catch (Exception exception) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static class UrlResponse {
        private final UrlResponseType cls_UrlResponseType;
        private final String cls_Output;

        UrlResponse(UrlResponseType urlResponseType) {
            this.cls_UrlResponseType = urlResponseType;
            this.cls_Output = null;
        }

        UrlResponse(String string) {
            this.cls_UrlResponseType = UrlResponseType.OK;
            this.cls_Output = string;
        }

        public boolean isSuccessful() {
            return this.cls_UrlResponseType == UrlResponseType.OK;
        }

        public boolean is404() {
            return this.cls_UrlResponseType == UrlResponseType.ERROR_404;
        }

        public String getOutput() {
            return this.cls_Output;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum UrlResponseType {
            OK,
            ERROR_404;

        }
    }
}

