/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import com.cloudpath.common.util.OsInfo;

public class OsConstants {
    public static final String OS_WINDOWS = "windows";
    public static final String VERSION_2000 = "5.0";
    public static final String VERSION_XP = "5.1";
    public static final String VERSION_2003 = "5.2";
    public static final String VERSION_VISTA = "6.0";
    public static final String OS_MAC = "mac";
    public static final String VERSION_PUMA = "10.1";
    public static final String VERSION_JAGUAR = "10.2";
    public static final String VERSION_PANTHER = "10.3";
    public static final String VERSION_TIGER = "10.4";
    public static final String VERSION_LEOPARD = "10.5";
    public static final String VERSION_SNOW_LEOPARD = "10.6";
    public static final String VERSION_LION = "10.7";
    public static final String VERSION_MTN_LION = "10.8";
    public static final String VERSION_MAVERICKS = "10.9";
    public static final String VERSION_YOSEMITE = "10.10";
    public static final String VERSION_EL_CAPITAN = "10.11";
    private static final OsInfo OS_INFO = new OsInfo();

    public static boolean isMac() {
        return OS_INFO.isMac();
    }

    public static boolean isMacTigerOrBefore() {
        return OS_INFO.isMacTigerOrBefore();
    }

    public static boolean isMacTigerOrLater() {
        return OS_INFO.isMacTigerOrLater();
    }

    public static boolean isMacLeopardOrBefore() {
        return OS_INFO.isMacLeopardOrBefore();
    }

    public static boolean isMacLeopardOrLater() {
        return OS_INFO.isMacLeopardOrLater();
    }

    public static boolean isMacSnowLeopardOrBefore() {
        return OS_INFO.isMacSnowLeopardOrBefore();
    }

    public static boolean isMacSnowLeopardOrLater() {
        return OS_INFO.isMacSnowLeopardOrLater();
    }

    public static boolean isMacLionOrLater() {
        return OS_INFO.isMacLionOrLater();
    }

    public static boolean isMacMountainLionOrLater() {
        return OS_INFO.isMacMountainLionOrLater();
    }

    public static boolean isMacPuma() {
        return OS_INFO.isMacPuma();
    }

    public static boolean isMacJaguar() {
        return OS_INFO.isMacJaguar();
    }

    public static boolean isMacPanther() {
        return OS_INFO.isMacPanther();
    }

    public static boolean isMacTiger() {
        return OS_INFO.isMacTiger();
    }

    public static boolean isMacLeopard() {
        return OS_INFO.isMacLeopard();
    }

    public static boolean isMacSnowLeopard() {
        return OS_INFO.isMacSnowLeopard();
    }

    public static boolean isMacLeopardBeforeUpdate4() {
        return OS_INFO.isMacLeopardBeforeUpdate4();
    }

    public static boolean isMacSnowLeopardUpdate2OrGreater() {
        return OS_INFO.isMacSnowLeopardUpdate2OrGreater();
    }

    public static boolean isMacLion() {
        return OS_INFO.isMacLion();
    }

    public static boolean isMacMountainLion() {
        return OS_INFO.isMacMountainLion();
    }

    public static boolean isBeforeMacMountainLionUpdate2() {
        return OS_INFO.isBeforeMacMountainLionUpdate2();
    }

    public static boolean isMacMavericks() {
        return OS_INFO.isMacMavericks();
    }

    public static boolean isMacMavericksOrGreater() {
        return OS_INFO.isMacMavericksOrLater();
    }

    public static boolean isMacYosemite() {
        return OS_INFO.isMacYosemite();
    }

    public static boolean isMacYosemiteOrGreater() {
        return OS_INFO.isMacYosemiteOrLater();
    }

    public static boolean isMacElCapitan() {
        return OS_INFO.isMacElCapitan();
    }

    public static boolean isMacElCapitanOrGreater() {
        return OS_INFO.isMacElCapitanOrLater();
    }

    public static boolean isWindows() {
        return OS_INFO.isWindows();
    }

    public static boolean isWindowsXp() {
        return OS_INFO.isWindowsXp();
    }

    public static boolean isWindowsVista() {
        return OS_INFO.isWindowsVista();
    }

    public static boolean isWindows2000() {
        return OS_INFO.isWindows2000();
    }

    public static boolean isWindows2003() {
        return OS_INFO.isWindows2003();
    }

    public static boolean isWindowsXpOrBefore() {
        return OS_INFO.isWindowsXpOrBefore();
    }

    public static boolean isWindows2000OrLater() {
        return OS_INFO.isWindows2000OrLater();
    }

    public static boolean isWindowsXpOrLater() {
        return OS_INFO.isWindowsXpOrLater();
    }

    public static boolean isWindowsVistaOrLater() {
        return OS_INFO.isWindowsVistaOrLater();
    }

    public static final OsInfo getOsInfo() {
        return OS_INFO;
    }

    public static final OsInfo createMacPuma() {
        return new OsInfo(OS_MAC, VERSION_PUMA);
    }

    public static final OsInfo createMacJaguar() {
        return new OsInfo(OS_MAC, VERSION_JAGUAR);
    }

    public static final OsInfo createMacPanther() {
        return new OsInfo(OS_MAC, VERSION_PANTHER);
    }

    public static final OsInfo createMacTiger() {
        return new OsInfo(OS_MAC, VERSION_TIGER);
    }

    public static final OsInfo createMacLeopard() {
        return new OsInfo(OS_MAC, VERSION_LEOPARD);
    }

    public static final OsInfo createWindowsXp() {
        return new OsInfo(OS_WINDOWS, VERSION_XP);
    }

    public static final OsInfo createWindowsVista() {
        return new OsInfo(OS_WINDOWS, VERSION_VISTA);
    }

    public static String getMacFriendlyName(String string) {
        if (VERSION_PUMA.equals(string)) {
            return "Puma";
        }
        if (VERSION_JAGUAR.equals(string)) {
            return "Jaguar";
        }
        if (VERSION_PANTHER.equals(string)) {
            return "Panther";
        }
        if (VERSION_TIGER.equals(string)) {
            return "Tiger";
        }
        if (VERSION_LEOPARD.equals(string)) {
            return "Leopard";
        }
        if (VERSION_SNOW_LEOPARD.equals(string)) {
            return "Snow Leopard";
        }
        if (VERSION_LION.equals(string)) {
            return "Lion";
        }
        if (VERSION_MTN_LION.equals(string)) {
            return "Mountain Lion";
        }
        if (VERSION_MAVERICKS.equals(string)) {
            return "Mavericks";
        }
        if (VERSION_YOSEMITE.equals(string)) {
            return "Yosemite";
        }
        if (VERSION_EL_CAPITAN.equals(string)) {
            return "El Capitan";
        }
        return "Unknown";
    }

    public static String getWindowsFriendlyName(String string, long l, String string2) {
        String string3 = "Windows ";
        string3 = string.matches("5.1.*") ? string3 + "XP" : (string.matches("6.0.*") ? (string2 != null && (string2.equals("2") || string2.equals("3")) ? string3 + "2008" : string3 + "Vista") : (string.matches("5.2.*") ? string3 + "2003" : (string.matches("5.0.*") ? string3 + "2000" : (string.matches("4.*") ? string3 + "NT 4.0" : (string.matches("3.*") ? string3 + "NT 3.51" : string3 + string)))));
        string3 = string3 + " SP" + l;
        return string3;
    }

    public static String getInfo() {
        return "[OS: " + System.getProperty("os.name") + " - " + System.getProperty("os.version") + "]";
    }
}

