/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import com.cloudpath.common.util.BanishedWords;
import com.cloudpath.common.util.JnlpUtil;
import com.cloudpath.common.util.Resources;
import com.cloudpath.common.util.Util;
import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class LogUtil {
    private static final Logger log = Logger.getLogger(LogUtil.class);
    public static File LOG_FILE = null;

    public static void logToTempDirectory() {
        log.debug((Object)"Will start logging to temp directory.");
        File file = new File(Util.getTempDirectory(), Resources.ResourceString.PRODUCT_NAME.getValue());
        LogUtil.logToDirectory(file);
    }

    public static void logToDirectory(File file) {
        try {
            LOG_FILE = new File(file, Resources.ResourceString.PRODUCT_NAME.getValue() + ".log");
            log.info((Object)("Will log to " + LOG_FILE.getAbsolutePath() + "."));
            BanishedWords.BanishedWordFileAppender banishedWordFileAppender = new BanishedWords.BanishedWordFileAppender();
            banishedWordFileAppender.setName("TempDirectoryAppender");
            banishedWordFileAppender.setAppend(LOG_FILE.length() < 50000000L);
            banishedWordFileAppender.setFile(LOG_FILE.getAbsolutePath());
            System.out.println("Will log to: " + LOG_FILE.getAbsolutePath());
            banishedWordFileAppender.setLayout((Layout)new PatternLayout("%d{MMddyy HH:mm:ss} %-5p: %m %x (%F:%L-%t)%n"));
            banishedWordFileAppender.activateOptions();
            System.getProperties().setProperty("cpn.log", LOG_FILE.getAbsolutePath());
            Logger.getRootLogger().addAppender((Appender)banishedWordFileAppender);
            Logger logger = Logger.getLogger(LogUtil.class);
            logger.warn((Object)("Starting...\n   " + Resources.ResourceString.PRODUCT_NAME.getValue() + '\n' + "   Version 5.0.255\n" + "   By " + Resources.ResourceString.COMPANY_NAME.getValue() + '\n' + "   " + Resources.ResourceString.COPYRIGHT.getValue() + '\n' + "   Java Version: " + System.getProperty("java.vm.version") + '\n' + "   OS Version: " + System.getProperty("os.version") + '\n' + "   Architecture: " + System.getProperty("os.arch") + '\n' + "   Code Base: " + JnlpUtil.getCodeBase() + '\n' + "   For support, contact " + Resources.ResourceString.PRODUCT_SUPPORT_EMAIL.getValue() + '\n'));
            try {
                logger.warn((Object)("OS Name: " + System.getProperty("os.name")));
                logger.warn((Object)("OS Version: " + System.getProperty("os.version")));
                logger.warn((Object)("OS Architecture: " + System.getProperty("os.arch")));
                logger.warn((Object)("Java Version: " + System.getProperty("java.version")));
                logger.warn((Object)("Java VM Version: " + System.getProperty("java.vm.version")));
                logger.warn((Object)("All Properties: " + System.getProperties().toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.warn((Object)("Logging to " + LOG_FILE.getAbsolutePath()));
        }
        catch (Exception exception) {
            log.error((Object)("Captured an error while initializing log in directory " + file.getAbsolutePath() + "."), (Throwable)exception);
        }
    }
}

