/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import java.io.IOException;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class IpAddress {
    public static final char WILDCARD_SYMBOL = '*';
    public static final int WILDCARD_MASK = 0;
    public static final char RANGE_SEPARATOR = '-';
    public static final char SUBNET_MASK = '/';
    public static final int NO_SUBNET_MASK = 32;
    private static final String WILDCARD_RANGE = "0.0.0.0-255.255.255.255";
    private final InetAddress cls_LowValue;
    private final InetAddress cls_HighValue;
    private final int cls_SubnetMask;
    private final String cls_SubnetMaskString;
    private final String cls_OriginalText;

    public IpAddress(String string) throws Exception {
        this(string, string);
    }

    private IpAddress(String string, String string2) throws Exception {
        this.cls_OriginalText = string;
        try {
            InetAddress[] inetAddressArray;
            if (string2.indexOf(42) == 0) {
                this.cls_SubnetMask = 0;
                this.cls_SubnetMaskString = "255.255.255.255";
                inetAddressArray = IpAddress.splitRange(WILDCARD_RANGE);
            } else if (string2.indexOf(47) >= 0) {
                this.cls_SubnetMask = IpAddress.getSubnetMask(string2);
                this.cls_SubnetMaskString = IpAddress.determineSubnetMask(this.cls_SubnetMask);
                inetAddressArray = IpAddress.parseSubnet(string2);
            } else {
                this.cls_SubnetMask = 32;
                this.cls_SubnetMaskString = "255.255.255.255";
                InetAddress inetAddress = InetAddress.getByName(string2);
                inetAddressArray = new InetAddress[]{inetAddress, inetAddress};
            }
            if (inetAddressArray == null || inetAddressArray.length < 2 || inetAddressArray[0] == null || inetAddressArray[1] == null) {
                throw new Exception("Unable to parse '" + string + "' into a range or subnet mask.");
            }
            if (IpAddress.isAfter(inetAddressArray[0], inetAddressArray[1])) {
                this.cls_LowValue = inetAddressArray[1];
                this.cls_HighValue = inetAddressArray[0];
            } else {
                this.cls_LowValue = inetAddressArray[0];
                this.cls_HighValue = inetAddressArray[1];
            }
        }
        catch (IOException iOException) {
            throw new Exception("Unable to parse '" + string + "' into a range or subnet mask.", iOException);
        }
    }

    public InetAddress getLowValue() {
        return this.cls_LowValue;
    }

    public InetAddress getHighValue() {
        return this.cls_HighValue;
    }

    public IpAddress[] getAllIpAddresses() {
        return new IpAddress[]{this};
    }

    public String getSubnetMaskString() {
        return this.cls_SubnetMaskString;
    }

    public boolean includes(IpAddress ipAddress) {
        if (ipAddress == null) {
            return false;
        }
        if (this == ipAddress) {
            return true;
        }
        if (this.isWildcard()) {
            return true;
        }
        IpAddress ipAddress2 = ipAddress;
        boolean bl = !IpAddress.isBefore(ipAddress2.getLowValue(), this.getLowValue()) && !IpAddress.isAfter(ipAddress2.getHighValue(), this.getHighValue());
        return bl;
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof IpAddress)) {
            return -1;
        }
        if (this.isWildcard() && !((IpAddress)object).isWildcard()) {
            return 1;
        }
        if (this.equals(object)) {
            return 0;
        }
        int n = this.compareTo((IpAddress)object);
        return n;
    }

    private int compareTo(IpAddress ipAddress) {
        if (!this.isWildcard() && ipAddress.isWildcard()) {
            return -1;
        }
        if (this.isWildcard() && !ipAddress.isWildcard()) {
            return 1;
        }
        IpAddress ipAddress2 = ipAddress;
        if (IpAddress.isSame(this.getLowValue(), ipAddress2.getLowValue())) {
            if (IpAddress.isSame(this.getHighValue(), ipAddress2.getHighValue())) {
                return 0;
            }
            if (IpAddress.isBefore(ipAddress2.getHighValue(), this.getHighValue())) {
                return 1;
            }
            if (IpAddress.isAfter(ipAddress2.getHighValue(), this.getHighValue())) {
                return -1;
            }
        } else {
            if (IpAddress.isBefore(ipAddress2.getLowValue(), this.getLowValue())) {
                return 1;
            }
            if (IpAddress.isAfter(ipAddress2.getLowValue(), this.getLowValue())) {
                return -1;
            }
        }
        return -1;
    }

    public boolean isSingleValue() {
        return !this.isWildcard() && (this.cls_SubnetMask == 32 || this.getLowValue().equals(this.getHighValue()));
    }

    public boolean isResolvable() {
        return false;
    }

    public boolean isWildcard() {
        return this.cls_SubnetMask == 0 || this.toString().equals(String.valueOf('*')) || this.toString().equals(WILDCARD_RANGE);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IpAddress)) {
            return false;
        }
        return this.getLowValue().equals(((IpAddress)object).getLowValue()) && this.getHighValue().equals(((IpAddress)object).getHighValue());
    }

    public static final String determineSubnetMask(int n) throws Exception {
        int n2;
        int n3 = n;
        if (n3 == 0) {
            return "255.255.255.255";
        }
        if (n3 > 32 || n3 < 0) {
            throw new Exception("Subnet Mask Integer: " + n3 + " is invalid.  Number should be between 0 and 32");
        }
        char[] cArray = new char[32];
        for (n2 = 0; n2 < cArray.length; ++n2) {
            cArray[n2] = 48;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            cArray[n2] = 49;
        }
        String string = new String(cArray);
        String string2 = new String(string.substring(0, 8));
        String string3 = new String(string.substring(8, 16));
        String string4 = new String(string.substring(16, 24));
        String string5 = new String(string.substring(24));
        int n4 = Integer.parseInt(string2, 2);
        int n5 = Integer.parseInt(string3, 2);
        int n6 = Integer.parseInt(string4, 2);
        int n7 = Integer.parseInt(string5, 2);
        String string6 = Integer.toString(n4) + "." + Integer.toString(n5) + "." + Integer.toString(n6) + "." + Integer.toString(n7);
        return string6;
    }

    public static final boolean isRange(String string) {
        return string != null && string.indexOf(47) >= 0;
    }

    public static final boolean isWildcard(String string) {
        return string != null && string.indexOf(42) >= 0;
    }

    protected static final InetAddress[] splitRange(String string) throws IOException, Exception {
        if (string != null) {
            int n = string.indexOf(45);
            if (n >= 0) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                if (string2 == null || string2.length() == 0) {
                    if (string3 == null || string3.length() == 0) {
                        throw new Exception("'" + string + "' is not a valid ip address range.");
                    }
                    string2 = string3;
                }
                if (string3 == null || string3.length() == 0) {
                    throw new Exception("'" + string + "' is not a valid ip address range.");
                }
                return new InetAddress[]{InetAddress.getByName(string2), InetAddress.getByName(string3)};
            }
        } else {
            throw new Exception("SplitRange cannont split null");
        }
        return null;
    }

    private static final int getSubnetMask(String string) throws Exception {
        int n;
        String[] stringArray = IpAddress.splitSubnet(string);
        try {
            n = Integer.valueOf(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Mask in ip address '" + string + "' is not valid.", numberFormatException);
        }
        return n;
    }

    protected static final InetAddress[] parseSubnet(String string) throws IOException, Exception {
        String[] stringArray = IpAddress.splitSubnet(string);
        if (stringArray == null || stringArray.length < 1) {
            throw new Exception("Unsplittable subnet value:" + string);
        }
        String string2 = stringArray[0];
        int n = IpAddress.getSubnetMask(string);
        if (!IpAddress.isMaskValid(n)) {
            throw new Exception("Mask '" + n + "' is not valid.");
        }
        string2 = IpAddress.padIpToMask(string2, n);
        String[] stringArray2 = IpAddress.getBoundryIpAddresses(string2, n);
        String string3 = stringArray2[0];
        String string4 = stringArray2[1];
        byte[] byArray = IpAddress.toBytes(string3);
        byte[] byArray2 = IpAddress.toBytes(string4);
        return new InetAddress[]{InetAddress.getByAddress(byArray), InetAddress.getByAddress(byArray2)};
    }

    protected static final String[] splitSubnet(String string) {
        int n = string.indexOf(47);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return new String[]{string2, string3};
        }
        return null;
    }

    protected static final boolean isMaskValid(int n) {
        return n >= 0 && n <= 32;
    }

    protected static final String padIpToMask(String string, int n) {
        byte[] byArray = IpAddress.toBytes(string);
        return IpAddress.convertByte(byArray[0]) + "." + IpAddress.convertByte(byArray[1]) + "." + IpAddress.convertByte(byArray[2]) + "." + IpAddress.convertByte(byArray[3]);
    }

    protected static final int convertByte(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }

    protected static final boolean isSame(InetAddress inetAddress, InetAddress inetAddress2) {
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = inetAddress2.getAddress();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    protected static final boolean isBefore(InetAddress inetAddress, InetAddress inetAddress2) {
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = inetAddress2.getAddress();
        for (int i = 0; i < byArray.length; ++i) {
            int n = IpAddress.convertByte(byArray[i]) - IpAddress.convertByte(byArray2[i]);
            if (n < 0) {
                return true;
            }
            if (n <= 0) continue;
            return false;
        }
        return false;
    }

    protected static final boolean isAfter(InetAddress inetAddress, InetAddress inetAddress2) {
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = inetAddress2.getAddress();
        for (int i = 0; i < byArray.length; ++i) {
            int n = IpAddress.convertByte(byArray[i]) - IpAddress.convertByte(byArray2[i]);
            if (n > 0) {
                return true;
            }
            if (n >= 0) continue;
            return false;
        }
        return false;
    }

    protected static final String[] getBoundryIpAddresses(String string, int n) throws Exception {
        String string2;
        String string3 = "255";
        String string4 = IpAddress.determineSubnetMask(n);
        boolean bl = false;
        String[] stringArray = IpAddress.getOctetArrayAsStrings(string4);
        String[] stringArray2 = IpAddress.getOctetArrayAsStrings(string);
        String[] stringArray3 = new String[4];
        String[] stringArray4 = new String[4];
        if (stringArray.length != 4 || stringArray2.length != 4) {
            throw new Exception("Error occured while processing ip address in IpAddressRange.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            String string5 = stringArray2[i];
            if (string2.equals("255")) {
                stringArray3[i] = string5;
                stringArray4[i] = string5;
            } else if (string2.equals("0")) {
                bl = true;
            } else {
                Integer n2 = new Integer(string2);
                byte by = n2.byteValue();
                int n3 = ~by;
                int n4 = new Integer(string5) | n3;
                stringArray3[i] = String.valueOf(n4);
                n4 = new Integer(string5) & by;
                stringArray4[i] = String.valueOf(n4);
                bl = true;
                ++i;
            }
            if (!bl) continue;
            for (int j = i; j < 4; ++j) {
                stringArray3[j] = string3;
                stringArray4[j] = "0";
            }
            i = 4;
        }
        String string6 = stringArray3[0] + "." + stringArray3[1] + "." + stringArray3[2] + "." + stringArray3[3];
        string2 = stringArray4[0] + "." + stringArray4[1] + "." + stringArray4[2] + "." + stringArray4[3];
        return new String[]{string2, string6};
    }

    protected static final String[] getOctetArrayAsStrings(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.trim(), ".");
        if (stringTokenizer.countTokens() > 4) {
            return null;
        }
        String[] stringArray = new String[4];
        int n = 0;
        int n2 = stringTokenizer.countTokens();
        for (n = 0; n < n2; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
            Integer n3 = new Integer(stringArray[n]);
            if (n3 <= 255 && n3 >= 0) continue;
            throw new Exception(" The value: " + stringArray[n] + " is not valid for an IP address");
        }
        if (n < 4) {
            while (n < 4) {
                stringArray[n] = "0";
                ++n;
            }
        }
        return stringArray;
    }

    public static IpAddress determineBroadcast(IpAddress ipAddress, IpAddress ipAddress2) throws Exception {
        byte[] byArray;
        String string = "";
        byte[] byArray2 = IpAddress.toBytes(ipAddress.toString());
        if (byArray2.length == (byArray = IpAddress.toBytes(ipAddress2.toString())).length && byArray2.length == 4) {
            byte[] byArray3 = new byte[byArray2.length];
            byte[] byArray4 = new byte[byArray2.length];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray3[i] = ~byArray[i];
            }
            int[] nArray = new int[byArray2.length];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray4[i] = (byte)(byArray2[i] & byArray[i]);
                int n = i;
                byArray4[n] = (byte)(byArray4[n] | byArray3[i]);
                nArray[i] = byArray4[i] < 0 ? byArray4[i] + 256 : byArray4[i];
            }
            string = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        }
        return new IpAddress(string);
    }

    public static byte[] toBytes(String string) {
        byte[] byArray = new byte[4];
        if (string == null) {
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            byArray[3] = 0;
        } else {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                String string2;
                int n2 = string.indexOf(46, n);
                if (n2 < 0) {
                    string2 = string.substring(n);
                    byArray[i] = string2 != null && string2.length() > 0 ? (byte)Long.parseLong(string2) : (byte)0;
                    n = string.length();
                    continue;
                }
                string2 = string.substring(n, n2);
                byArray[i] = (byte)Long.parseLong(string2);
                n = n2 + 1;
            }
        }
        return byArray;
    }

    public String toString() {
        return this.cls_OriginalText;
    }
}

