/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;

public class FileUtil
implements FileHandler {
    private static final Logger log = Logger.getLogger(FileUtil.class);
    private static boolean LOGGED_TMP_DIR = false;

    public boolean exists(File file) {
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public String readFile(File file) throws IOException {
        return FileUtil.read(file);
    }

    public void writeFile(File file, String string) throws IOException {
        FileUtil.write(file.getAbsolutePath(), string);
    }

    public static final String read(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("Unable to find file " + file.getAbsolutePath() + ".");
        }
        return FileUtil.readStream(new FileInputStream(file));
    }

    public static final String read(String string) throws IOException {
        InputStream inputStream = FileUtil.class.getResourceAsStream("/" + string);
        if (inputStream == null) {
            throw new IOException("Unable to locate resource /" + string);
        }
        return FileUtil.readStream(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readBytes(String string) throws IOException {
        byte[] byArray;
        block7: {
            InputStream inputStream;
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if ((inputStream = FileUtil.class.getResourceAsStream(string)) == null) {
                throw new IOException("Unable to locate resource " + string);
            }
            try {
                byArray = FileUtil.readStreamAsBytes(inputStream);
                Object var4_3 = null;
                if (inputStream == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var4_4 = null;
                    if (inputStream == null) break block8;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    public static final byte[] readBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        if (fileInputStream == null) {
            throw new IOException("Unable to locate resource " + file.getAbsolutePath());
        }
        return FileUtil.readStreamAsBytes(fileInputStream);
    }

    public static final byte[] readBytes(InputStream inputStream) throws IOException {
        return FileUtil.readStreamAsBytes(inputStream);
    }

    public static final boolean write(File file, String string) throws IOException {
        return FileUtil.write(file != null ? file.getAbsolutePath() : "", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean write(String string, String string2) throws IOException {
        File file;
        block7: {
            file = new File(string);
            if (!OsConstants.isWindows() && (file.exists() && !file.canWrite() || !file.exists() && file.getParentFile() != null && !file.getParentFile().canWrite())) {
                new RuntimeException("Cannot write file to " + file.getAbsolutePath() + "'.  This call needs migrated to the new mechanism.");
            } else {
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(string2.getBytes());
                    fileOutputStream.write(10);
                    Object var5_4 = null;
                    if (fileOutputStream == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    throw throwable;
                }
                fileOutputStream.close();
            }
        }
        if (!file.exists()) {
            log.error((Object)"New file does not exist after attempting to write it.");
        }
        return file.exists();
    }

    public static final String unsterilizeFileName(String string) {
        string = string.replace("_11", "/");
        string = string.replace("_10", "!");
        string = string.replace("_09", ".");
        string = string.replace("_08", "|");
        string = string.replace("_07", "<");
        string = string.replace("_06", ">");
        string = string.replace("_05", "\"");
        string = string.replace("_04", "?");
        string = string.replace("_03", "*");
        string = string.replace("_02", ":");
        string = string.replace("_01", "\\");
        string = string.replace("_00", "_");
        return string;
    }

    public static final String sterilizeFileName(String string) {
        string = string.replace("_", "_00");
        string = string.replace("\\", "_01");
        string = string.replace(":", "_02");
        string = string.replace("*", "_03");
        string = string.replace("?", "_04");
        string = string.replace("\"", "_05");
        string = string.replace(">", "_06");
        string = string.replace("<", "_07");
        string = string.replace("|", "_08");
        string = string.replace(".", "_09");
        string = string.replace("!", "_10");
        string = string.replace("/", "_11");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readStream(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer;
        block8: {
            stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = null;
            try {
                String string;
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                boolean bl = true;
                while ((string = bufferedReader.readLine()) != null) {
                    if (!bl) {
                        stringBuffer.append('\n');
                    } else {
                        bl = false;
                    }
                    stringBuffer.append(string);
                }
                Object var6_5 = null;
                if (bufferedReader == null) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                throw throwable;
            }
            bufferedReader.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readStreamUtf16(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer;
        block8: {
            stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = null;
            try {
                String string;
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-16"));
                boolean bl = true;
                while ((string = bufferedReader.readLine()) != null) {
                    if (!bl) {
                        stringBuffer.append('\n');
                    } else {
                        bl = false;
                    }
                    stringBuffer.append(string);
                }
                Object var6_5 = null;
                if (bufferedReader == null) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                throw throwable;
            }
            bufferedReader.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        return stringBuffer.toString();
    }

    public static final byte[] readStreamAsBytes(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        try {
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void writeFileBytes(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = null;
        if (byArray == null) return;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray, 0, byArray.length);
            Object var4_3 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File moveFileToTemp(String string, String string2) throws IOException {
        IOException iOException3;
        FileOutputStream fileOutputStream;
        File file;
        block16: {
            if (string2 != null && string2.length() > 0 && string2.charAt(0) != '.') {
                string2 = "." + string2;
            }
            log.debug((Object)("[CPN~] Will move file " + string + string2 + " to temp."));
            file = null;
            BufferedInputStream bufferedInputStream = null;
            fileOutputStream = null;
            try {
                int n = string.lastIndexOf(File.separatorChar);
                String string3 = n >= 0 ? string.substring(n + 1, string.length()) : string;
                log.debug((Object)("[CPN~]   - Will create temp file as " + string3 + string2));
                file = File.createTempFile(string3, string2);
                InputStream inputStream = Util.class.getResourceAsStream("/" + string + string2);
                if (inputStream == null) {
                    throw new FileNotFoundException("The resource " + string + string2 + " was not located in the classpath.  This will prevent SSL communication from occurring.");
                }
                bufferedInputStream = new BufferedInputStream(inputStream);
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[4096];
                int n2 = 0;
                while ((n2 = bufferedInputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n2);
                }
                Object var11_10 = null;
                if (bufferedInputStream == null) break block16;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var11_11 = null;
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (file != null && file.exists()) {
                    file.deleteOnExit();
                }
                throw throwable;
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (file != null && file.exists()) {
            file.deleteOnExit();
        }
        return file;
    }

    public static void unzipFileToFolder(String string, File file, CommandHandler commandHandler) throws IOException {
        File file2 = FileUtil.moveFileToTemp(string, ".zip");
        log.debug((Object)("[CPN~] File " + string + ".zip moved to " + file2.getAbsolutePath()));
        FileUtil.unzipFileToFolder(file2, file, commandHandler);
    }

    public static void unzipFileToFolder(File file, File file2, CommandHandler commandHandler) throws IOException {
        if (OsConstants.isWindows()) {
            ZipFile zipFile = new ZipFile(file);
            log.info((Object)("[CPN~] Destination: " + file2.getAbsolutePath()));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) {
                    log.debug((Object)("[CPN~]  - Making directory: " + zipEntry.getName()));
                    new File(file2, zipEntry.getName()).mkdirs();
                    continue;
                }
                File file3 = new File(file2 + File.separator + zipEntry.getName());
                log.debug((Object)("[CPN~]  - Making file: " + file3.getAbsolutePath()));
                if (file3.getParentFile() != null) {
                    file3.getParentFile().mkdirs();
                }
                Util.unzip(zipFile.getInputStream(zipEntry), file3);
            }
        } else if (OsConstants.isMacLeopardOrBefore()) {
            log.info((Object)"[CPN~] Will unzip using command line to preserve permissions.");
            if (!file2.exists()) {
                file2.mkdirs();
            }
            log.info((Object)("Will unzip: " + file.getAbsolutePath()));
            CommandResponse commandResponse = commandHandler.executeCommand(new String[]{"/usr/bin/unzip", "-o", file.getAbsolutePath(), "-d", file2.getAbsolutePath()});
            log.debug((Object)"Will wait for unzip to complete....");
            long l = System.currentTimeMillis();
            commandResponse.waitFor();
            long l2 = System.currentTimeMillis();
            log.debug((Object)("Done waiting for unzip. (" + (l2 - l) + ")"));
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info((Object)("Will set execute bit on '" + file2.getAbsolutePath() + "'."));
            commandResponse = commandHandler.executeCommand(new String[]{"/bin/chmod", "-R", "+x", file2.getAbsolutePath()});
            commandResponse.waitFor();
            log.info((Object)Util.join(commandResponse.getError()));
            log.info((Object)Util.join(commandResponse.getOutput()));
        } else {
            log.info((Object)"[CPN~] Will unzip using command line to preserve permissions.");
            if (!file2.exists()) {
                file2.mkdirs();
            }
            log.info((Object)("Will unzip: " + file.getAbsolutePath()));
            CommandResponse commandResponse = commandHandler.executeCommand(new String[]{"/usr/bin/tar", "-xzf", file.getAbsolutePath(), "-C", file2.getAbsolutePath()});
            log.debug((Object)"Will wait for unzip to complete....");
            long l = System.currentTimeMillis();
            commandResponse.waitFor();
            long l3 = System.currentTimeMillis();
            log.debug((Object)("Done waiting for unzip. (" + (l3 - l) + ")"));
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final File getUserFile(String string) {
        return new File(System.getProperty("user.home"), string);
    }

    public static File getUserTmpDir() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        if (!LOGGED_TMP_DIR) {
            log.debug((Object)("User Tmp Dir = " + (file != null ? file.toString() : "[NULL]")));
            LOGGED_TMP_DIR = true;
        }
        return file;
    }

    public static File getUserDesktop() {
        File file;
        if (OsConstants.isMac()) {
            file = new File(System.getProperty("user.home"), "Desktop");
            log.debug((Object)("User Desktop Dir (A) = " + file.toString()));
        } else {
            file = FileSystemView.getFileSystemView().getHomeDirectory();
            log.debug((Object)("User Desktop Dir (B) = " + file.toString()));
        }
        return file;
    }
}

