/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.pojo;

import com.cloudpath.common.pojo.IpSet;
import com.cloudpath.common.pojo.NetworkInterface;
import java.util.Vector;

public class NetworkInterfaces {
    private final Vector<NetworkInterface> cls_Interfaces = new Vector();

    public NetworkInterface getInterface(int n) {
        if (n >= 0 && n < this.cls_Interfaces.size()) {
            return this.cls_Interfaces.elementAt(n);
        }
        return null;
    }

    public void addInterface(NetworkInterface networkInterface) {
        if (networkInterface == null || this.getIndexByName(networkInterface.getName()) >= 0) {
            return;
        }
        this.cls_Interfaces.add(networkInterface);
    }

    public void setInterfaces(NetworkInterface[] networkInterfaceArray) {
        this.cls_Interfaces.clear();
        for (int i = 0; i < networkInterfaceArray.length; ++i) {
            this.addInterface(networkInterfaceArray[i]);
        }
    }

    public int getInterfaceCount() {
        return this.cls_Interfaces.size();
    }

    public NetworkInterface getInterfaceByName(String string) {
        int n = this.getIndexByName(string);
        if (n >= 0) {
            return this.cls_Interfaces.elementAt(n);
        }
        return null;
    }

    public NetworkInterface getInterfaceByMac(String string) {
        int n = this.getIndexByMac(string);
        if (n >= 0) {
            return this.cls_Interfaces.elementAt(n);
        }
        return null;
    }

    public NetworkInterface getInterfaceByLogicalGuid(String string) {
        int n = this.getIndexByGuid(string);
        if (n >= 0) {
            return this.cls_Interfaces.elementAt(n);
        }
        return null;
    }

    public int getIndexByGuid(String string) {
        if (string != null) {
            for (int i = 0; i < this.cls_Interfaces.size(); ++i) {
                if (!string.equals(this.cls_Interfaces.elementAt(i).getLogicalGuid())) continue;
                return i;
            }
        }
        return -1;
    }

    public int getIndexByMac(String string) {
        if (string != null) {
            for (int i = 0; i < this.cls_Interfaces.size(); ++i) {
                if (!string.equals(this.cls_Interfaces.elementAt(i).getMacAddress())) continue;
                return i;
            }
        }
        return -1;
    }

    public int getIndexByIpAddress(String string) {
        int n = -1;
        IpSet ipSet = new IpSet();
        ipSet.parseList(string);
        if (string != null) {
            for (int i = 0; i < this.cls_Interfaces.size(); ++i) {
                if (!ipSet.includesIpAddress(this.cls_Interfaces.elementAt(i).getIpAddress())) continue;
                if (n >= 0) {
                    return -1;
                }
                n = i;
            }
        }
        return n;
    }

    public int getIndexByName(String string) {
        if (string != null) {
            for (int i = 0; i < this.cls_Interfaces.size(); ++i) {
                if (!string.equals(this.cls_Interfaces.elementAt(i).getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public NetworkInterfaces getQualifyingInterfaces(int[] nArray) {
        NetworkInterfaces networkInterfaces = new NetworkInterfaces();
        if (nArray == null || nArray.length == 0) {
            for (int i = 0; i < this.cls_Interfaces.size(); ++i) {
                networkInterfaces.addInterface(this.getInterface(i));
            }
        } else {
            for (int i = 0; i < this.cls_Interfaces.size(); ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    if (nArray[j] != this.getInterface(i).getInterfaceType()) continue;
                    networkInterfaces.addInterface(this.getInterface(i));
                }
            }
        }
        return networkInterfaces;
    }
}

