/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.parse;

import com.cloudpath.common.parse.ElementHelper;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
extends DefaultHandler {
    private final HashMap<String, ElementHelper> cls_Helpers;
    private final Stack<String> cls_ElementNames = new Stack();
    private final Stack<Object> cls_Stack = new Stack();
    private final Stack<ElementHelper> cls_HelperStack = new Stack();
    private Object cls_RootObject;
    private String cls_CurrentText = "";
    private static final String DTD_LABEL = ".dtd";
    private static final byte[] DTD_REPLACEMENT = "<?xml version='1.0' encoding='UTF-8'?>".getBytes();

    public Parser(HashMap<String, ElementHelper> hashMap) {
        this.cls_Helpers = hashMap;
    }

    public Object getRootObject() {
        return this.cls_RootObject;
    }

    private final ElementHelper getHelper(String string, Object object) {
        ElementHelper elementHelper = this.cls_Helpers.get(string != null ? string.toUpperCase() : null);
        if (elementHelper != null) {
            return elementHelper;
        }
        if (this.cls_HelperStack.size() > 0) {
            return this.cls_HelperStack.peek();
        }
        System.out.println("ERROR:  Unable to find helper for element '" + string + "'  Register the helper in ParseManager.");
        return null;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.cls_ElementNames.add(string3);
        Object object = this.cls_Stack.isEmpty() ? null : this.cls_Stack.peek();
        ElementHelper elementHelper = this.getHelper(string3, object);
        if (elementHelper == null) {
            throw new RuntimeException("Unable to find helper for element '" + string3 + "'.  Register the helper in ParseManager.");
        }
        Object object2 = elementHelper.startElement(this, object, string, string2, string3, attributes);
        if (this.cls_Stack.isEmpty()) {
            this.cls_RootObject = object2;
        }
        this.cls_Stack.add(object2);
        this.cls_HelperStack.add(elementHelper);
        this.cls_CurrentText = "";
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.cls_ElementNames.pop();
        Object object = this.cls_Stack.pop();
        Object object2 = this.cls_Stack.isEmpty() ? null : this.cls_Stack.peek();
        ElementHelper elementHelper = this.cls_HelperStack.pop();
        elementHelper.endElement(this, object2, object, this.cls_CurrentText, string, string2, string3);
        if (object2 != object && this.cls_HelperStack.size() > 0) {
            String string4 = "";
            if (this.cls_ElementNames.size() > 0) {
                string4 = this.cls_ElementNames.peek();
            }
            this.cls_HelperStack.peek().addChild(object2, object, string4);
        }
        this.cls_CurrentText = "";
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.cls_CurrentText = this.cls_CurrentText + new String(cArray, n, n2);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        if (string2 != null && string2.endsWith(DTD_LABEL)) {
            return new InputSource(new ByteArrayInputStream(DTD_REPLACEMENT));
        }
        return null;
    }
}

