/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.parse;

import com.cloudpath.common.parse.ElementAssignment;
import com.cloudpath.common.parse.ElementHelper;
import com.cloudpath.common.parse.InvalidXmlException;
import com.cloudpath.common.parse.Parser;
import com.cloudpath.common.parse.XmlContainer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ParseManager {
    private static final SAXParserFactory PARSER_FACTORY = SAXParserFactory.newInstance();
    private static final Logger log = Logger.getLogger(ParseManager.class);
    private final SAXParser cls_SaxParser;
    private final HashMap<String, ElementHelper> cls_ElementHelpers = new HashMap();

    public ParseManager(ElementAssignment[] elementAssignmentArray) {
        SAXParser sAXParser;
        try {
            sAXParser = PARSER_FACTORY.newSAXParser();
        }
        catch (SAXException sAXException) {
            log.error((Object)"Error initializing parser.", (Throwable)sAXException);
            sAXParser = null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.error((Object)"Error initializing parser.", (Throwable)parserConfigurationException);
            sAXParser = null;
        }
        this.cls_SaxParser = sAXParser;
        for (int i = 0; i < elementAssignmentArray.length; ++i) {
            this.registerHelper(elementAssignmentArray[i]);
        }
    }

    public ParseManager(ElementHelper[] elementHelperArray) {
        SAXParser sAXParser;
        try {
            sAXParser = PARSER_FACTORY.newSAXParser();
        }
        catch (SAXException sAXException) {
            log.error((Object)"Error initializing parser.", (Throwable)sAXException);
            sAXParser = null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.error((Object)"Error initializing parser.", (Throwable)parserConfigurationException);
            sAXParser = null;
        }
        this.cls_SaxParser = sAXParser;
        for (int i = 0; i < elementHelperArray.length; ++i) {
            this.registerHelper(elementHelperArray[i]);
        }
    }

    private final void registerHelper(ElementAssignment elementAssignment) {
        this.registerHelper(elementAssignment.getElement(), elementAssignment.getHelper());
    }

    private final void registerHelper(ElementHelper elementHelper) {
        this.registerHelper(elementHelper.getElement(), elementHelper);
    }

    private final void registerHelper(String string, ElementHelper elementHelper) {
        this.cls_ElementHelpers.put(string != null ? string.toUpperCase() : null, elementHelper);
        if (elementHelper != null) {
            HashMap<String, ElementHelper> hashMap = new HashMap<String, ElementHelper>();
            elementHelper.buildDependencies(hashMap);
            if (hashMap.size() > 0) {
                Object[] objectArray = hashMap.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    ElementHelper elementHelper2 = (ElementHelper)hashMap.get(objectArray[i]);
                    if (elementHelper2 == null) continue;
                    this.cls_ElementHelpers.put(objectArray[i] != null ? objectArray[i].toString().toUpperCase() : null, elementHelper2);
                }
            }
        }
    }

    public Object parse(String string) throws InvalidXmlException {
        Parser parser = this.parseInternal(string);
        if (parser == null) {
            return null;
        }
        Object object = parser.getRootObject();
        if (object instanceof XmlContainer) {
            String string2 = ((XmlContainer)object).getStartElement();
            int n = string.indexOf(string2);
            int n2 = string.indexOf(((XmlContainer)object).getEndElement());
            if (n >= 0 && n2 >= 0) {
                string = string.substring(n + string2.length(), n2);
                ((XmlContainer)object).setXml(string);
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Parser parseInternal(String string) throws InvalidXmlException {
        Parser parser;
        if (this.cls_SaxParser == null) return null;
        if (string == null) {
            return null;
        }
        Parser parser2 = new Parser(this.cls_ElementHelpers);
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            try {
                if (string != null && string.indexOf(0) > 0) {
                    log.warn((Object)"XML file contains at least one NULL character, which is invalid.  Will replace them with spaces.");
                    string = string.replaceAll("\u0000", "");
                }
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                this.cls_SaxParser.parse((InputStream)byteArrayInputStream, (DefaultHandler)parser2);
                parser = parser2;
                Object var6_9 = null;
                if (byteArrayInputStream == null) return parser;
            }
            catch (SAXParseException sAXParseException) {
                log.warn((Object)("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId()));
                log.warn((Object)("   " + sAXParseException.getMessage()));
                log.warn((Object)("XML: " + string));
                throw new InvalidXmlException("Problem occurred parsing xml document.", sAXParseException);
            }
            catch (SAXException sAXException) {
                log.warn((Object)("\n** Parsing error: " + sAXException.getMessage()));
                throw new InvalidXmlException("Problem occurred parsing xml document.", sAXException);
            }
            catch (IOException iOException) {
                throw new InvalidXmlException("Problem occurred parsing xml document.", iOException);
            }
            catch (Throwable throwable) {
                throw new InvalidXmlException("Problem occurred parsing xml document.", throwable);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (byteArrayInputStream == null) throw throwable;
            try {
                ((InputStream)byteArrayInputStream).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throw throwable;
            }
        }
        try {}
        catch (Throwable throwable) {
            // empty catch block
            return parser;
        }
        ((InputStream)byteArrayInputStream).close();
        return parser;
    }
}

