/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.windows.util.antivirus;

import com.cloudpath.common.os.windows.util.RegistryKey;
import com.cloudpath.common.os.windows.util.WmiRecord;
import com.cloudpath.common.os.windows.util.Wzccmd;
import com.cloudpath.common.os.windows.util.antivirus.AntivirusHelper;
import com.cloudpath.common.util.BinaryUtil;
import com.cloudpath.common.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SymantecAvHelper
implements AntivirusHelper {
    private static final Logger log = Logger.getLogger(SymantecAvHelper.class);
    public static final RegistryKey SCAN_DATE = new RegistryKey("HKEY_LOCAL_MACHINE", "SOFTWARE\\Symantec\\Norton AntiVirus\\LastScan", "SystemTime", "REG_BINARY");
    private static final SimpleDateFormat DAT_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd.sss", Locale.US);
    private static final SimpleDateFormat BASIC_DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
    private final Wzccmd cls_Wzccmd;

    public SymantecAvHelper(Wzccmd wzccmd) {
        this.cls_Wzccmd = wzccmd;
    }

    public long getLastDatUpdateTimestamp() {
        File file = this.getDatDateFile();
        if (file.exists()) {
            try {
                String string = FileUtil.read(file);
                if (string != null && string.length() > 0) {
                    WmiRecord wmiRecord = new WmiRecord(string);
                    String string2 = wmiRecord.getString("CurDefs", "");
                    if (string2 != null && string2.length() >= 7) {
                        try {
                            return DAT_DATE_FORMAT.parse(string2).getTime();
                        }
                        catch (ParseException parseException) {
                            log.warn((Object)("Failed to parse Symantec dat date '" + string2 + "'."), (Throwable)parseException);
                        }
                    }
                } else {
                    log.warn((Object)("Symantec file blank at " + file.getAbsolutePath() + "."));
                }
            }
            catch (IOException iOException) {
                log.warn((Object)("Failed to read Symantec file at " + file.getAbsolutePath() + "."), (Throwable)iOException);
            }
        }
        return 0L;
    }

    public long getLastScanExecutionTimestamp() {
        String string = this.cls_Wzccmd.getRegistryKey(SCAN_DATE);
        if (string != null && string.length() > 0) {
            log.debug((Object)("Last scan time read as " + BinaryUtil.convertToHex(string)));
            return SymantecAvHelper.convertSysTimeToMillis(string);
        }
        return 0L;
    }

    public static final long convertSysTimeToMillis(String string) {
        if (string != null && string.length() >= 7) {
            try {
                int n = string.charAt(1) * 256 + string.charAt(0);
                char c = string.charAt(2);
                char c2 = string.charAt(6);
                String string2 = c + "/" + c2 + "/" + n;
                return BASIC_DATE_FORMAT.parse(string2).getTime();
            }
            catch (Exception exception) {
                log.warn((Object)("Error while parsing date '" + string + "'."), (Throwable)exception);
            }
        }
        return 0L;
    }

    public final File getDatDateFile() {
        String string = this.cls_Wzccmd.getSpecialFolders().getProgramFilesCommon();
        string = string + "\\Symantec Shared\\VirusDefs";
        File file = new File(string, "definfo.dat");
        return file;
    }
}

