/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.windows.util;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.windows.util.Antivirus;
import com.cloudpath.common.os.windows.util.ElevationListener;
import com.cloudpath.common.os.windows.util.ProcessDetails;
import com.cloudpath.common.os.windows.util.RegistryKey;
import com.cloudpath.common.os.windows.util.SpecialFolders;
import com.cloudpath.common.os.windows.util.ThirdPartyFirewall;
import com.cloudpath.common.os.windows.util.WmiRecord;
import com.cloudpath.common.os.windows.util.WmiRecords;
import com.cloudpath.common.os.windows.util.antivirus.AntivirusHelper;
import com.cloudpath.common.os.windows.util.antivirus.McAfeeAvHelper;
import com.cloudpath.common.os.windows.util.antivirus.SymantecAvHelper;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.pojo.NetworkInterfaces;
import com.cloudpath.common.util.BinaryUtil;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.Util;
import com.cloudpath.common.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class Wzccmd {
    private static final Logger log = Logger.getLogger(Wzccmd.class);
    public static final SimpleDateFormat REG_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.US);
    public static final SimpleDateFormat WMI_DATE_FORMAT = new SimpleDateFormat("yyyyMMddhhmmss", Locale.US);
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final long MILLIS_TO_BE_UPTODATE = 1209600000L;
    private static final String NOT_FOUND = "Not Found.";
    public static final int SERVICE_NOT_FOUND = 2;
    public static final int SERVICE_STOPPED = 0;
    public static final int SERVICE_RUNNING = 1;
    public static final int SERVICE_ERROR = -2;
    public static final int STARTMODE_AUTO = 1;
    public static final int STARTMODE_MANUAL = 0;
    public static final int STARTMODE_DISABLED = -1;
    public static final int STARTMODE_ERROR = -2;
    public static final int PROCESS_ERROR = -2;
    private static final String STARTTYPE_START_AUTO = "START_AUTO";
    private static final String STARTTYPE_START = "START";
    private static final String STARTTYPE_STOP = "STOP";
    private static final String STARTTYPE_STOP_MANUAL = "STOP_MANUAL";
    public static final String CIMV2 = "CIMV2";
    public static final String WIN32_OPERATING_SYSTEM = "win32_operatingsystem";
    public static final String WIN32_COMPUTER_SYSTEM = "win32_computersystem";
    public static final String WIN32_COMPUTER_SYSTEM_PRODUCT = "win32_computersystemproduct";
    public static final String WIN32_DESKTOP = "win32_desktop";
    public static final String WIN32_NETWORK_ADAPTER_CONFIGURATION = "win32_network_adapter_configuration";
    public static final RegistryKey DONT_DISPLAY_LAST_USER_NAME = new RegistryKey("HKEY_LOCAL_MACHINE", "SOFTWARE\\Windows NT\\CurrentVersion\\Winlogin", "DontDisplayLastUserName", "REG_DWORD");
    public static final RegistryKey WIN_UPDATE_DETECT = new RegistryKey("HKEY_LOCAL_MACHINE", "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\WindowsUpdate\\Auto Update\\Results\\Detect", "LastSuccessTime", "REG_SZ");
    public static final RegistryKey WIN_UPDATE_DOWNLOAD = new RegistryKey("HKEY_LOCAL_MACHINE", "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\WindowsUpdate\\Auto Update\\Results\\Download", "LastSuccessTime", "REG_SZ");
    public static final RegistryKey WIN_UPDATE_INSTALL = new RegistryKey("HKEY_LOCAL_MACHINE", "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\WindowsUpdate\\Auto Update\\Results\\Install", "LastSuccessTime", "REG_SZ");
    public static final RegistryKey SCREENSAVER_SECURE = new RegistryKey("HKEY_CURRENT_USER", "Control Panel\\Desktop", "ScreenSaverIsSecure", "REG_SZ");
    public static final RegistryKey SCREENSAVER_ACTIVE = new RegistryKey("HKEY_CURRENT_USER", "Control Panel\\Desktop", "ScreenSaveActive", "REG_SZ");
    public static final RegistryKey SCREENSAVER_TIMEOUT = new RegistryKey("HKEY_CURRENT_USER", "Control Panel\\Desktop", "ScreenSaveTimeout", "REG_SZ");
    public static final RegistryKey SCREENSAVER_EXE = new RegistryKey("HKEY_CURRENT_USER", "Control Panel\\Desktop", "SCRNSAVE.EXE", "REG_SZ");
    public static final RegistryKey OS_VERSION = new RegistryKey("HKEY_LOCAL_MACHINE", "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "CurrentVersion", "REG_SZ");
    public static final RegistryKey SYSTEM_ROOT = new RegistryKey("HKEY_LOCAL_MACHINE", "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "SystemRoot", "REG_SZ");
    private static final String[] XP_SP3_HOTFIXES = new String[]{"274261", "297694", "302224", "307154", "307711", "310841", "313489", "319440", "319740", "330628", "332134", "810859", "815304", "816045", "816506", "818898", "823778", "823984", "824838", "824995", "830092", "832481", "833281", "834158", "834707", "835183", "836435", "837022", "838151", "838657", "839210", "839953", "840139", "840312", "840388", "840669", "841356", "841978", "842520", "842735", "842738", "842827", "842933", "843289", "843516", "843518", "843541", "843605", "867282", "867554", "867795", "870679", "870753", "870891", "870971", "870975", "870979", "870981", "870997", "871005", "871006", "871205", "871228", "871250", "872789", "872797", "872942", "872966", "873333", "873339", "873392", "873396", "873397", "873407", "873414", "875506", "875538", "875555", "883483", "883507", "883517", "883523", "883529", "883586", "883667", "883939", "884018", "884020", "884027", "884038", "884046", "884047", "884267", "884534", "884538", "884539", "884558", "884562", "884565", "884568", "884575", "884723", "884851", "884859", "884861", "884862", "884868", "884882", "884883", "884885", "884897", "885222", "885250", "885267", "885270", "885293", "885295", "885353", "885354", "885423", "885439", "885443", "885453", "885464", "885492", "885523", "885626", "885641", "885835", "885836", "885843", "885855", "885863", "885865", "885884", "885887", "885894", "885898", "885932", "885936", "886185", "886199", "886423", "886530", "886540", "886610", "886659", "886677", "886704", "886716", "886801", "886809", "886903", "887078", "887131", "887170", "887173", "887186", "887189", "887472", "887535", "887569", "887572", "887578", "887589", "887590", "887601", "887698", "887710", "887742", "887797", "887800", "887811", "887816", "887820", "887822", "887823", "887998", "888083", "888092", "888098", "888111", "888113", "888162", "888239", "888240", "888254", "888302", "888310", "888321", "888402", "888404", "888406", "888407", "888413", "888426", "888432", "888516", "888603", "888622", "888795", "888990", "889016", "889073", "889085", "889093", "889136", "889178", "889315", "889320", "889321", "889323", "889333", "889334", "889386", "889388", "889389", "889407", "889412", "889527", "889669", "889673", "889816", "889960", "890042", "890046", "890047", "890048", "890067", "890175", "890178", "890196", "890207", "890210", "890215", "890327", "890463", "890470", "890546", "890552", "890558", "890579", "890582", "890644", "890671", "890733", "890737", "890831", "890837", "890859", "890864", "890923", "890927", "890937", "890946", "890951", "890953", "891019", "891070", "891117", "891220", "891391", "891566", "891570", "891593", "891630", "891647", "891711", "891781", "891849", "892049", "892050", "892052", "892056", "892087", "892090", "892099", "892227", "892233", "892235", "892296", "892313", "892346", "892489", "892496", "892520", "892540", "892559", "892598", "892627", "892763", "892850", "893008", "893048", "893056", "893066", "893086", "893089", "893225", "893226", "893231", "893243", "893249", "893310", "893317", "893357", "893359", "893371", "893376", "893476", "893605", "893606", "893609", "893614", "893756", "894069", "894072", "894075", "894077", "894083", "894087", "894088", "894179", "894194", "894232", "894391", "894395", "894463", "894472", "894480", "894551", "894618", "894685", "894686", "894794", "894871", "894872", "895109", "895115", "895120", "895173", "895196", "895199", "895200", "895246", "895312", "895321", "895325", "895406", "895486", "895536", "895542", "895564", "895570", "895751", "895900", "895953", "895954", "895997", "896017", "896062", "896088", "896156", "896166", "896178", "896180", "896256", "896269", "896336", "896344", "896354", "896358", "896360", "896414", "896422", "896423", "896424", "896426", "896427", "896428", "896430", "896613", "896616", "896626", "896679", "896684", "896687", "896688", "896725", "896727", "896728", "896984", "897166", "897168", "897169", "897254", "897326", "897327", "897338", "897574", "897649", "897661", "897662", "897663", "897696", "897715", "898050", "898060", "898061", "898062", "898068", "898073", "898108", "898439", "898444", "898456", "898461", "898543", "898612", "898713", "898781", "898900", "899102", "899182", "899266", "899271", "899284", "899337", "899338", "899342", "899344", "899409", "899417", "899418", "899420", "899422", "899527", "899587", "899588", "899589", "899591", "899596", "899811", "899812", "899815", "899900", "900411", "900462", "900466", "900485", "900624", "900626", "900722", "900725", "900730", "900732", "900808", "900930", "901017", "901026", "901104", "901116", "901122", "901155", "901190", "901214", "901377", "902058", "902149", "902346", "902395", "902400", "902409", "902845", "902853", "903089", "903234", "903235", "903242", "903250", "903252", "903675", "903737", "903891", "903895", "903896", "903897", "903926", "903930", "903936", "904023", "904367", "904412", "904423", "904563", "904629", "904636", "904706", "904710", "904767", "904829", "904942", "905297", "905299", "905414", "905495", "905498", "905519", "905628", "905654", "905749", "905816", "905876", "905890", "905915", "906216", "906219", "906232", "906277", "906294", "906379", "906450", "906469", "906472", "906473", "906524", "906569", "906650", "906673", "906678", "906681", "906688", "906693", "906751", "906752", "906859", "906866", "906882", "907018", "907247", "907265", "907301", "907316", "907338", "907405", "907455", "907572", "907717", "907803", "907865", "907870", "908069", "908209", "908233", "908473", "908519", "908521", "908531", "908536", "908673", "908676", "908917", "909095", "909278", "909279", "909347", "909390", "909422", "909423", "909425", "909441", "909486", "909547", "909608", "909667", "909737", "909918", "909985", "909987", "910234", "910274", "910329", "910365", "910366", "910437", "910466", "910482", "910620", "910623", "910645", "910678", "910720", "910728", "910849", "910906", "911013", "911063", "911064", "911066", "911071", "911133", "911149", "911162", "911170", "911262", "911280", "911562", "911565", "911567", "911589", "911740", "911855", "911904", "911927", "911929", "911949", "911990", "912112", "912143", "912354", "912461", "912475", "912572", "912666", "912680", "912761", "912784", "912812", "912817", "912919", "912945", "913178", "913296", "913318", "913365", "913425", "913446", "913460", "913478", "913522", "913538", "913580", "913670", "913788", "913808", "913830", "913862", "914012", "914015", "914028", "914144", "914300", "914301", "914388", "914389", "914399", "914437", "914440", "914444", "914450", "914453", "914463", "914798", "914804", "914810", "914841", "914882", "914906", "914929", "915326", "915355", "915357", "915365", "915377", "915389", "915415", "915428", "915686", "915787", "915800", "915832", "915843", "915865", "916089", "916094", "916189", "916191", "916199", "916204", "916281", "916452", "916453", "916528", "916595", "916626", "916731", "916846", "916852", "917013", "917021", "917022", "917140", "917159", "917332", "917344", "917422", "917425", "917462", "917537", "917608", "917730", "917772", "917777", "917783", "917953", "918005", "918014", "918033", "918069", "918093", "918118", "918144", "918204", "918208", "918233", "918310", "918334", "918338", "918365", "918439", "918495", "918599", "918649", "918690", "918692", "918766", "918837", "918899", "918956", "918961", "918962", "918965", "918966", "918967", "918997", "919007", "919071", "919237", "919250", "919408", "919477", "919484", "919490", "919615", "919692", "919880", "919922", "920142", "920183", "920192", "920213", "920214", "920295", "920342", "920605", "920670", "920681", "920683", "920685", "920867", "920872", "920875", "920889", "920918", "920982", "921028", "921059", "921090", "921321", "921337", "921351", "921397", "921398", "921400", "921401", "921411", "921413", "921503", "921619", "921883", "921982", "922006", "922120", "922128", "922410", "922461", "922474", "922482", "922582", "922599", "922616", "922668", "922760", "922819", "922859", "923118", "923154", "923155", "923165", "923191", "923214", "923232", "923262", "923293", "923401", "923404", "923414", "923416", "923423", "923535", "923567", "923689", "923694", "923712", "923810", "923845", "923966", "923980", "923996", "924051", "924065", "924078", "924156", "924191", "924270", "924271", "924301", "924347", "924386", "924441", "924496", "924533", "924639", "924667", "924692", "924764", "924809", "924840", "924867", "924881", "924893", "924935", "924941", "924961", "924994", "925051", "925066", "925112", "925228", "925271", "925418", "925454", "925486", "925507", "925528", "925623", "925681", "925683", "925720", "925793", "925832", "925876", "925877", "925902", "925922", "925923", "925973", "926044", "926046", "926047", "926121", "926131", "926139", "926140", "926141", "926238", "926239", "926247", "926255", "926436", "926646", "926720", "926777", "926840", "927288", "927374", "927436", "927507", "927544", "927546", "927582", "927740", "927774", "927779", "927802", "927810", "927880", "927891", "928090", "928097", "928248", "928255", "928269", "928387", "928388", "928470", "928491", "928492", "928494", "928540", "928595", "928627", "928843", "928878", "929120", "929123", "929134", "929280", "929338", "929399", "929483", "929548", "929624", "929726", "929755", "929798", "929863", "929864", "929874", "929883", "929969", "930178", "930352", "930494", "930597", "930620", "930916", "931192", "931261", "931278", "931374", "931505", "931532", "931618", "931678", "931689", "931760", "931768", "931784", "931836", "932039", "932043", "932044", "932168", "932380", "932394", "932538", "932562", "932590", "932597", "932662", "932716", "932823", "932866", "933006", "933014", "933062", "933105", "933133", "933182", "933215", "933251", "933256", "933264", "933360", "933566", "933579", "933612", "933684", "933729", "933737", "933811", "933812", "933873", "933876", "934014", "934161", "934205", "934275", "934376", "934428", "934720", "934849", "935192", "935198", "935210", "935214", "935448", "935512", "935544", "935560", "935575", "935579", "935677", "935708", "935729", "935760", "935775", "935776", "935777", "935778", "935779", "935786", "935839", "935840", "935843", "935851", "935879", "935892", "935903", "935989", "936021", "936059", "936071", "936129", "936235", "936357", "936455", "936456", "936554", "936610", "936611", "936678", "936880", "936881", "936882", "936883", "936904", "936949", "936953", "936955", "936970", "936994", "937053", "937088", "937106", "937143", "937193", "937357", "937367", "937856", "937894", "937930", "938032", "938127", "938375", "938512", "938566", "938596", "938635", "938828", "938829", "938961", "938977", "939010", "939252", "939273", "939373", "939450", "939653", "939682", "939780", "939786", "939850", "939884", "939913", "939940", "939941", "939944", "939946", "939947", "940072", "940086", "940275", "940277", "940284", "940322", "940427", "940514", "940526", "940527", "940541", "940566", "940569", "940742", "940848", "940984", "941000", "941036", "941037", "941077", "941133", "941158", "941202", "941248", "941568", "941569", "941598", "941603", "941693", "941715", "941837", "941846", "941880", "941938", "941975", "942171", "942172", "942173", "942174", "942202", "942367", "942603", "942615", "942694", "942710", "942763", "942840", "943000", "943055", "943120", "943198", "943245", "943303", "943378", "943460", "943509", "943510", "943828", "943854", "943856", "944110", "944203", "944338", "944340", "944507", "944533", "944653", "944781", "944904", "944939", "944998", "945007", "945222", "945342", "945553", "946026", "946501", "946629", "946632", "947195", "947864", "948590"};
    private static final String[] VISTA_SP1_HOTFIXES = new String[]{"843289", "870853", "884534", "889333", "905866", "906473", "922498", "925255", "925271", "925272", "925369", "925492", "925528", "925832", "925876", "925902", "926131", "926425", "927084", "927341", "927546", "928089", "928090", "928135", "928188", "928253", "928365", "928387", "928439", "928494", "928570", "928631", "928870", "929011", "929123", "929399", "929427", "929451", "929478", "929547", "929550", "929577", "929615", "929637", "929685", "929734", "929735", "929761", "929762", "929763", "929777", "929790", "929798", "929824", "929909", "929913", "929916", "930163", "930178", "930193", "930194", "930261", "930311", "930451", "930495", "930517", "930568", "930570", "930585", "930597", "930618", "930627", "930819", "930828", "930857", "930883", "930917", "930955", "930979", "931099", "931174", "931195", "931213", "931263", "931278", "931324", "931338", "931365", "931369", "931573", "931619", "931621", "931654", "931657", "931671", "931674", "931675", "931689", "931756", "931768", "931770", "931812", "931836", "931936", "931967", "931969", "932030", "932044", "932045", "932063", "932079", "932094", "932142", "932173", "932206", "932243", "932246", "932303", "932385", "932390", "932394", "932404", "932406", "932471", "932538", "932539", "932562", "932590", "932593", "932596", "932626", "932634", "932635", "932636", "932637", "932638", "932649", "932652", "932653", "932753", "932757", "932814", "932818", "932866", "932988", "932998", "933006", "933014", "933049", "933105", "933133", "933182", "933207", "933228", "933242", "933245", "933251", "933256", "933262", "933272", "933288", "933340", "933360", "933433", "933442", "933454", "933468", "933495", "933566", "933578", "933579", "933590", "933595", "933607", "933612", "933620", "933649", "933657", "933662", "933664", "933729", "933750", "933771", "933778", "933812", "933824", "933847", "933860", "933872", "933873", "933876", "933928", "933942", "934008", "934014", "934056", "934111", "934202", "934237", "934274", "934275", "934282", "934314", "934327", "934374", "934376", "934429", "934455", "934529", "934611", "934633", "934637", "934641", "934796", "934797", "934839", "934888", "934907", "935200", "935222", "935276", "935280", "935333", "935366", "935415", "935427", "935458", "935495", "935544", "935551", "935552", "935553", "935560", "935575", "935576", "935579", "935606", "935607", "935652", "935663", "935685", "935729", "935755", "935759", "935765", "935772", "935775", "935776", "935777", "935778", "935779", "935782", "935783", "935786", "935807", "935851", "935855", "935876", "935878", "935881", "935901", "935903", "935936", "935945", "935963", "935977", "935988", "936003", "936004", "936021", "936029", "936054", "936060", "936136", "936150", "936162", "936176", "936183", "936205", "936225", "936229", "936315", "936316", "936344", "936357", "936460", "936469", "936515", "936608", "936610", "936611", "936613", "936686", "936707", "936710", "936711", "936713", "936756", "936775", "936782", "936824", "936825", "936881", "936882", "936883", "936904", "936949", "936950", "936953", "936955", "936970", "936983", "937018", "937053", "937063", "937077", "937082", "937085", "937123", "937143", "937168", "937187", "937188", "937228", "937229", "937230", "937248", "937322", "937328", "937333", "937381", "937385", "937426", "937454", "937500", "937630", "937651", "937658", "937713", "938055", "938062", "938080", "938091", "938092", "938098", "938101", "938123", "938127", "938194", "938232", "938239", "938248", "938475", "938636", "938637", "938660", "938723", "938724", "938725", "938758", "938838", "938885", "938906", "938927", "938928", "938929", "938952", "938956", "938977", "938979", "939004", "939006", "939008", "939021", "939025", "939130", "939159", "939165", "939207", "939210", "939211", "939214", "939331", "939423", "939653", "939677", "939718", "939720", "939727", "939750", "939772", "939778", "939783", "939786", "939805", "939882", "939913", "939940", "939941", "939944", "939946", "940059", "940069", "940105", "940145", "940199", "940427", "940480", "940508", "940526", "940646", "940716", "940810", "940848", "940856", "940894", "941000", "941001", "941020", "941021", "941025", "941029", "941061", "941067", "941090", "941102", "941137", "941158", "941179", "941202", "941229", "941234", "941277", "941282", "941298", "941311", "941386", "941411", "941436", "941492", "941507", "941542", "941561", "941568", "941569", "941595", "941600", "941603", "941644", "941649", "941651", "941660", "941673", "941698", "941719", "941794", "941797", "941808", "941853", "941858", "941860", "941890", "941895", "941938", "941962", "941996", "941997", "942003", "942089", "942097", "942146", "942171", "942172", "942173", "942174", "942198", "942219", "942220", "942244", "942309", "942364", "942365", "942392", "942435", "942488", "942493", "942524", "942541", "942543", "942615", "942624", "942642", "942682", "942693", "942710", "942732", "942763", "942813", "942836", "942845", "942869", "942894", "942900", "942917", "942979", "943000", "943078", "943112", "943129", "943169", "943195", "943242", "943245", "943253", "943300", "943302", "943335", "943336", "943360", "943302", "943397", "943411", "943412", "943440", "943451", "943470", "943510", "943544", "943599", "943601", "943632", "943668", "943805", "943899", "943974", "943986", "944020", "944023", "944054", "944110", "944141", "944151", "944240", "944242", "944292", "944297", "944397", "944500", "944515", "944520", "944652", "944882", "944883", "944917", "945007", "945122", "945125", "945145", "945149", "945170", "945184", "945438", "945533", "945577", "945612", "945680", "945683", "945783", "946383"};
    private final CommandHandler cls_CommandHandler;
    private final File cls_Wzccmd;
    private final ElevationListener cls_ElevationListener;
    private SpecialFolders cls_SpecialFolders = null;
    private final Object[][] cls_AvHelpers = new Object[][]{{".*Norton AntiVirus.*", new SymantecAvHelper(this)}, {".*McAfee VirusScan.*", new McAfeeAvHelper(this)}};

    public Wzccmd(CommandHandler commandHandler) throws Exception {
        this(commandHandler, null);
    }

    public Wzccmd(CommandHandler commandHandler, ElevationListener elevationListener) throws Exception {
        log.info((Object)(Util.getClassName(this) + " is intializing..."));
        this.cls_CommandHandler = commandHandler;
        this.cls_ElevationListener = elevationListener;
        File file = FileUtil.moveFileToTemp("wzccmd", "exe");
        try {
            File file2 = new File(file.getParentFile(), "Network Wizard.exe");
            if (file2.exists()) {
                file2.delete();
            }
            if (file.renameTo(file2)) {
                file = file2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cls_Wzccmd = file;
    }

    public void openBrowser(String string) throws IOException {
        this.runWzccmdNonelevated(new String[]{"OPEN", string}, false);
    }

    public CommandResponse runWzccmdNonelevated(String[] stringArray, boolean bl) throws IOException {
        return this.runWzccmdFull(stringArray, false, "", bl);
    }

    private CommandResponse runWzccmdFull(String[] stringArray, boolean bl, String string, boolean bl2) throws IOException {
        bl = bl && OsConstants.isWindowsVista();
        int n = 1 + (bl ? 1 : 0) + (bl2 ? 1 : 0);
        String[] stringArray2 = new String[stringArray.length + n];
        stringArray2[0] = this.cls_Wzccmd.getAbsolutePath();
        if (bl) {
            stringArray2[1] = "ELEVATE";
            if (bl2) {
                stringArray2[2] = "DEBUG";
            }
        } else if (bl2) {
            stringArray2[1] = "DEBUG";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + n] = stringArray[i];
        }
        if (bl && this.cls_ElevationListener != null) {
            this.cls_ElevationListener.elevationRequested(string);
        }
        CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray2);
        if (bl && this.cls_ElevationListener != null) {
            commandResponse.waitFor();
            boolean bl3 = !"0".equals(Util.join(commandResponse.getOutput()).trim());
            this.cls_ElevationListener.elevationCompleted(bl3);
        }
        return commandResponse;
    }

    public String getRegistryKey(RegistryKey registryKey) {
        try {
            String[] stringArray = new String[]{"REG", this.getOsParameter(), "QUERY", this.getCommandLine(registryKey.getKeyName()), this.getCommandLine(registryKey.getKeyPath()), this.getCommandLine(this.getKeyItem(registryKey))};
            CommandResponse commandResponse = this.runWzccmdNonelevated(stringArray, false);
            commandResponse.waitFor();
            String[] stringArray2 = commandResponse.getError();
            if (stringArray2.length > 1 || stringArray2.length == 1 && stringArray2[0] != null && stringArray2[0].length() > 0) {
                log.error((Object)("GetRegistryKey(" + registryKey + ") returned error information.  " + Util.join(stringArray2)));
                return null;
            }
            String[] stringArray3 = commandResponse.getOutput();
            String string = "";
            if (stringArray3.length > 0) {
                string = stringArray3[stringArray3.length - 1];
            }
            if (string.startsWith("REG_BINARY: ")) {
                log.debug((Object)"Read a binary key.");
                string = string.substring("REG_BINARY".length() + 2);
                string = BinaryUtil.convertFromSpacelessHex(string);
            } else if (string.startsWith("REG_SZ: ")) {
                log.debug((Object)"Read a string key.");
                string = string.substring("REG_SZ".length() + 2);
                string = BinaryUtil.convertFromSpacelessHex(string.replace(" ", ""));
            } else if (string.startsWith("REG_DWORD: ")) {
                log.debug((Object)"Read a dword key.");
                string = string.substring("REG_DWORD".length() + 2);
            }
            if (NOT_FOUND.equals(string)) {
                string = null;
            }
            return string;
        }
        catch (IOException iOException) {
            log.error((Object)("An error occurred while reading registry key '" + registryKey + "'."), (Throwable)iOException);
            return null;
        }
    }

    public boolean setRegistryKey(RegistryKey registryKey, String string, String string2) {
        try {
            String string3 = "REG_DWORD".equals(registryKey.getDataType()) ? new String(string) : BinaryUtil.convertToHex2(string, false);
            boolean bl = "HKEY_LOCAL_MACHINE".equals(registryKey.getKeyName());
            String[] stringArray = new String[]{"REG", this.getOsParameter(), "SET", registryKey.getKeyName(), registryKey.getKeyPath(), this.getKeyItem(registryKey), registryKey.getDataType(), string3};
            CommandResponse commandResponse = this.runWzccmdFull(stringArray, bl, string2, false);
            commandResponse.waitFor();
            if (this.hasError(commandResponse)) {
                log.warn((Object)("An error was returned while setting key '" + registryKey + "': " + Util.join(commandResponse.getError())));
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while setting reg key.", (Throwable)iOException);
            return false;
        }
    }

    public boolean deleteRegistryKey(RegistryKey registryKey, String string) {
        try {
            boolean bl = "HKEY_LOCAL_MACHINE".equals(registryKey.getKeyName());
            String[] stringArray = new String[]{"REG", this.getOsParameter(), "DEL", registryKey.getKeyName(), registryKey.getKeyPath(), this.getKeyItem(registryKey)};
            CommandResponse commandResponse = this.runWzccmdFull(stringArray, bl, string, false);
            commandResponse.waitFor();
            if (this.hasError(commandResponse)) {
                log.warn((Object)("An error was returned while deleting key '" + registryKey + "': " + Util.join(commandResponse.getError())));
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while setting reg key.", (Throwable)iOException);
            return false;
        }
    }

    private String getKeyItem(RegistryKey registryKey) {
        return registryKey.getKeyItem().length() > 0 ? registryKey.getKeyItem() : "(Default)";
    }

    private String getCommandLine(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        return string;
    }

    public WmiRecords runWmiQuery(String string, String string2) {
        try {
            String[] stringArray = new String[]{"WMIQRY", string != null ? "ROOT\\" + string : "", string2 != null ? string2 : ""};
            CommandResponse commandResponse = this.runWzccmdNonelevated(stringArray, false);
            commandResponse.waitFor();
            if (this.hasError(commandResponse)) {
                log.warn((Object)("An error was returned while running query '" + string2 + "': " + Util.join(commandResponse.getError())));
                return null;
            }
            String string3 = Util.join(commandResponse.getOutput());
            return new WmiRecords(string3);
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while running wmi query.", (Throwable)iOException);
            return null;
        }
    }

    public boolean getWindowsFirewallState() {
        String[] stringArray = new String[]{"FIREWALL", this.getOsParameter(), "CHECK_WIN"};
        int n = this.runWzccmdForInt("querying Windows firewall state", stringArray, 0, false, false);
        return n == 1;
    }

    public boolean getAnyFirewallState() {
        String[] stringArray = new String[]{"FIREWALL", this.getOsParameter(), "CHECK_ANY"};
        int n = this.runWzccmdForInt("querying non-windows firewall state", stringArray, 0, false, false);
        return n == 1;
    }

    public int setWindowsFirewallState(boolean bl) {
        String[] stringArray = new String[]{"FIREWALL", this.getOsParameter(), bl ? "ON" : "OFF"};
        int n = this.runWzccmdForInt("setting Windows firewall state to " + bl, stringArray, 0, true, false);
        return n;
    }

    public ThirdPartyFirewall[] getNonWindowsFirewalls(String string) {
        String[] stringArray = string != null && string.length() > 0 ? new String[]{"FIREWALL", this.getOsParameter(), "NONWIN", string} : new String[]{"FIREWALL", this.getOsParameter(), "NONWIN"};
        CommandResponse commandResponse = null;
        try {
            commandResponse = this.runWzccmdNonelevated(stringArray, false);
            commandResponse.waitFor();
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while getting non-windows firewalls.", (Throwable)iOException);
            return new ThirdPartyFirewall[0];
        }
        if (this.hasError(commandResponse)) {
            log.warn((Object)("An error was returned while querying non-windows firewalls.': " + Util.join(commandResponse.getError())));
            return new ThirdPartyFirewall[0];
        }
        WmiRecords wmiRecords = new WmiRecords(Util.join(commandResponse.getOutput()));
        ThirdPartyFirewall[] thirdPartyFirewallArray = new ThirdPartyFirewall[wmiRecords.getCount()];
        for (int i = 0; i < thirdPartyFirewallArray.length; ++i) {
            thirdPartyFirewallArray[i] = new ThirdPartyFirewall(wmiRecords.getRecord(i));
        }
        return thirdPartyFirewallArray;
    }

    public int getClassicAntivirusState() {
        if (this.isAntivirusOverridden()) {
            return 11;
        }
        Antivirus[] antivirusArray = this.getAntivirusStatus(null);
        if (antivirusArray == null || antivirusArray.length == 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < antivirusArray.length; ++i) {
            if (!antivirusArray[i].getOnAccessScanningEnabled()) continue;
            if (antivirusArray[i].getProductUptoDate()) {
                n = 30;
                continue;
            }
            if (n >= 20) continue;
            n = 20;
        }
        return n;
    }

    public boolean isAntivirusOverridden() {
        int n = this.getAntivirusOverride();
        return n > 0;
    }

    private int getAntivirusOverride() {
        String[] stringArray = new String[]{"ANTIVIRUS", this.getOsParameter(), "CHECK_OVERRIDE"};
        CommandResponse commandResponse = null;
        try {
            commandResponse = this.runWzccmdNonelevated(stringArray, false);
            commandResponse.waitFor();
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while getting override state for avs.", (Throwable)iOException);
            return -1;
        }
        if (this.hasError(commandResponse)) {
            log.warn((Object)("An error was returned while getting override state for avs.': " + Util.join(commandResponse.getError())));
            return -1;
        }
        String string = Util.join(commandResponse.getOutput());
        int n = XmlUtil.getStringAsInt(string, 0);
        return n;
    }

    public boolean setAntivirusOverrideXpOnly(boolean bl, String string) {
        return this.setAntivirusOverrideXpOnly(bl, string, false);
    }

    public boolean setAntivirusOverrideXpOnly(boolean bl, String string, boolean bl2) {
        if (OsConstants.isWindowsXp()) {
            String[] stringArray = new String[]{"ANTIVIRUS", this.getOsParameter(), "SET_OVERRIDE", bl ? "ON" : "OFF"};
            if (bl2) {
                stringArray = new String[]{"ANTIVIRUS", this.getOsParameter(), "SET_OVERRIDE", bl ? "ON" : "OFF"};
            }
            CommandResponse commandResponse = null;
            try {
                commandResponse = this.runWzccmdFull(stringArray, true, string, false);
                commandResponse.waitFor();
            }
            catch (IOException iOException) {
                log.warn((Object)"An error occurred while setting override state for avs.", (Throwable)iOException);
                return false;
            }
            if (this.hasError(commandResponse)) {
                log.warn((Object)("An error was returned while setting override state for avs.': " + Util.join(commandResponse.getError())));
                return false;
            }
            String string2 = Util.join(commandResponse.getOutput());
            int n = XmlUtil.getStringAsInt(string2, 0);
            return bl == n > 0;
        }
        return true;
    }

    public boolean getAntivirusInstalled(String string) {
        Antivirus[] antivirusArray = this.getAntivirusStatus(string);
        return antivirusArray.length > 0;
    }

    public boolean getAntivirusRtpEnabled(String string) {
        Antivirus[] antivirusArray = this.getAntivirusStatus(string);
        for (int i = 0; i < antivirusArray.length; ++i) {
            if (!antivirusArray[i].getOnAccessScanningEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean getAntivirusUpToDate(String string) {
        Antivirus[] antivirusArray = this.getAntivirusStatus(string);
        for (int i = 0; i < antivirusArray.length; ++i) {
            if (!antivirusArray[i].getProductUptoDate()) continue;
            return true;
        }
        return false;
    }

    public long getAntivirusDaysSinceLastScan(String string) {
        Antivirus[] antivirusArray = this.getAntivirusStatus(string);
        long l = 0L;
        for (int i = 0; i < antivirusArray.length; ++i) {
            if (antivirusArray[i].getLastScanTimestamp() <= l) continue;
            l = antivirusArray[i].getLastScanTimestamp();
        }
        return (System.currentTimeMillis() - l) / 86400000L;
    }

    public long getAntivirusDaysSinceLastDat(String string) {
        Antivirus[] antivirusArray = this.getAntivirusStatus(string);
        long l = 0L;
        for (int i = 0; i < antivirusArray.length; ++i) {
            if (antivirusArray[i].getLastDatTimestamp() <= l) continue;
            l = antivirusArray[i].getLastDatTimestamp();
        }
        return (System.currentTimeMillis() - l) / 86400000L;
    }

    public Antivirus[] getAntivirusStatus(String string) {
        String[] stringArray = string != null && string.length() > 0 ? new String[]{"ANTIVIRUS", this.getOsParameter(), "CHECK", string} : new String[]{"ANTIVIRUS", this.getOsParameter(), "CHECK"};
        CommandResponse commandResponse = null;
        try {
            commandResponse = this.runWzccmdNonelevated(stringArray, false);
            commandResponse.waitFor();
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while getting avs.", (Throwable)iOException);
            return new Antivirus[0];
        }
        if (this.hasError(commandResponse)) {
            log.warn((Object)("An error was returned while querying avs.': " + Util.join(commandResponse.getError())));
            return new Antivirus[0];
        }
        WmiRecords wmiRecords = new WmiRecords(Util.join(commandResponse.getOutput()));
        Antivirus[] antivirusArray = new Antivirus[wmiRecords.getCount()];
        for (int i = 0; i < antivirusArray.length; ++i) {
            antivirusArray[i] = new Antivirus(wmiRecords.getRecord(i));
            for (int j = 0; j < this.cls_AvHelpers.length; ++j) {
                if (!antivirusArray[i].getDisplayName().matches((String)this.cls_AvHelpers[j][0])) continue;
                antivirusArray[i].setLastDatTimestamp(((AntivirusHelper)this.cls_AvHelpers[j][1]).getLastDatUpdateTimestamp());
                antivirusArray[i].setLastScanTimestamp(((AntivirusHelper)this.cls_AvHelpers[j][1]).getLastScanExecutionTimestamp());
                if (antivirusArray[i].getProductUptoDate() || antivirusArray[i].getLastDatTimestamp() <= 0L) continue;
                log.debug((Object)("For product '" + antivirusArray[i].getDisplayName() + "', wmi reported not up to date, but we found our own timestamp.  Will check if the dat is up-to-date."));
                if (System.currentTimeMillis() - antivirusArray[i].getLastDatTimestamp() > 1209600000L) continue;
                log.debug((Object)"Will set up-to-date to true because of the timestamp we found manually.");
                antivirusArray[i].setProductUptoDate(true);
            }
        }
        return antivirusArray;
    }

    public ProcessDetails getProcessDetails() {
        try {
            String[] stringArray = new String[]{"SECCTR", this.getOsParameter(), "PROCESS_DETAIL"};
            CommandResponse commandResponse = this.runWzccmdNonelevated(stringArray, false);
            commandResponse.waitFor();
            if (this.hasError(commandResponse)) {
                log.warn((Object)("An error was returned while getting process details: " + Util.join(commandResponse.getError())));
                return null;
            }
            String string = Util.join(commandResponse.getOutput());
            WmiRecords wmiRecords = new WmiRecords(string);
            ProcessDetails processDetails = new ProcessDetails();
            for (int i = 0; i < wmiRecords.getCount(); ++i) {
                WmiRecord wmiRecord = wmiRecords.getRecord(i);
                processDetails.addProcess(wmiRecord.getLong("pid", 0L), wmiRecord.getString("path", ""), wmiRecord.getString("original_name", ""));
            }
            return processDetails;
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while getting process details.", (Throwable)iOException);
            return null;
        }
    }

    public boolean isHotfixInstalled(String string) {
        if (this.isWindowsXpServicePack(3) ? Wzccmd.isHotfixInXpSp3(string) : this.isWindowsVistaServicePack(1) && Wzccmd.isHotfixInVistaSp1(string)) {
            return true;
        }
        String[] stringArray = new String[]{"SECCTR", this.getOsParameter(), "HOTFIX", this.getCommandLine(string)};
        int n = this.runWzccmdForInt("querying hotfix '" + string + "'", stringArray, 0, false, false);
        return n == 1;
    }

    public int getServiceState(String string) {
        String[] stringArray = new String[]{"SECCTR", this.getOsParameter(), "SERVICE", this.getCommandLine(string)};
        return this.runWzccmdForInt("querying state of service '" + string + "'", stringArray, -2, false, false);
    }

    public int getServiceStartMode(String string) {
        String[] stringArray = new String[]{"SECCTR", this.getOsParameter(), "SERVICE_STARTMODE", this.getCommandLine(string)};
        return this.runWzccmdForInt("querying startmode of service '" + string + "'", stringArray, -2, false, false);
    }

    public boolean setServiceState(String string, String string2, boolean bl, boolean bl2) {
        String string3 = "";
        string3 = bl ? (bl2 ? STARTTYPE_START_AUTO : STARTTYPE_START) : (bl2 ? STARTTYPE_STOP_MANUAL : STARTTYPE_STOP);
        try {
            String[] stringArray = new String[]{"SECCTR", this.getOsParameter(), string3, this.getCommandLine(string2)};
            CommandResponse commandResponse = this.runWzccmdFull(stringArray, true, string, false);
            commandResponse.waitFor();
            if (this.hasError(commandResponse)) {
                log.warn((Object)("An error was returned while setting state of service '" + string2 + "': " + Util.join(commandResponse.getError())));
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            log.warn((Object)("An error occurred while setting state of service '" + string2 + "'."), (Throwable)iOException);
            return false;
        }
    }

    public int getProcessCount(String string) {
        String[] stringArray = new String[]{"SECCTR", this.getOsParameter(), "PROCESS", this.getCommandLine(string)};
        return this.runWzccmdForInt("querying state of service '" + string + "'", stringArray, -2, false, false);
    }

    public void setProcessState(String string, boolean bl) {
        String string2 = bl ? "PROCESS_START" : "PROCESS_STOP";
        String[] stringArray = new String[]{"SECCTR", this.getOsParameter(), string2, this.getCommandLine(string)};
        int n = this.runWzccmdForInt("setting state of service '" + string + "'", stringArray, -2, false, false);
        if (n < 0) {
            log.debug((Object)("WZCCMD returned result " + n + "."));
        }
    }

    public boolean getDisplayLastUserName() {
        return XmlUtil.getStringAsBoolean(this.getRegistryKey(DONT_DISPLAY_LAST_USER_NAME), true);
    }

    public void setDisplayLastUserName(boolean bl, String string) {
        this.setRegistryKey(DONT_DISPLAY_LAST_USER_NAME, bl ? "1" : "0", string);
    }

    public int getAutoUpdateState() {
        String[] stringArray = new String[]{"WUA", this.getOsParameter(), "CHECK"};
        int n = this.runWzccmdForInt("querying auto updates state", stringArray, 0, false, false);
        return n;
    }

    public boolean setAutoUpdateState(boolean bl) {
        String[] stringArray = new String[]{"WUA", this.getOsParameter(), bl ? "ENABLE" : "DISABLE"};
        this.runWzccmdForString("setting auto updates state", stringArray, "0", true, false);
        return true;
    }

    public long getAutoUpdateLastDetect() {
        return this.getRegistryTimestamp(WIN_UPDATE_DETECT, 0L);
    }

    public long getAutoUpdateLastDownload() {
        return this.getRegistryTimestamp(WIN_UPDATE_DOWNLOAD, 0L);
    }

    public long getAutoUpdateLastInstall() {
        return this.getRegistryTimestamp(WIN_UPDATE_INSTALL, 0L);
    }

    public String getEncryptedPassword(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        string = string.replace("\"", "\"\"");
        String[] stringArray = new String[]{"XPC_ENCRYPT", string};
        return this.runWzccmdForString("ENCRYPT_PASSWORD", stringArray, "", false, false);
    }

    public String getDecryptedPassword(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String[] stringArray = new String[]{"XPC_DECRYPT", string};
        return this.runWzccmdForString("DECRYPT_PASSWORD", stringArray, "", false, false);
    }

    public String getOsName() {
        return this.runWmiQueryForString(CIMV2, WIN32_OPERATING_SYSTEM, "Caption", null, NOT_FOUND);
    }

    public String getOsServicePack() {
        return this.runWmiQueryForString(CIMV2, WIN32_OPERATING_SYSTEM, "ServicePackMajorVersion", null, "0");
    }

    public String getOsVersion() {
        return this.getRegistryKey(OS_VERSION);
    }

    public String getOsBuildNumber() {
        return this.runWmiQueryForString(CIMV2, WIN32_OPERATING_SYSTEM, "Version", null, NOT_FOUND);
    }

    public String getOsFullServicePack() {
        return this.getOsVersion() + "." + this.getOsServicePack();
    }

    public String getOsSerialNumber() {
        return this.runWmiQueryForString(CIMV2, WIN32_OPERATING_SYSTEM, "SerialNumber", null, NOT_FOUND);
    }

    public String getOsInstallDate() {
        String string = this.runWmiQueryForString(CIMV2, WIN32_OPERATING_SYSTEM, "InstallDate", null, null);
        if (string != null) {
            if (string.indexOf(46) >= 0) {
                string = string.substring(0, string.indexOf(46));
            }
            try {
                Date date = WMI_DATE_FORMAT.parse(string);
                return Util.FULL_DATE.format(date);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return NOT_FOUND;
    }

    public String getComputerName() {
        return this.runWmiQueryForString(CIMV2, WIN32_COMPUTER_SYSTEM, "Name", null, NOT_FOUND);
    }

    public String getComputerManufacturer() {
        return this.runWmiQueryForString(CIMV2, WIN32_COMPUTER_SYSTEM, "Manufacturer", null, NOT_FOUND);
    }

    public String getComputerModel() {
        return this.runWmiQueryForString(CIMV2, WIN32_COMPUTER_SYSTEM, "Model", null, NOT_FOUND);
    }

    public String getComputerModelName() {
        return this.runWmiQueryForString(CIMV2, WIN32_COMPUTER_SYSTEM_PRODUCT, "Version", null, NOT_FOUND);
    }

    public String getComputerOwnerName() {
        return this.runWmiQueryForString(CIMV2, WIN32_COMPUTER_SYSTEM, "PrimaryOwnerName", null, NOT_FOUND);
    }

    public String getComputerDomain() {
        return this.isPartOfDomain() ? this.runWmiQueryForString(CIMV2, WIN32_COMPUTER_SYSTEM, "Domain", null, NOT_FOUND) : "";
    }

    public String getComputerWorkgroup() {
        return !this.isPartOfDomain() ? this.runWmiQueryForString(CIMV2, WIN32_COMPUTER_SYSTEM, "Domain", null, NOT_FOUND) : "";
    }

    public boolean isPartOfDomain() {
        return XmlUtil.getStringAsBoolean(this.runWmiQueryForString(CIMV2, WIN32_COMPUTER_SYSTEM, "PartOfDomain", null, null), false);
    }

    public String getUserName() {
        return this.runWmiQueryForString(CIMV2, WIN32_COMPUTER_SYSTEM, "UserName", null, NOT_FOUND);
    }

    public boolean isScreenSaverActive() {
        return XmlUtil.getStringAsBoolean(this.runWmiQueryForString(CIMV2, WIN32_DESKTOP, "ScreenSaverActive", "Name='" + this.getUserName() + "'", null), false);
    }

    public void setScreenSaverActive(boolean bl, String string, String string2) {
        log.debug((Object)("Will set screen saver active to " + bl + " with exe " + string));
        this.setRegistryKey(SCREENSAVER_ACTIVE, bl ? "1" : "0", string2);
        if (bl) {
            if (string != null && string.length() > 0) {
                log.debug((Object)"Using screen saver exe specified.");
                this.setScreenSaverExe(string, string2);
            } else {
                string = this.getRegistryKey(SCREENSAVER_EXE);
                if (string == null || string.length() == 0 || "Not Found".equals(string)) {
                    log.debug((Object)"Will set the default screen saver exe.");
                    this.setScreenSaverExe(this.getDefaultScreenSaver(), string2);
                } else {
                    log.debug((Object)"Screen saver exe is already specified.");
                }
            }
        } else {
            log.debug((Object)"Will delete screen saver exe because it is disabled.");
            this.deleteRegistryKey(SCREENSAVER_EXE, string2);
        }
    }

    public boolean isScreenSaverSecure() {
        return XmlUtil.getStringAsBoolean(this.runWmiQueryForString(CIMV2, WIN32_DESKTOP, "ScreenSaverSecure", "Name='" + this.getUserName() + "'", null), false);
    }

    public void setScreenSaverSecure(boolean bl, String string) {
        this.setRegistryKey(SCREENSAVER_SECURE, bl ? "1" : "0", string);
    }

    public long getScreenSaverTimeout() {
        return XmlUtil.getStringAsLong(this.runWmiQueryForString(CIMV2, WIN32_DESKTOP, "ScreenSaverTimeout", "Name='" + this.getUserName() + "'", null), 600L);
    }

    public void setScreenSaverTimeout(long l, String string) {
        this.setRegistryKey(SCREENSAVER_TIMEOUT, "" + (l > 0L ? l : 600L), string);
    }

    public String getScreenSaverExe() {
        return this.getRegistryKey(SCREENSAVER_EXE);
    }

    public void setScreenSaverExe(String string, String string2) {
        this.setRegistryKey(SCREENSAVER_EXE, string, string2);
    }

    public String getDnsHostName(String string) {
        return this.runWmiQueryForString(CIMV2, WIN32_NETWORK_ADAPTER_CONFIGURATION, "DNSHostName", "MACAddress='" + string + "' and IpEnabled='true'", NOT_FOUND);
    }

    public NetworkInterfaces getNetworkInterfaces() {
        try {
            String[] stringArray = new String[]{"NIC", this.getOsParameter(), "QUERY"};
            CommandResponse commandResponse = this.runWzccmdNonelevated(stringArray, false);
            commandResponse.waitFor();
            if (this.hasError(commandResponse)) {
                log.warn((Object)("An error was returned while querying nics. " + Util.join(commandResponse.getError())));
                return null;
            }
            String string = Util.join(commandResponse.getOutput());
            WmiRecords wmiRecords = new WmiRecords(string);
            NetworkInterfaces networkInterfaces = new NetworkInterfaces();
            for (int i = 0; i < wmiRecords.getCount(); ++i) {
                NetworkInterface networkInterface = new NetworkInterface();
                String[] stringArray2 = wmiRecords.getRecord(i).getProperties();
                for (int j = 0; j < stringArray2.length; ++j) {
                    networkInterface.setProperty(stringArray2[j], wmiRecords.getRecord(i).getString(stringArray2[j], ""));
                }
                networkInterfaces.addInterface(networkInterface);
            }
            return networkInterfaces;
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while running nic query.", (Throwable)iOException);
            return null;
        }
    }

    private boolean hasError(CommandResponse commandResponse) {
        String[] stringArray = commandResponse.getError();
        if (stringArray.length > 1 || stringArray.length == 1 && stringArray[0] != null && stringArray[0].length() > 0) {
            return true;
        }
        String string = Util.join(commandResponse.getOutput());
        return string != null && string.startsWith("ERROR:");
    }

    private int runWzccmdForInt(String string, String[] stringArray, int n, boolean bl, boolean bl2) {
        String string2 = this.runWzccmdForString(string, stringArray, n + "", bl, bl2);
        return XmlUtil.getStringAsInt(string2, n);
    }

    private String runWzccmdForString(String string, String[] stringArray, String string2, boolean bl, boolean bl2) {
        try {
            CommandResponse commandResponse = this.runWzccmdFull(stringArray, bl, string, bl2);
            commandResponse.waitFor();
            if (this.hasError(commandResponse)) {
                log.warn((Object)("An error was returned while '" + string + "'.  Error: " + Util.join(commandResponse.getError())));
                return string2;
            }
            String[] stringArray2 = commandResponse.getOutput();
            String string3 = "";
            if (stringArray2.length > 0) {
                string3 = stringArray2[stringArray2.length - 1];
            }
            return string3;
        }
        catch (IOException iOException) {
            log.warn((Object)("An error occurred while '" + string + "'."), (Throwable)iOException);
            return string2;
        }
    }

    private String getOsParameter() {
        if (OsConstants.isWindowsVista()) {
            return "VISTA";
        }
        return "XP";
    }

    private String runWmiQueryForString(String string, String string2, String string3, String string4, String string5) {
        String string6 = "select " + string3 + " from " + string2;
        if (string4 != null && string4.length() > 0) {
            string4 = string4.replace("\\", "\\\\");
            string6 = string6 + " where " + string4;
        }
        log.debug((Object)("Will run query " + string6));
        WmiRecords wmiRecords = this.runWmiQuery(string, string6);
        if (wmiRecords == null || wmiRecords.getCount() == 0 || wmiRecords.getRecord(0) == null) {
            log.debug((Object)"Received zero records.");
            return string5;
        }
        String string7 = wmiRecords.getRecord(0).getString(string3, string5);
        log.debug((Object)("Received " + wmiRecords.getCount() + " records and value '" + string7 + "' (without default " + wmiRecords.getRecord(0).getString(string3, "XXX") + "."));
        log.debug((Object)("Properties are " + Util.join(wmiRecords.getRecord(0).getProperties())));
        return string7;
    }

    private long getRegistryTimestamp(RegistryKey registryKey, long l) {
        String string = this.getRegistryKey(registryKey);
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            return REG_DATE_FORMAT.parse(string).getTime();
        }
        catch (ParseException parseException) {
            return l;
        }
    }

    public String getDefaultScreenSaver() {
        return this.getRegistryKey(SYSTEM_ROOT) + "\\System32\\scrnsave.scr";
    }

    public final SpecialFolders getSpecialFolders() {
        if (this.cls_SpecialFolders == null) {
            this.cls_SpecialFolders = new SpecialFolders();
            try {
                String[] stringArray = new String[]{"SPECIAL_FOLDERS", "FILLER"};
                CommandResponse commandResponse = this.runWzccmdNonelevated(stringArray, false);
                commandResponse.waitFor();
                String[] stringArray2 = commandResponse.getOutput();
                String string = Util.join(stringArray2);
                string = string.replace("\\", "\\\\");
                WmiRecord wmiRecord = new WmiRecord(string);
                String[] stringArray3 = wmiRecord.getProperties();
                for (int i = 0; i < stringArray3.length; ++i) {
                    String string2 = stringArray3[i];
                    try {
                        Long l = new Long(string2);
                        this.cls_SpecialFolders.addPath(l, wmiRecord.getString(string2, ""));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.warn((Object)("Unable to process key '" + string2 + "' as a long."), (Throwable)numberFormatException);
                    }
                }
            }
            catch (IOException iOException) {
                log.warn((Object)"Unable to load special folders.", (Throwable)iOException);
            }
        }
        return this.cls_SpecialFolders;
    }

    public static boolean isHotfixInXpSp3(String string) {
        return Wzccmd.isHotfixInList(string, XP_SP3_HOTFIXES);
    }

    public static boolean isHotfixInVistaSp1(String string) {
        return Wzccmd.isHotfixInList(string, VISTA_SP1_HOTFIXES);
    }

    public static boolean isHotfixInList(String string, String[] stringArray) {
        string = Wzccmd.fixHotfixName(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String fixHotfixName(String string) {
        String string2;
        String string3 = string2 = string != null ? string.toLowerCase() : "";
        if (string2.startsWith("kb")) {
            string2 = string2.substring(2);
        }
        return string2;
    }

    public boolean isWindowsXpServicePack(int n) {
        if (OsConstants.isWindowsXp()) {
            return this.getOsServicePack().equals("" + n);
        }
        return false;
    }

    public boolean isWindowsVistaServicePack(int n) {
        if (OsConstants.isWindowsVista()) {
            return this.getOsServicePack().equals("" + n);
        }
        return false;
    }
}

