/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.windows.provider;

import com.cloudpath.common.os.common.FilePathProvider;
import com.cloudpath.common.os.windows.util.SpecialFolders;
import com.cloudpath.common.util.Util;
import java.io.File;
import org.apache.log4j.Logger;

public class WindowsFilePathProvider
implements FilePathProvider {
    private static final Logger log = Logger.getLogger(WindowsFilePathProvider.class);
    private static final int CUSTOM_SYSTEM_DRIVE = -2000;
    private static final int CUSTOM_TEMP = -2001;
    private static final int CUSTOM_USERNAME = -2002;
    private static final Object[][] STANDARD_VARIABLES = new Object[][]{{"%DESKTOP%", "0"}, {"%HOME%", "40"}, {"%APPDATA%", "26"}, {"%PROGRAMFILES%", "38"}, {"%SYSTEMROOT%", "36"}, {"%WINDIR%", "36"}, {"%HOME%", "40"}, {"%USERPROFILE%", "40"}, {"%SYSTEMDRIVE%", "-2000"}, {"%TMP%", "-2001"}, {"%TEMP%", "-2001"}, {"%USERNAME%", "-2002"}};
    private final SpecialFolders cls_SpecialFolders;

    public WindowsFilePathProvider(SpecialFolders specialFolders) {
        this.cls_SpecialFolders = specialFolders;
    }

    public File getFileByPath(String string) {
        string = WindowsFilePathProvider.replaceStandardVariables(this.cls_SpecialFolders, string);
        return new File(string);
    }

    protected static String replaceStandardVariables(SpecialFolders specialFolders, String string) {
        if (string != null && string.indexOf(37) > 0) {
            log.debug((Object)("Will replace variables in '" + string + "'."));
            for (int i = 0; i < STANDARD_VARIABLES.length; ++i) {
                String string2 = (String)STANDARD_VARIABLES[i][0];
                if (!string.contains(string2.toLowerCase()) && !string.contains(string2.toUpperCase())) continue;
                String string3 = (String)STANDARD_VARIABLES[i][1];
                log.debug((Object)("  - Found variable '" + string2 + "' with clsid " + string3 + "."));
                String string4 = WindowsFilePathProvider.getCsidl(specialFolders, Long.parseLong(string3));
                if (string4 == null) continue;
                string = string.replace(string2.toUpperCase(), string4);
                string = string.replace(string2.toLowerCase(), string4);
            }
            log.debug((Object)("Path after variable replacement is: " + string));
        }
        return string;
    }

    private static String getCsidl(SpecialFolders specialFolders, long l) {
        if (l == -2000L) {
            File file = new File(specialFolders.getPath(36L));
            while (file.getParentFile() != null) {
                file = file.getParentFile();
            }
            return file.getAbsolutePath();
        }
        if (l == -2001L) {
            return Util.getTempDirectory().getAbsolutePath();
        }
        if (l == -2002L) {
            return System.getProperty("user.name");
        }
        return specialFolders.getPath(l);
    }
}

