/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.windows.provider;

import com.cloudpath.common.os.common.ApplicationProvider;
import com.cloudpath.common.os.common.FilePathProvider;
import com.cloudpath.common.os.windows.util.InstalledApplication;
import com.cloudpath.common.os.windows.util.ProcessDetail;
import com.cloudpath.common.os.windows.util.ProcessDetails;
import com.cloudpath.common.os.windows.util.Wzccmd;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WindowsApplicationProvider
implements ApplicationProvider {
    private static final Logger log = Logger.getLogger(WindowsApplicationProvider.class);
    private final Wzccmd cls_Wzccmd;
    private final FilePathProvider cls_FilePathProvider;
    private final HashMap<String, File> cls_LastFoundLocation = new HashMap();
    private long cls_LastFoundFullPass = 0L;

    public WindowsApplicationProvider(Wzccmd wzccmd, FilePathProvider filePathProvider) {
        this.cls_Wzccmd = wzccmd;
        this.cls_FilePathProvider = filePathProvider;
    }

    public boolean isApplicationInstalled(String string) {
        log.debug((Object)("Is application '" + string + "' installed?"));
        File file = this.getFileFromCache(string);
        if (file != null) {
            log.debug((Object)("Found application '" + string + "' in cache at " + file.getAbsolutePath() + "."));
            return true;
        }
        file = this.getApplicationByFullPath(string);
        if (file != null) {
            log.debug((Object)("Found application '" + string + "' by its full path (" + file.getAbsolutePath() + ")."));
            return true;
        }
        InstalledApplication[] installedApplicationArray = this.getApplicationByRegistry(string, false);
        if (installedApplicationArray != null && installedApplicationArray.length > 0) {
            log.debug((Object)("Found application '" + string + "' by its uninstall entry. (" + installedApplicationArray[0].getDescription() + ")"));
            return true;
        }
        file = this.getApplicationLocation(string);
        return file != null;
    }

    public String getApplicationVersion(String string) {
        return "";
    }

    public ApplicationProvider.InstallResult installApplication(File file, String string, String string2) {
        return ApplicationProvider.InstallResult.GENERAL_FAILURE;
    }

    public final void killApplication(String string) {
        this.cls_Wzccmd.setProcessState(string, false);
    }

    public final void launchApplication(String string) {
        File file = this.getApplicationLocation(string);
        if (file != null) {
            log.debug((Object)("Will launch: " + file.getAbsolutePath()));
            this.cls_Wzccmd.setProcessState(file.getAbsolutePath(), true);
        } else {
            log.debug((Object)("Could not locate file for '" + string + "'.  Will attempt using '" + string + "'."));
            this.cls_Wzccmd.setProcessState(string, true);
        }
    }

    public final int getProcessCount(String string) {
        log.debug((Object)("Will get process count for '" + string + "'."));
        return this.cls_Wzccmd.getProcessCount(string);
    }

    public final void setServiceState(String string, int n) {
        if (n != 2) {
            this.cls_Wzccmd.setServiceState("Changing", string, n == 1, true);
        }
    }

    public final int getServiceState(String string) {
        return this.cls_Wzccmd.getServiceState(string);
    }

    public void refresh() {
        this.flushCache();
    }

    public final void flushCache() {
        this.cls_LastFoundLocation.clear();
        this.cls_LastFoundFullPass = 0L;
    }

    private File getApplicationByFullPath(String string) {
        File file;
        File file2 = file = this.cls_FilePathProvider != null ? this.cls_FilePathProvider.getFileByPath(string) : new File(string);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private InstalledApplication[] getApplicationByRegistry(String string, boolean bl) {
        return new InstalledApplication[0];
    }

    private File getApplicationBySystemPath(String string) {
        return null;
    }

    private File getApplicationInDirectory(String string, File file, int n) {
        string = string != null ? string.toLowerCase() : null;
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".exe");
            }
        };
        File[] fileArray = file.listFiles(fileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                File file2;
                if (n == 0 || (file2 = this.getApplicationInDirectory(string, fileArray[i], n--)) == null) continue;
                return file2;
            }
            if (!fileArray[i].getName().toLowerCase().endsWith(".exe")) continue;
            if (fileArray[i].getName().toLowerCase().matches(string)) {
                return fileArray[i];
            }
            this.cls_LastFoundLocation.put(fileArray[i].getName().toLowerCase(), fileArray[i]);
        }
        return null;
    }

    public File getApplicationLocation(String string) {
        int n;
        File file = this.getFileFromCache(string);
        if (file != null) {
            log.debug((Object)("Found application '" + string + "' in cache at " + file.getAbsolutePath() + "."));
            return file;
        }
        file = this.getApplicationByFullPath(string);
        if (file != null) {
            log.debug((Object)("Found application '" + string + "' by its full path (" + file.getAbsolutePath() + ")."));
            this.cls_LastFoundLocation.put(string.toLowerCase(), file);
            return file;
        }
        file = this.getApplicationBySystemPath(string);
        if (file != null) {
            log.debug((Object)("Found application '" + string + "' because it is on the system path (" + file.getAbsolutePath() + ")."));
            this.cls_LastFoundLocation.put(string.toLowerCase(), file);
            return file;
        }
        ProcessDetails processDetails = this.cls_Wzccmd.getProcessDetails();
        ProcessDetail[] processDetailArray = processDetails.getProcessesByExeName(string);
        if (processDetailArray != null && processDetailArray.length > 0) {
            for (n = 0; n < processDetailArray.length; ++n) {
                file = new File(processDetailArray[n].getPath());
                if (!file.exists()) continue;
                this.cls_LastFoundLocation.put(string.toLowerCase(), file);
                return file;
            }
        }
        if ((processDetailArray = processDetails.getProcessesByOriginalName(string)) != null && processDetailArray.length > 0) {
            for (n = 0; n < processDetailArray.length; ++n) {
                file = new File(processDetailArray[n].getPath());
                if (!file.exists()) continue;
                this.cls_LastFoundLocation.put(string.toLowerCase(), file);
                return file;
            }
        }
        if ((n = (int)(this.isFileNotFoundByCache(string) ? 1 : 0)) != 0) {
            log.info((Object)("Based on last search results, '" + string + "' cannot be found."));
            return null;
        }
        File file2 = new File(this.cls_Wzccmd.getSpecialFolders().getProgramFiles());
        file = this.getApplicationInDirectory(string, file2, -1);
        if (file != null) {
            log.debug((Object)("Found application '" + string + "' in program files (" + file.getAbsolutePath() + ")."));
            this.cls_LastFoundLocation.put(string.toLowerCase(), file);
            return file;
        }
        File file3 = new File(this.cls_Wzccmd.getSpecialFolders().getPath(0L));
        file = this.getApplicationInDirectory(string, file3, 3);
        if (file != null) {
            log.debug((Object)("Found application '" + string + "' in the user's home directory (" + file.getAbsolutePath() + ")."));
            this.cls_LastFoundLocation.put(string.toLowerCase(), file);
            return file;
        }
        this.cls_LastFoundLocation.put(string.toLowerCase(), null);
        this.cls_LastFoundFullPass = System.currentTimeMillis();
        log.debug((Object)("Could not find application '" + string + "."));
        return null;
    }

    private File getFileFromCache(String string) {
        File file;
        if (this.cls_LastFoundLocation.containsKey(string.toLowerCase()) && (file = this.cls_LastFoundLocation.get(string.toLowerCase())) != null) {
            return file;
        }
        return null;
    }

    private boolean isFileNotFoundByCache(String string) {
        if (this.cls_LastFoundFullPass + 120000L > System.currentTimeMillis()) {
            log.debug((Object)("Making decision on '" + string + "' by last search results."));
            return !this.cls_LastFoundLocation.containsKey(string.toLowerCase()) || this.cls_LastFoundLocation.get(string.toLowerCase()) == null;
        }
        return false;
    }
}

