/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.windows;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.common.ApplicationProvider;
import com.cloudpath.common.os.common.NicProvider;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.os.common.WirelessProvider;
import com.cloudpath.common.os.windows.network.WindowsNicProvider;
import com.cloudpath.common.os.windows.provider.WindowsApplicationProvider;
import com.cloudpath.common.os.windows.provider.WindowsFilePathProvider;
import com.cloudpath.common.os.windows.util.ElevationListener;
import com.cloudpath.common.os.windows.util.Wzccmd;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.pojo.NetworkInterfaces;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.JnlpUtil;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.OsInfo;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public class WindowsOsProvider
implements OsProvider {
    private static final Logger log = Logger.getLogger(WindowsOsProvider.class);
    private final OsInfo cls_OsInfo;
    private final FileHandler cls_FileHandler;
    private final CommandHandler cls_CommandHandler;
    private final NicProvider cls_NicProvider;
    private final WirelessProvider cls_WirelessProvider;
    private final Wzccmd cls_Wzccmd;
    private final WindowsApplicationProvider cls_ApplicationProvider;

    public WindowsOsProvider(FileHandler fileHandler, CommandHandler commandHandler) throws Exception {
        this(fileHandler, commandHandler, null);
    }

    public WindowsOsProvider(FileHandler fileHandler, CommandHandler commandHandler, ElevationListener elevationListener) throws Exception {
        log.info((Object)(Util.getClassName(this) + " is intializing..."));
        this.cls_OsInfo = OsConstants.getOsInfo();
        this.cls_FileHandler = fileHandler;
        this.cls_CommandHandler = commandHandler;
        this.cls_WirelessProvider = null;
        this.cls_Wzccmd = new Wzccmd(this.cls_CommandHandler, elevationListener);
        this.cls_NicProvider = new WindowsNicProvider(this.cls_Wzccmd);
        this.cls_ApplicationProvider = new WindowsApplicationProvider(this.cls_Wzccmd, new WindowsFilePathProvider(this.cls_Wzccmd.getSpecialFolders()));
    }

    public OsInfo getOsInfo() {
        return this.cls_OsInfo;
    }

    public FileHandler getFileHandler() {
        return this.cls_FileHandler;
    }

    public CommandHandler getCommandHandler() {
        return this.cls_CommandHandler;
    }

    public NicProvider getNicProvider() {
        return this.cls_NicProvider;
    }

    public WirelessProvider getWirelessProvider() {
        return this.cls_WirelessProvider;
    }

    public ApplicationProvider getApplicationProvider() {
        return this.cls_ApplicationProvider;
    }

    public void openBrowser(String string) throws Exception {
        try {
            URL uRL = new URL(string);
            if (!JnlpUtil.openBrowser(uRL)) {
                this.cls_Wzccmd.openBrowser(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            log.warn((Object)("URL '" + string + "' was malformed.  Will not open browser."));
        }
    }

    public String generateSupportFile() {
        return null;
    }

    public void runScript(String string, boolean bl) throws Exception {
        if (bl) {
            // empty if block
        }
        File file = File.createTempFile("xpc_post_", ".bat");
        this.cls_FileHandler.writeFile(file, string);
        CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(new String[]{file.getAbsolutePath()});
        commandResponse.waitFor();
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public void renewIp(NetworkInterface networkInterface) {
    }

    public Wzccmd getWzccmd() {
        return this.cls_Wzccmd;
    }

    public String getSystemId() {
        if (this.cls_NicProvider != null) {
            try {
                NetworkInterface networkInterface;
                NetworkInterfaces networkInterfaces = this.cls_NicProvider.getAllInterfaces(false);
                if (networkInterfaces != null && networkInterfaces.getInterfaceCount() > 0 && (networkInterface = networkInterfaces.getInterface(0)) != null && networkInterface.getMacAddress() != null && networkInterface.getMacAddress().length() > 0) {
                    return networkInterface.getMacAddress();
                }
            }
            catch (Exception exception) {
                log.error((Object)"Error while getting all interfaces for system id.");
            }
        }
        return "[Unknown]";
    }

    public String getComputerManufacturer() {
        return this.cls_Wzccmd.getComputerManufacturer();
    }

    public String getComputerModel() {
        return this.cls_Wzccmd.getComputerModel();
    }

    public String getComputerCpuName() {
        return "[Unknown]";
    }

    public String getComputerInstalledRam() {
        return "[Unknown]";
    }

    public boolean isOnDomain() {
        return this.cls_Wzccmd.isPartOfDomain();
    }

    public String getOsName() {
        return this.cls_Wzccmd.getOsName();
    }

    public String getOsServicePack() {
        return this.cls_Wzccmd.getOsServicePack();
    }

    public String getOsBits() {
        return "[Unknown]";
    }
}

