/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.tiger.network.networkconnect;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.os.mac.common.plist.PlistConstants;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueBoolean;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueInteger;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueString;
import com.cloudpath.common.os.mac.tiger.network.internetconnect.InternetConnect;
import com.cloudpath.common.os.mac.tiger.network.internetconnect.MacSupplicantProfile;
import com.cloudpath.common.parse.InvalidXmlException;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class NetworkConnectPlist {
    private static final Logger log = Logger.getLogger(NetworkConnectPlist.class);
    public static final String NETWORK_CONNECT_FILE = "/Library/Preferences/ByHost/com.apple.networkConnect.${MAC}.plist";
    private static final String CONNECT_BY_DEFAULT = "ConnectByDefault";
    private static final String IPSEC = "IPSec";
    private static final String NETWORK_PORT = "Network Port";
    private static final String OUTER_IDENTITY = "OuterIdentity";
    private static final String PPP = "PPP";
    private static final String PPP_AUTH_NAME = "AuthName";
    private static final String PPP_AUTH_PASSWORD = "AuthPassword";
    private static final String PPP_USER_DEFINED_NAME = "UserDefinedName";
    private static final String PROTOCOLS = "Protocols";
    private static final String PROTOCOLS_ON = "On";
    private static final String PROTOCOLS_PROTOCOL = "Protocol";
    private static final String WIRELESS_NETWORK = "Wireless Network";
    public static final String TTLS_INNER_AUTHENTICATION = "TTLSInnerAuthentication";
    public static final String UNIQUE_IDENTIFIER = "UniqueIdentifier";
    public static final String EAP_FAST_PROVISION_PAC = "EAPFASTProvisionPAC";
    public static final String EAP_FAST_PROVISION_PAC_ANONYMOUSLY = "EAPFASTProvisionPACAnonymously";
    public static final String EAP_FAST_USE_PAC = "EAPFASTUsePAC";
    private static final String SERVICE_ID_8021X = "-2";
    private static final String IMPORT_SERVICE_ID_8021X = "8021X";
    private final FileHandler cls_FileHandler;
    private final CommandHandler cls_CommandHandler;
    private final File cls_File;

    public NetworkConnectPlist(FileHandler fileHandler, CommandHandler commandHandler, String string) {
        this.cls_FileHandler = fileHandler;
        this.cls_CommandHandler = commandHandler;
        this.cls_File = new File(FileUtil.getUserHome(), Util.replaceVariable(NETWORK_CONNECT_FILE, "MAC", string));
    }

    public File getFile() {
        return this.cls_File;
    }

    public MacSupplicantProfile[] load() throws IOException, InvalidXmlException {
        log.info((Object)"Will load network connect plist.");
        return NetworkConnectPlist.parse(this.getCurrentPlist(), false);
    }

    public void write(MacSupplicantProfile[] macSupplicantProfileArray) throws IOException, InvalidXmlException {
        Object object;
        Object object2;
        log.info((Object)"Will write network connect plist.");
        try {
            InternetConnect.readX(this.cls_CommandHandler, this.cls_FileHandler);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ArrayList<MacSupplicantProfile> arrayList = new ArrayList<MacSupplicantProfile>();
        for (int i = 0; i < macSupplicantProfileArray.length; ++i) {
            if (!macSupplicantProfileArray[i].getForceReadd()) {
                log.debug((Object)("Profile " + macSupplicantProfileArray[i].getProfileName() + " is not a forced readd."));
                arrayList.add(macSupplicantProfileArray[i]);
                continue;
            }
            log.debug((Object)("Profile " + macSupplicantProfileArray[i].getProfileName() + " is a forced readd."));
        }
        if (arrayList.size() != macSupplicantProfileArray.length) {
            log.info((Object)"At least one supplicant profile was marked as forcedReadd.");
            log.info((Object)"Will remove the forceAdd profile and write file.");
            MacSupplicantProfile[] macSupplicantProfileArray2 = new MacSupplicantProfile[arrayList.size()];
            arrayList.toArray(macSupplicantProfileArray2);
            this.write(macSupplicantProfileArray2);
            log.info((Object)"Done with forceAdd update.");
        }
        MacSupplicantProfile[] macSupplicantProfileArray3 = NetworkConnectPlist.getAdds(macSupplicantProfileArray);
        for (int i = 0; i < macSupplicantProfileArray3.length; ++i) {
            log.debug((Object)(" - Will write added profile " + macSupplicantProfileArray3[i].getProfileName() + "."));
            object2 = File.createTempFile("xpc_", ".internetconnect");
            Plist plist = NetworkConnectPlist.generatePlistForImport(new MacSupplicantProfile[]{macSupplicantProfileArray3[i]});
            this.cls_FileHandler.writeFile((File)object2, plist.getXml());
            InternetConnect.killApplication(this.cls_CommandHandler);
            object = this.cls_CommandHandler.executeCommand(new String[]{"/usr/bin/open", ((File)object2).getAbsolutePath()});
            MacUtil.runApplescript(this.cls_CommandHandler, this.cls_FileHandler, "tell application \"Finder\" to set visible of process \"Internet Connect\" to false");
            ((CommandResponse)object).waitFor();
            log.debug((Object)"Will wait for import to complete...");
            boolean bl = true;
            int n = 0;
            while (n < 4 && bl) {
                ++n;
                try {
                    Thread.sleep(1200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MacSupplicantProfile[] macSupplicantProfileArray4 = this.load();
                log.debug((Object)("  - On check " + n + ", " + macSupplicantProfileArray4.length + " were loaded."));
                for (int j = 0; j < macSupplicantProfileArray4.length; ++j) {
                    MacSupplicantProfile macSupplicantProfile = macSupplicantProfileArray4[j];
                    if (!macSupplicantProfileArray3[i].getProfileName().equals(macSupplicantProfile.getProfileName())) continue;
                    log.debug((Object)"     - Our new profile was found.");
                    if (macSupplicantProfile.getUniqueIdentifier() == null || macSupplicantProfile.getUniqueIdentifier().length() <= 0) continue;
                    log.debug((Object)"       - Our new profile is fully populated.  We are ready to continue.");
                    bl = false;
                }
            }
            log.debug((Object)"Import is complete.");
            InternetConnect.killApplication(this.cls_CommandHandler);
            if (((File)object2).delete()) continue;
            ((File)object2).deleteOnExit();
        }
        Plist plist = this.getCurrentPlist();
        object2 = NetworkConnectPlist.parse(plist, false);
        for (int i = 0; i < macSupplicantProfileArray3.length; ++i) {
            object = this.getProfileByName((MacSupplicantProfile[])object2, macSupplicantProfileArray3[i].getProfileName());
            if (object != null) {
                log.debug((Object)(" - For " + ((MacSupplicantProfile)object).getProfileName() + ", inserting unique identifier " + ((MacSupplicantProfile)object).getUniqueIdentifier() + "."));
                macSupplicantProfileArray3[i].setUniqueIdentifer(((MacSupplicantProfile)object).getUniqueIdentifier());
                continue;
            }
            log.error((Object)("Added profile '" + macSupplicantProfileArray3[i].getProfileName() + "' but it is not in the file."));
        }
        Plist plist2 = NetworkConnectPlist.generatePlistForUpdate(plist, macSupplicantProfileArray);
        log.debug((Object)("Will write file " + this.cls_File + " to handler."));
        this.cls_FileHandler.writeFile(this.cls_File, plist2.getXml());
    }

    private static MacSupplicantProfile[] getAdds(MacSupplicantProfile[] macSupplicantProfileArray) {
        ArrayList<MacSupplicantProfile> arrayList = new ArrayList<MacSupplicantProfile>();
        for (int i = 0; i < macSupplicantProfileArray.length; ++i) {
            MacSupplicantProfile macSupplicantProfile = macSupplicantProfileArray[i];
            if (macSupplicantProfile.getExists() && !macSupplicantProfile.getForceReadd()) continue;
            arrayList.add(macSupplicantProfile);
        }
        MacSupplicantProfile[] macSupplicantProfileArray2 = new MacSupplicantProfile[arrayList.size()];
        arrayList.toArray(macSupplicantProfileArray2);
        return macSupplicantProfileArray2;
    }

    private Plist getCurrentPlist() throws IOException, InvalidXmlException {
        log.debug((Object)("[CPN~] Will read from file " + this.cls_File));
        if (!this.cls_FileHandler.exists(this.cls_File)) {
            log.debug((Object)"NetworkConnect config file doesn't exist.  Will use blank.");
            return new Plist();
        }
        try {
            return PlistConstants.readPlist(this.cls_CommandHandler, this.cls_FileHandler, this.cls_File);
        }
        catch (Exception exception) {
            log.debug((Object)"Error occurred while parsing networkConnect config file.  Will use blank.", (Throwable)exception);
            return new Plist();
        }
    }

    private MacSupplicantProfile getProfileByName(MacSupplicantProfile[] macSupplicantProfileArray, String string) {
        for (int i = 0; i < macSupplicantProfileArray.length; ++i) {
            if (!string.equals(macSupplicantProfileArray[i].getProfileName())) continue;
            return macSupplicantProfileArray[i];
        }
        return null;
    }

    protected static Plist generatePlistForUpdate(Plist plist, MacSupplicantProfile[] macSupplicantProfileArray) {
        Plist plist2 = plist.clone();
        NetworkConnectPlist.populatePlist(plist2, false, macSupplicantProfileArray);
        return plist2;
    }

    protected static Plist generatePlistForImport(MacSupplicantProfile[] macSupplicantProfileArray) {
        Plist plist = new Plist();
        plist.setDict(new Dict());
        NetworkConnectPlist.populatePlist(plist, true, macSupplicantProfileArray);
        log.debug((Object)("PLIST FOR IMPORT \n" + plist.getXml()));
        return plist;
    }

    private static void populatePlist(Plist plist, boolean bl, MacSupplicantProfile[] macSupplicantProfileArray) {
        String string = bl ? IMPORT_SERVICE_ID_8021X : SERVICE_ID_8021X;
        ValueArray valueArray = plist.getDict().getArray(string, null);
        if (valueArray == null) {
            valueArray = new ValueArray();
            plist.getDict().addPair(string, valueArray);
        }
        valueArray.removeAllValues();
        for (int i = 0; i < macSupplicantProfileArray.length; ++i) {
            valueArray.addValue(NetworkConnectPlist.createDictForProfile(macSupplicantProfileArray[i], bl));
        }
        if (valueArray.getValueCount() == 0) {
            plist.getDict().removeKey(string);
        }
    }

    protected static final Dict createDictForProfile(MacSupplicantProfile macSupplicantProfile, boolean bl) {
        Dict dict = new Dict();
        if (macSupplicantProfile.getConnectByDefault()) {
            dict.addPair(CONNECT_BY_DEFAULT, new ValueBoolean(true));
        }
        if (macSupplicantProfile.isEapFastInitialized() || !EapFastPacFlag.NO_PAC.equals((Object)macSupplicantProfile.getEapFastPacFlag())) {
            dict.addPair(EAP_FAST_PROVISION_PAC, new ValueBoolean(macSupplicantProfile.getEapFastPacFlag().getAutoPac()));
            dict.addPair(EAP_FAST_PROVISION_PAC_ANONYMOUSLY, new ValueBoolean(macSupplicantProfile.getEapFastPacFlag().getAnonPac()));
            dict.addPair(EAP_FAST_USE_PAC, new ValueBoolean(macSupplicantProfile.getEapFastPacFlag().getUsePac()));
        }
        dict.addPair(IPSEC, new Dict());
        dict.addPair(NETWORK_PORT, new ValueString(macSupplicantProfile.getNetworkInterface()));
        if (macSupplicantProfile.getOuterIdentity().length() > 0) {
            dict.addPair(OUTER_IDENTITY, new ValueString(macSupplicantProfile.getOuterIdentity()));
        }
        String string = macSupplicantProfile.getUserName();
        String string2 = macSupplicantProfile.getPassword();
        Dict dict2 = new Dict();
        dict2.addPair(PPP_AUTH_NAME, new ValueString(string));
        if (macSupplicantProfile.getExists() || string2.length() > 0) {
            dict2.addPair(PPP_AUTH_PASSWORD, new ValueString(string2));
        }
        dict2.addPair(PPP_USER_DEFINED_NAME, new ValueString(macSupplicantProfile.getProfileName()));
        dict.addPair(PPP, dict2);
        ValueArray valueArray = new ValueArray();
        dict.addPair(PROTOCOLS, valueArray);
        KnownEapType[] objectArray = KnownEapType.values();
        int n = objectArray.length;
        for (int dict4 = 0; dict4 < n; ++dict4) {
            KnownEapType knownEapType = objectArray[dict4];
            Dict dict3 = new Dict();
            dict3.addPair(PROTOCOLS_ON, new ValueInteger(macSupplicantProfile.includesEapType(knownEapType.dbName) ? 1 : 0));
            dict3.addPair(PROTOCOLS_PROTOCOL, new ValueString(knownEapType.osName));
            valueArray.addValue(dict3);
        }
        String[] stringArray = macSupplicantProfile.getEapTypes();
        for (n = 0; n < stringArray.length; ++n) {
            if (KnownEapType.isDbNameKnown(stringArray[n])) continue;
            Dict dict4 = new Dict();
            dict4.addPair(PROTOCOLS_ON, new ValueBoolean(true));
            dict4.addPair(PROTOCOLS_PROTOCOL, new ValueString(stringArray[n]));
            valueArray.addValue(valueArray);
        }
        dict.addPair(TTLS_INNER_AUTHENTICATION, new ValueString(macSupplicantProfile.getTtlsInnerAuthentication().OsName));
        if (!bl && macSupplicantProfile.getUniqueIdentifier().length() > 0) {
            dict.addPair(UNIQUE_IDENTIFIER, new ValueString(macSupplicantProfile.getUniqueIdentifier()));
        }
        if (macSupplicantProfile.getSsid().length() > 0) {
            dict.addPair(WIRELESS_NETWORK, new ValueString(macSupplicantProfile.getSsid()));
        }
        return dict;
    }

    protected static synchronized MacSupplicantProfile[] parse(Plist plist, boolean bl) {
        if (plist.getDict() == null) {
            plist.setDict(new Dict());
        }
        ValueArray valueArray = plist.getDict().getArray(bl ? IMPORT_SERVICE_ID_8021X : SERVICE_ID_8021X, new ValueArray());
        MacSupplicantProfile[] macSupplicantProfileArray = new MacSupplicantProfile[valueArray.getValueCount()];
        for (int i = 0; i < valueArray.getValueCount(); ++i) {
            macSupplicantProfileArray[i] = NetworkConnectPlist.parseProfile(bl, i, (Dict)valueArray.getValue(i));
        }
        return macSupplicantProfileArray;
    }

    private static MacSupplicantProfile parseProfile(boolean bl, int n, Dict dict) {
        Dict dict2 = dict.getDict(PPP, new Dict());
        boolean bl2 = dict.getKeyValue(EAP_FAST_USE_PAC) != null;
        MacSupplicantProfile macSupplicantProfile = new MacSupplicantProfile(!bl, dict2.getString(PPP_USER_DEFINED_NAME, ""), dict.getString(UNIQUE_IDENTIFIER, ""), bl2);
        macSupplicantProfile.setIndex(n);
        macSupplicantProfile.setConnectByDefault(dict.getBoolean(CONNECT_BY_DEFAULT, false));
        macSupplicantProfile.setNetworkInterface(dict.getString(NETWORK_PORT, "en0"));
        macSupplicantProfile.setSsid(dict.getString(WIRELESS_NETWORK, ""));
        macSupplicantProfile.setUserName(dict2.getString(PPP_AUTH_NAME, ""));
        macSupplicantProfile.setPassword(dict2.getString(PPP_AUTH_PASSWORD, ""));
        macSupplicantProfile.setOuterIdentity(dict.getString(OUTER_IDENTITY, ""));
        macSupplicantProfile.setEapTypes(NetworkConnectPlist.parseEapTypes(dict.getArray(PROTOCOLS, new ValueArray())));
        macSupplicantProfile.setTtlsInnerAuthentication(TtlsInnerAuthentication.getByOsName(dict.getString(TTLS_INNER_AUTHENTICATION, "")));
        macSupplicantProfile.setEapFastPacFlag(EapFastPacFlag.getInstance(dict.getBoolean(EAP_FAST_USE_PAC, false), dict.getBoolean(EAP_FAST_PROVISION_PAC, false), dict.getBoolean(EAP_FAST_PROVISION_PAC_ANONYMOUSLY, false)));
        return macSupplicantProfile;
    }

    private static String[] parseEapTypes(ValueArray valueArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < valueArray.getValueCount(); ++i) {
            String string;
            Dict dict = (Dict)valueArray.getValue(i);
            if (dict.getInteger(PROTOCOLS_ON, 0L) != 1L || !((string = dict.getString(PROTOCOLS_PROTOCOL, null)) != null & string.length() > 0)) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KnownEapType {
        TTLS("TTLS", "TTLS"),
        TLS("TLS", "TLS"),
        EAP_FAST("EAP-FAST", "EAP-FAST"),
        PEAP("PEAP", "PEAP"),
        LEAP("LEAP", "LEAP"),
        MD5("MD5", "MD5");

        public final String osName;
        public final String dbName;

        private KnownEapType(String string2, String string3) {
            this.dbName = string2;
            this.osName = string3;
        }

        public static final boolean isDbNameKnown(String string) {
            for (KnownEapType knownEapType : KnownEapType.values()) {
                if (!knownEapType.dbName.equals(string)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EapFastPacFlag {
        NO_PAC(0),
        USE_PAC(1),
        USE_AUTO_PAC(2),
        USE_AUTO_ANON_PAC(3);

        public String dbName;
        private int cls_Id;

        private EapFastPacFlag(int n2) {
            this.dbName = n2 + "";
            this.cls_Id = n2;
        }

        public boolean getUsePac() {
            return this.cls_Id >= EapFastPacFlag.USE_PAC.cls_Id;
        }

        public boolean getAutoPac() {
            return this.cls_Id >= EapFastPacFlag.USE_AUTO_PAC.cls_Id;
        }

        public boolean getAnonPac() {
            return this.cls_Id >= EapFastPacFlag.USE_AUTO_ANON_PAC.cls_Id;
        }

        public static EapFastPacFlag getInstance(int n) {
            EapFastPacFlag[] eapFastPacFlagArray = EapFastPacFlag.values();
            for (int i = 0; i < eapFastPacFlagArray.length; ++i) {
                if (n != eapFastPacFlagArray[i].cls_Id) continue;
                return eapFastPacFlagArray[i];
            }
            return NO_PAC;
        }

        public static EapFastPacFlag getInstance(boolean bl, boolean bl2, boolean bl3) {
            if (bl && bl2 && bl3) {
                return USE_AUTO_ANON_PAC;
            }
            if (bl && bl2) {
                return USE_AUTO_PAC;
            }
            if (bl) {
                return USE_PAC;
            }
            return NO_PAC;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TtlsInnerAuthentication {
        MSCHAPV2("MSCHAPv2"),
        MSCHAP("MSCHAP"),
        CHAP("CHAP"),
        PAP("PAP"),
        NONE("NONE");

        public final String OsName;
        public final String dbName = this.name();

        private TtlsInnerAuthentication(String string2) {
            this.OsName = string2;
        }

        public static TtlsInnerAuthentication getByOsName(String string) {
            for (TtlsInnerAuthentication ttlsInnerAuthentication : TtlsInnerAuthentication.values()) {
                if (!ttlsInnerAuthentication.OsName.equals(string)) continue;
                return ttlsInnerAuthentication;
            }
            return null;
        }

        public static TtlsInnerAuthentication getByDbName(String string) {
            for (TtlsInnerAuthentication ttlsInnerAuthentication : TtlsInnerAuthentication.values()) {
                if (!ttlsInnerAuthentication.dbName.equals(string)) continue;
                return ttlsInnerAuthentication;
            }
            return null;
        }
    }
}

