/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.tiger.network.networkconnect;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.tiger.network.internetconnect.MacSupplicantProfile;
import com.cloudpath.common.os.mac.tiger.network.networkconnect.NetworkConnectPlist;
import com.cloudpath.common.parse.InvalidXmlException;
import com.cloudpath.common.util.FileHandler;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class NetworkConnectBuffer {
    private static final Logger log = Logger.getLogger(NetworkConnectBuffer.class);
    private final Vector<MacSupplicantProfile> cls_Profiles = new Vector();
    private final NetworkConnectPlist cls_Plist;

    public NetworkConnectBuffer(FileHandler fileHandler, CommandHandler commandHandler, String string) {
        this.cls_Plist = new NetworkConnectPlist(fileHandler, commandHandler, string);
    }

    public void refresh() {
        log.debug((Object)(this.getClass().getSimpleName() + " will refresh."));
        try {
            MacSupplicantProfile[] macSupplicantProfileArray = this.cls_Plist.load();
            log.debug((Object)("Loaded " + macSupplicantProfileArray.length + " profiles."));
            this.cls_Profiles.clear();
            for (int i = 0; i < macSupplicantProfileArray.length; ++i) {
                log.debug((Object)(" - Loaded profile '" + macSupplicantProfileArray[i].getProfileName() + "'"));
                this.cls_Profiles.add(macSupplicantProfileArray[i]);
            }
        }
        catch (IOException iOException) {
            log.error((Object)"Error occurred loading supplicant profiles.", (Throwable)iOException);
            this.cls_Profiles.clear();
        }
        catch (InvalidXmlException invalidXmlException) {
            log.error((Object)"Error occurred loading supplicant profiles.", (Throwable)invalidXmlException);
            this.cls_Profiles.clear();
        }
    }

    public boolean commit() throws Exception {
        log.debug((Object)(this.getClass().getSimpleName() + " will commit changes."));
        try {
            MacSupplicantProfile[] macSupplicantProfileArray = new MacSupplicantProfile[this.cls_Profiles.size()];
            this.cls_Profiles.toArray(macSupplicantProfileArray);
            this.cls_Plist.write(macSupplicantProfileArray);
            log.debug((Object)" - Will write plist.");
            return true;
        }
        catch (IOException iOException) {
            log.warn((Object)"Error occurred committing supplicant profiles.", (Throwable)iOException);
            throw iOException;
        }
        catch (InvalidXmlException invalidXmlException) {
            log.warn((Object)"Error occurred committing supplicant profiles.", (Throwable)invalidXmlException);
            throw invalidXmlException;
        }
    }

    public int getProfileCount() {
        return this.cls_Profiles.size();
    }

    public MacSupplicantProfile getProfile(int n) {
        return this.cls_Profiles.get(n);
    }

    public void add(MacSupplicantProfile macSupplicantProfile) {
        this.deleteProfile(macSupplicantProfile.getProfileName());
        this.cls_Profiles.add(macSupplicantProfile.getIndex(), macSupplicantProfile);
    }

    public void deleteProfile(String string) {
        MacSupplicantProfile macSupplicantProfile = this.getProfile(string);
        while (macSupplicantProfile != null) {
            this.cls_Profiles.remove(macSupplicantProfile.getIndex());
            macSupplicantProfile = this.getProfile(string);
        }
    }

    public MacSupplicantProfile getProfile(String string) {
        log.debug((Object)("Looking for profile '" + string + "'."));
        for (int i = 0; i < this.cls_Profiles.size(); ++i) {
            log.debug((Object)("  - Looking at: " + this.cls_Profiles.get(i).getProfileName()));
            if (!string.equals(this.cls_Profiles.get(i).getProfileName())) continue;
            log.debug((Object)"Found profile.");
            return this.cls_Profiles.get(i);
        }
        log.debug((Object)"Did not find profile.");
        return null;
    }
}

