/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.tiger.network.internetconnect;

import com.cloudpath.common.os.mac.tiger.network.networkconnect.NetworkConnectPlist;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.Util;
import org.apache.log4j.Logger;

public class MacSupplicantProfile {
    private static final Logger log = Logger.getLogger(MacSupplicantProfile.class);
    private final boolean cls_Exists;
    private String cls_UniqueIdentifier;
    private final boolean cls_EapFastInitialized;
    private int cls_Index = 0;
    private boolean cls_ConnectByDefault = false;
    private String cls_ProfileName = "";
    private String cls_NetworkInterface = "";
    private String cls_UserName = "";
    private String cls_Password = "";
    private String cls_Ssid = "";
    private String[] cls_EapTypes = new String[0];
    private NetworkConnectPlist.TtlsInnerAuthentication cls_TtlsInnerAuthentication = NetworkConnectPlist.TtlsInnerAuthentication.PAP;
    private String cls_OuterIdentity = "";
    private NetworkConnectPlist.EapFastPacFlag cls_EapFastPacFlag = NetworkConnectPlist.EapFastPacFlag.NO_PAC;
    private boolean cls_ForceReadd = false;

    public MacSupplicantProfile() {
        this(false, "", "", false);
    }

    public MacSupplicantProfile(boolean bl, String string, String string2, boolean bl2) {
        this.cls_Exists = bl;
        this.cls_ProfileName = string;
        this.cls_UniqueIdentifier = bl ? string2 : "";
        this.cls_EapFastInitialized = bl2;
    }

    public boolean getExists() {
        return this.cls_Exists;
    }

    public String getUniqueIdentifier() {
        return this.cls_UniqueIdentifier;
    }

    public void setUniqueIdentifer(String string) {
        this.cls_UniqueIdentifier = string;
    }

    public boolean isEapFastInitialized() {
        return this.cls_EapFastInitialized;
    }

    public void setIndex(int n) {
        this.cls_Index = n;
    }

    public int getIndex() {
        return this.cls_Index;
    }

    public void setConnectByDefault(boolean bl) {
        this.cls_ConnectByDefault = bl;
    }

    public boolean getConnectByDefault() {
        return this.cls_ConnectByDefault;
    }

    public void setProfileName(String string) {
        if (this.getExists() && !this.cls_ProfileName.equals(Util.getNonNull(string))) {
            throw new RuntimeException("An existing profile cannot have its name set. ");
        }
        this.cls_ProfileName = Util.getNonNull(string);
    }

    public String getProfileName() {
        return this.cls_ProfileName;
    }

    public void setNetworkInterface(String string) {
        this.cls_NetworkInterface = Util.getNonNull(string);
    }

    public String getNetworkInterface() {
        return this.cls_NetworkInterface;
    }

    public String getUserName() {
        return this.cls_UserName;
    }

    public void setUserName(String string) {
        this.cls_UserName = Util.getNonNull(string);
    }

    public String getPassword() {
        return this.cls_Password;
    }

    public void setSsid(String string) {
        this.cls_Ssid = Util.getNonNull(string);
    }

    public String getSsid() {
        return this.cls_Ssid;
    }

    public void setEapTypes(String[] stringArray) {
        this.cls_EapTypes = stringArray == null ? new String[]{} : stringArray;
    }

    public String[] getEapTypes() {
        return this.cls_EapTypes;
    }

    public void setPassword(String string) {
        this.cls_Password = Util.getNonNull(string);
        if (this.getExists() && this.cls_Password.length() > 0) {
            log.info((Object)("Setting password into existing profile " + this.getProfileName() + ".  Will force readd."));
            this.cls_ForceReadd = true;
        }
    }

    public boolean getForceReadd() {
        return this.cls_ForceReadd;
    }

    public String getEapTypesString() {
        String string = "";
        String[] stringArray = this.getEapTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.length() > 0) {
                string = string + ";";
            }
            string = string + stringArray[i];
        }
        return string;
    }

    public boolean includesEapType(String string) {
        for (int i = 0; i < this.cls_EapTypes.length; ++i) {
            if (!this.cls_EapTypes[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setTtlsInnerAuthentication(NetworkConnectPlist.TtlsInnerAuthentication ttlsInnerAuthentication) {
        this.cls_TtlsInnerAuthentication = ttlsInnerAuthentication == null ? NetworkConnectPlist.TtlsInnerAuthentication.PAP : ttlsInnerAuthentication;
    }

    public NetworkConnectPlist.TtlsInnerAuthentication getTtlsInnerAuthentication() {
        return this.cls_TtlsInnerAuthentication;
    }

    public void setOuterIdentity(String string) {
        this.cls_OuterIdentity = Util.getNonNull(string);
    }

    public String getOuterIdentity() {
        return this.cls_OuterIdentity;
    }

    public void setEapFastPacFlag(NetworkConnectPlist.EapFastPacFlag eapFastPacFlag) {
        this.cls_EapFastPacFlag = eapFastPacFlag == null ? NetworkConnectPlist.EapFastPacFlag.NO_PAC : eapFastPacFlag;
    }

    public NetworkConnectPlist.EapFastPacFlag getEapFastPacFlag() {
        return this.cls_EapFastPacFlag;
    }

    public void setEapTypes(String string) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            this.setEapTypes(new String[0]);
        } else {
            String[] stringArray = string.split(";");
            this.setEapTypes(stringArray);
        }
    }
}

