/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.tiger.network.internetconnect;

import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueBoolean;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueString;
import com.cloudpath.common.util.Util;

public class InternetConnectPlist {
    private static final String KEY_8021X = "802.1X";
    private static final String KEY_COLLAPSE_WINDOWS = "CollapseWindow";
    private static final String KEY_LAST_CONFIGURATION_INFO = "Last Configuration Info";
    private static final String KEY_SELECTED_8021X_PROFILE = "-2";
    private static final String KEY_SERVICE_ID = "ServiceID";
    private static final String KEY_NSWINDOWS_FRAME_INTERNET_CONNECT_MAIN_WINDOW = "NSWindow Frame Internet Connect Main Window";
    private static final String SERVICE_ID_8021X = "-2";
    private Plist cls_Plist = null;
    private boolean cls_IsDirty = false;

    public Plist getPlist() {
        return this.cls_Plist;
    }

    public boolean isDirty() {
        return this.cls_IsDirty;
    }

    public void setIsDirty(boolean bl) {
        this.cls_IsDirty = bl;
    }

    public void load() {
        this.setPlist(null);
    }

    public void setPlist(Plist plist) {
        this.cls_Plist = plist;
        this.cls_IsDirty = false;
    }

    public String getSelected8021xProfile() {
        ValueString valueString = this.getPairValueForSelected8021xProfile();
        if (valueString != null) {
            return valueString.getValue();
        }
        return "";
    }

    public void setSelected8021xProfile(String string) {
        ValueString valueString = this.getPairValueForSelected8021xProfile();
        if (valueString != null && !string.equals(valueString.getValue())) {
            valueString.setValue(string);
            this.cls_IsDirty = true;
        }
    }

    private ValueString getPairValueForSelected8021xProfile() {
        PairValue pairValue = this.cls_Plist.getDict().getKeyValue(KEY_LAST_CONFIGURATION_INFO);
        if (pairValue != null && pairValue instanceof Dict && (pairValue = ((Dict)pairValue).getKeyValue("-2")) != null && pairValue instanceof ValueString) {
            return (ValueString)pairValue;
        }
        return null;
    }

    public boolean get8021X() {
        ValueBoolean valueBoolean = this.getPairValueFor8021X();
        if (valueBoolean != null) {
            return valueBoolean.getValue();
        }
        return true;
    }

    public void set8021X(boolean bl) {
        ValueBoolean valueBoolean = this.getPairValueFor8021X();
        if (valueBoolean != null && bl != valueBoolean.getValue()) {
            valueBoolean.setValue(bl);
            this.cls_IsDirty = true;
        }
    }

    private ValueBoolean getPairValueFor8021X() {
        PairValue pairValue = this.cls_Plist.getDict().getKeyValue(KEY_8021X);
        if (pairValue != null && pairValue instanceof ValueBoolean) {
            return (ValueBoolean)pairValue;
        }
        return null;
    }

    public boolean getCollapseWindow() {
        ValueBoolean valueBoolean = this.getPairValueForCollapseWindows();
        if (valueBoolean != null) {
            return valueBoolean.getValue();
        }
        return true;
    }

    public void setCollapseWindow(boolean bl) {
        ValueBoolean valueBoolean = this.getPairValueForCollapseWindows();
        if (valueBoolean != null && bl != valueBoolean.getValue()) {
            valueBoolean.setValue(bl);
            this.cls_IsDirty = true;
        }
    }

    private ValueBoolean getPairValueForCollapseWindows() {
        PairValue pairValue = this.cls_Plist.getDict().getKeyValue(KEY_COLLAPSE_WINDOWS);
        if (pairValue != null && pairValue instanceof ValueBoolean) {
            return (ValueBoolean)pairValue;
        }
        return null;
    }

    public boolean isServiceId8021x() {
        return "-2".equals(this.getServiceId());
    }

    public void setServiceIdTo8021x() {
        this.setServiceId("-2");
    }

    public String getServiceId() {
        ValueString valueString = this.getPairValueForServiceId();
        if (valueString != null) {
            return valueString.getValue();
        }
        return null;
    }

    public void setServiceId(String string) {
        ValueString valueString = this.getPairValueForServiceId();
        if (valueString != null && !string.equals(valueString.getValue())) {
            valueString.setValue(string);
            this.cls_IsDirty = true;
        }
    }

    private ValueString getPairValueForServiceId() {
        PairValue pairValue = this.cls_Plist.getDict().getKeyValue(KEY_SERVICE_ID);
        if (pairValue != null && pairValue instanceof ValueString) {
            return (ValueString)pairValue;
        }
        return null;
    }

    public void setLocation(int n, int n2) {
        PairValue pairValue = this.cls_Plist.getDict().getKeyValue(KEY_NSWINDOWS_FRAME_INTERNET_CONNECT_MAIN_WINDOW);
        if (pairValue != null && pairValue instanceof ValueString) {
            String[] stringArray = ((ValueString)pairValue).getString().split(" ");
            if (stringArray.length > 2) {
                stringArray[0] = "" + n;
                stringArray[1] = "" + n2;
            }
            String string = Util.join(stringArray, ' ');
            ((ValueString)pairValue).setString(string);
            this.cls_IsDirty = true;
        }
    }
}

