/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.tiger.network.internetconnect;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.os.mac.common.plist.PlistConstants;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.tiger.network.internetconnect.InternetConnectPlist;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.FileUtil;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class InternetConnect {
    private static final Logger log = Logger.getLogger(InternetConnectPlist.class);
    public static final String PATH = "/Library/Preferences/com.apple.internetconnect.plist";
    private final FileHandler cls_FileHandler;
    private final CommandHandler cls_CommandHandler;

    public InternetConnect(FileHandler fileHandler, CommandHandler commandHandler) {
        this.cls_FileHandler = fileHandler;
        this.cls_CommandHandler = commandHandler;
    }

    public final InternetConnectPlist read() throws Exception {
        return InternetConnect.readX(this.cls_CommandHandler, this.cls_FileHandler);
    }

    public static final InternetConnectPlist readX(CommandHandler commandHandler, FileHandler fileHandler) {
        Object object;
        File file = new File(FileUtil.getUserHome(), PATH);
        if (!file.exists()) {
            log.debug((Object)"InternetConnect config file doesn't exist.  We need to initialize it.");
            try {
                InternetConnect.openApplication(commandHandler, fileHandler, false);
            }
            catch (Exception exception) {
                log.debug((Object)"Failed to open internet connect", (Throwable)exception);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = "tell application \"Internet Connect\"\nquit\nend tell";
            try {
                MacUtil.runApplescript(commandHandler, fileHandler, (String)object);
            }
            catch (Exception exception) {
                log.debug((Object)"Failed to quit internet connect.");
            }
        }
        try {
            object = PlistConstants.readPlist(commandHandler, fileHandler, file);
            InternetConnectPlist internetConnectPlist = new InternetConnectPlist();
            internetConnectPlist.setPlist((Plist)object);
            return internetConnectPlist;
        }
        catch (Exception exception) {
            log.error((Object)"An error occurred while reading internetConnect.plist.  Will return blank.", (Throwable)exception);
            InternetConnectPlist internetConnectPlist = new InternetConnectPlist();
            internetConnectPlist.setPlist(new Plist());
            return internetConnectPlist;
        }
    }

    public final boolean write(InternetConnectPlist internetConnectPlist) throws IOException {
        log.debug((Object)"Write of internetconnect.plist requested.");
        if (internetConnectPlist.isDirty()) {
            String string = internetConnectPlist.getPlist().getXml();
            log.debug((Object)("Will write:\n" + string));
            this.cls_FileHandler.writeFile(new File(FileUtil.getUserHome(), PATH), string);
            log.debug((Object)"Internetconnect.plist written.");
            return true;
        }
        return false;
    }

    public static final void openApplication(CommandHandler commandHandler, FileHandler fileHandler, boolean bl) throws IOException {
        InternetConnect.killApplication(commandHandler);
        CommandResponse commandResponse = commandHandler.executeCommand(new String[]{"/usr/bin/open", new File(File.listRoots()[0], "/Applications/Internet Connect.app").getAbsolutePath()});
        if (!bl) {
            String string = "tell application \"Finder\" to set visible of process \"Internet Connect\" to false";
            try {
                MacUtil.runApplescript(commandHandler, fileHandler, string);
            }
            catch (Exception exception) {
                log.debug((Object)"Failed to hide internet connect.", (Throwable)exception);
            }
        }
        commandResponse.waitFor();
    }

    public static final void killApplication(CommandHandler commandHandler) throws IOException {
        CommandResponse commandResponse = commandHandler.executeCommand(new String[]{"killall", "Internet Connect"});
        commandResponse.waitFor();
    }
}

