/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.snowleopard.network.eap;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.common.network.eap.EapProfileManager;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.util.KeychainException;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEap;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapBinding;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapBindingPlist;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfile;
import com.cloudpath.common.os.mac.snowleopard.network.networksetup.SnowLeopardExportProfile;
import com.cloudpath.common.os.mac.snowleopard.network.networksetup.SnowLeopardNetworkSetupReader;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.SpecializedException;
import com.cloudpath.common.util.Util;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SnowLeopardEapProfileManager
implements EapProfileManager {
    private static final Logger log = Logger.getLogger(SnowLeopardEapProfileManager.class);
    private static int INSTANCE_COUNT = 0;
    private final Maccmd cls_Maccmd;
    private final LeopardEapBindingPlist cls_EapBindingPlist;
    private final SnowLeopardNetworkSetupReader cls_NetworkSetup;
    private String cls_InterfaceName;
    private String cls_MacAddress;
    private String cls_ServiceName;
    private SnowLeopardExportProfile cls_EapProfiles = new SnowLeopardExportProfile();
    private HashMap<String, String> cls_NewProfileNameToSsid = new HashMap();

    public SnowLeopardEapProfileManager(FileHandler fileHandler, CommandHandler commandHandler, Maccmd maccmd, LeopardEapBindingPlist leopardEapBindingPlist, SnowLeopardNetworkSetupReader snowLeopardNetworkSetupReader) {
        this.cls_EapBindingPlist = leopardEapBindingPlist;
        this.cls_Maccmd = maccmd;
        this.cls_NetworkSetup = snowLeopardNetworkSetupReader;
        if (INSTANCE_COUNT++ > 0) {
            log.error((Object)"Invalid duplicant instantiation.", (Throwable)new Exception("Duplicate instantiation of " + this.getClass().getName()));
        }
    }

    public int getProfileCount() {
        return this.cls_EapProfiles.getAnyProfileCount();
    }

    public LeopardEapProfile getProfile(int n) {
        return this.cls_EapProfiles.getAnyProfile(n);
    }

    public LeopardEapProfile getProfileByName(String string) {
        return this.cls_EapProfiles.getAnyProfileByName(string);
    }

    public LeopardEapProfile getProfileByUniqueIdentifier(String string) {
        return this.cls_EapProfiles.getAnyProfileByUniqueIdentifier(string);
    }

    public String getProfileNames() {
        return this.cls_EapProfiles.getProfileNames();
    }

    public void addProfile(LeopardEapProfile leopardEapProfile, String string) {
        String string2 = leopardEapProfile != null ? leopardEapProfile.getWirelessNetwork() : "";
        this.resolveConflicts(leopardEapProfile, this.cls_MacAddress, false, null);
        if (leopardEapProfile.isSystemProfile()) {
            log.info((Object)"Adding System Profile...");
            leopardEapProfile.getEapConfig().setDesiredPassword_SPECIAL(leopardEapProfile.getDesiredPassword());
            leopardEapProfile.getEapConfig().setWirelessNetwork_SPECIAL(leopardEapProfile.getWirelessNetwork());
            leopardEapProfile.getEapConfig().setWirelessSecurity_SPECIAL(leopardEapProfile.getWirelessSecurity());
            this.cls_EapProfiles.setSystemProfile(leopardEapProfile.getEapConfig());
        } else if (leopardEapProfile.isLoginProfile()) {
            log.info((Object)"Adding Login Profile...");
            this.cls_EapProfiles.addLoginProfile(leopardEapProfile);
        } else {
            log.info((Object)"Adding User Profile...");
            this.cls_EapProfiles.addUserProfile(leopardEapProfile);
            if (string2 != null) {
                this.cls_NewProfileNameToSsid.put(leopardEapProfile.getUserDefinedName(), string2);
            }
        }
    }

    public void deleteProfile(String string) {
        log.debug((Object)("Will delete EAP profile by name '" + string + "'."));
        LeopardEapProfile leopardEapProfile = this.cls_EapProfiles.getAnyProfileByName(string);
        if (leopardEapProfile == null) {
            log.warn((Object)("  - EAP Profile '" + string + "' was not found."));
        } else {
            while (leopardEapProfile != null) {
                LeopardEapProfile leopardEapProfile2 = this.cls_EapProfiles.getLoginProfileByName(leopardEapProfile.getUserDefinedName());
                if (leopardEapProfile.isSystemProfile()) {
                    this.cls_EapProfiles.deleteSystemProfile(string);
                } else if (leopardEapProfile2 != null) {
                    this.cls_EapProfiles.deleteLoginProfile(string);
                } else {
                    log.debug((Object)(" - Will delete user profile '" + string + "'..."));
                    this.cls_EapProfiles.deleteUserProfile(string);
                }
                this.removePasswordFromKeychain(leopardEapProfile);
                String string2 = leopardEapProfile.getUniqueIdentifier();
                if (string2 != null && string2.length() > 0) {
                    this.cls_EapBindingPlist.removeEapBindingByUniqueId(this.cls_MacAddress, string2);
                }
                leopardEapProfile = this.cls_EapProfiles.getAnyProfileByName(string);
            }
        }
    }

    public void refresh(String string) {
        log.debug((Object)(" - Will refresh eap profile information for '" + string + "'."));
        Util.assertNotBlank(this, "InterfaceName", string);
        this.cls_NewProfileNameToSsid.clear();
        this.cls_InterfaceName = string;
        this.cls_MacAddress = this.cls_NetworkSetup.getMacAddress(this.cls_InterfaceName);
        this.cls_ServiceName = this.cls_NetworkSetup.getNetworkServiceByInterfaceName(string);
        log.debug((Object)(" - The service name is '" + this.cls_ServiceName + "' for '" + string + "."));
        this.cls_EapProfiles = this.cls_NetworkSetup.get8021XProfiles(this.cls_ServiceName, false);
        this.cls_EapBindingPlist.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(String string, boolean bl) throws IOException, SpecializedException {
        Object[] objectArray;
        Object object;
        Cloneable cloneable;
        int n;
        log.debug((Object)"Will commit EAP profiles.");
        for (n = 0; n < this.cls_EapProfiles.getUserProfileCount(); ++n) {
            cloneable = this.cls_EapProfiles.getUserProfile(n);
            SnowLeopardEapProfileManager.processProfilePassword(this.cls_Maccmd, cloneable, false, bl);
        }
        for (n = 0; n < this.cls_EapProfiles.getSystemProfileCount(); ++n) {
            cloneable = this.cls_EapProfiles.getSystemProfile(n);
            object = SnowLeopardExportProfile.createSystemProfile((LeopardEap)cloneable);
            SnowLeopardEapProfileManager.processProfilePassword(this.cls_Maccmd, (LeopardEapProfile)object, true, bl);
        }
        this.cls_NetworkSetup.set8021XProfiles(this.cls_ServiceName, this.cls_EapProfiles);
        log.debug((Object)"  - EAP Profiles written.");
        this.cls_EapProfiles = this.cls_NetworkSetup.get8021XProfiles(this.cls_ServiceName, false);
        cloneable = this.cls_NewProfileNameToSsid;
        synchronized (cloneable) {
            objectArray = this.cls_NewProfileNameToSsid.keySet().toArray();
        }
        if (this.cls_MacAddress != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                object = this.cls_NewProfileNameToSsid.get(objectArray[i]);
                if (object != null) {
                    LeopardEapProfile leopardEapProfile = this.cls_EapProfiles.getUserProfileByName((String)objectArray[i]);
                    if (leopardEapProfile == null) continue;
                    String string2 = leopardEapProfile.getUniqueIdentifier();
                    if (string2 != null) {
                        this.cls_EapBindingPlist.removeEapBinding(this.cls_MacAddress, (String)object);
                        this.cls_EapBindingPlist.removeEapBindingByUniqueId(this.cls_MacAddress, string2);
                        this.cls_EapBindingPlist.setEapBinding(this.cls_MacAddress, (String)object, string2);
                        continue;
                    }
                    log.warn((Object)"Unique id is null.");
                    continue;
                }
                log.warn((Object)"SSID is null.");
            }
        } else {
            log.warn((Object)"Mac address is null.  Will skip eap binding.");
        }
        this.cls_EapBindingPlist.write();
    }

    private static void processProfilePassword(Maccmd maccmd, LeopardEapProfile leopardEapProfile, boolean bl, boolean bl2) throws SpecializedException {
        if (leopardEapProfile != null) {
            String string;
            log.debug((Object)("Will prepare profile '" + leopardEapProfile.getUserDefinedName() + "'..."));
            if (leopardEapProfile.getDesiredPassword() != null && leopardEapProfile.getDesiredPassword().length() > 0) {
                log.debug((Object)"  - Profile has new/updated password.");
                string = leopardEapProfile.getDesiredPassword();
            } else if (leopardEapProfile.getEapConfig() != null && leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId() != null && leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId().length() == 0) {
                log.debug((Object)"  - Profile is new but does not have password.");
                string = leopardEapProfile.getEapConfig().isTlsOnly() ? null : "";
            } else {
                log.debug((Object)"  - Profile is existing and does not have a password change.");
                string = null;
            }
            if (string != null) {
                String string2;
                String string3;
                if (leopardEapProfile.getEapConfig() == null || leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId() == null || leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId().length() == 0) {
                    string3 = PlistUtil.generateGuid();
                    log.debug((Object)("  - Profile is being assigned guid " + string3));
                    if (leopardEapProfile.getEapConfig() == null) {
                        leopardEapProfile.setEapConfig(new LeopardEap());
                    }
                    leopardEapProfile.getEapConfig().setUserPasswordKeychainItemId(string3);
                    leopardEapProfile.setUniqueIdentifier(string3);
                } else {
                    string3 = leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId();
                    log.info((Object)("Old keychain item id was " + string3 + ".  Will delete it."));
                    maccmd.deleteGenericPassword(bl ? Maccmd.Keychain.system : Maccmd.Keychain.login, bl ? "" : leopardEapProfile.getEapConfig().getUserName(), string3);
                    string2 = PlistUtil.generateGuid();
                    log.info((Object)("Updating keychain item id to " + string2));
                    leopardEapProfile.getEapConfig().setUserPasswordKeychainItemId(string2);
                    leopardEapProfile.setUniqueIdentifier(string2);
                }
                if (bl) {
                    string3 = "802.1X Password";
                    string2 = "";
                } else {
                    string3 = "Network password for " + leopardEapProfile.getUserDefinedName();
                    string2 = leopardEapProfile.getEapConfig().getUserName();
                }
                String string4 = leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId();
                String string5 = "Internet Connect";
                String string6 = "This password is for network access.  At the time of creation, it was used by the 802.1X profile named '" + leopardEapProfile.getUserDefinedName() + "'.  If you delete this password, you will be prompted to enter your password when accessing the network.";
                log.debug((Object)("Will create keychain entry for account '" + string2 + "' and service '" + string4 + "' with display label '" + string3 + "'."));
                int n = maccmd.setGenericPassword(bl ? Maccmd.Keychain.system : Maccmd.Keychain.login, string3, string2, string4, string5, string6, string);
                if (n != 0) {
                    log.warn((Object)("The attempt to set the password into the keychain failed.  Error code was " + n + "."));
                    if (bl2) {
                        throw new KeychainException(n);
                    }
                }
            }
            leopardEapProfile.setUniqueIdentifier(leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId());
            if (leopardEapProfile.getUniqueIdentifier().length() == 0) {
                log.debug((Object)"** EAP profile contains a blank unique ID.  Will populate.");
                leopardEapProfile.setUniqueIdentifier(PlistUtil.generateGuid());
            }
            if (leopardEapProfile.getUserDefinedName().length() == 0) {
                log.debug((Object)"** EAP profile contains a blank name.  Will populate.");
                leopardEapProfile.setUserDefinedName(PlistUtil.generateGuid());
            }
            log.debug((Object)("Done with profile " + leopardEapProfile.getUserDefinedName() + " (" + leopardEapProfile.getUniqueIdentifier() + ")"));
        }
    }

    public boolean isKeychainPasswordCorrect(Maccmd.Keychain keychain, String string, String string2, String string3) {
        return this.cls_Maccmd.doesGenericPasswordMatch(keychain, string, string2, string3);
    }

    public void removePasswordFromKeychain(LeopardEapProfile leopardEapProfile) {
        if (leopardEapProfile != null) {
            log.debug((Object)("  - Will clean up keychain for deleted profile " + leopardEapProfile.getUserDefinedName() + "..."));
            String string = leopardEapProfile.getEapConfig().getUserName();
            String string2 = leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId();
            if (string2 != null && string2.length() > 0) {
                log.info((Object)("  - Will remove password from keychain for account '" + string + "' and service '" + string2 + "'."));
                this.cls_Maccmd.deleteGenericPassword(Maccmd.Keychain.login, string, string2);
            }
        }
    }

    public void resolveConflicts(LeopardEapProfile leopardEapProfile, String string, boolean bl, String string2) {
        boolean bl2 = false;
        try {
            String string3;
            log.info((Object)"Will resolve conflicts...");
            String string4 = leopardEapProfile != null ? leopardEapProfile.getWirelessNetwork() : "";
            log.info((Object)("  - Will look for other EAP profiles using this SSID '" + string4 + "' on service name '" + this.cls_ServiceName + "'."));
            String string5 = string3 = leopardEapProfile != null ? leopardEapProfile.getUniqueIdentifier() : null;
            if (this.cls_EapBindingPlist != null && this.cls_ServiceName != null && string4 != null && string != null) {
                LeopardEapProfile leopardEapProfile2;
                int n;
                log.info((Object)"  - Will process bindings.");
                LeopardEapBinding[] leopardEapBindingArray = this.cls_EapBindingPlist.getBindingsBySsid(string, string4);
                if (leopardEapBindingArray != null) {
                    log.info((Object)(leopardEapBindingArray.length + " EAP Bindings exist."));
                }
                for (n = 0; leopardEapBindingArray != null && n < leopardEapBindingArray.length; ++n) {
                    if (leopardEapBindingArray[n] == null || leopardEapBindingArray[n].getUniqueIdentifier() == null) continue;
                    log.info((Object)("  - Unique ID is " + leopardEapBindingArray[n].getUniqueIdentifier()));
                    if (string3 != null && string3.equals(leopardEapBindingArray[n].getUniqueIdentifier())) continue;
                    log.info((Object)("   - New profile unique identifier is: " + string3));
                    log.info((Object)("   - The EAP profile with uniqueId '" + leopardEapBindingArray[n].getUniqueIdentifier() + "' is pointing at '" + string4 + "'."));
                    leopardEapProfile2 = this.getProfileByUniqueIdentifier(leopardEapBindingArray[n].getUniqueIdentifier());
                    if (leopardEapProfile2 != null) {
                        log.warn((Object)("   - Will delete EAP profile '" + leopardEapProfile2.getUserDefinedName() + "' because it points at the ssid '" + string4 + "'."));
                        this.deleteProfile(leopardEapProfile2.getUserDefinedName());
                        bl2 = true;
                        continue;
                    }
                    log.info((Object)"   - Other profile not found.");
                }
                log.info((Object)"Will process profiles...");
                for (n = 0; n < this.getProfileCount(); ++n) {
                    leopardEapProfile2 = this.getProfile(n);
                    String string6 = leopardEapProfile2.getWirelessNetwork();
                    if (leopardEapProfile == null || string6 == null || !string6.equals(string4)) continue;
                    log.info((Object)("  - Found ssid profile with unique ID " + (leopardEapProfile2 != null ? leopardEapProfile2.getUniqueIdentifier() : "Null")));
                    if (leopardEapProfile.getUniqueIdentifier() != null && leopardEapProfile.getUniqueIdentifier().equals(leopardEapProfile2.getUniqueIdentifier())) continue;
                    log.info((Object)("   - Found '" + string4 + "'... (" + leopardEapProfile2.getUserDefinedName() + ")  Will delete '" + leopardEapProfile2.getUserDefinedName() + "'."));
                    this.deleteProfile(leopardEapProfile2.getUserDefinedName());
                    --n;
                    bl2 = true;
                }
                log.info((Object)("Will look by default profile name 'WPA: " + string4 + "'..."));
                LeopardEapProfile leopardEapProfile3 = this.getProfileByName("WPA: " + string4);
                if (leopardEapProfile3 != null) {
                    log.info((Object)("  - Found profile by default name at " + leopardEapProfile3.getUniqueIdentifier()));
                    if (string3 == null || !string3.equals(leopardEapProfile3.getUniqueIdentifier())) {
                        log.info((Object)"An EAP profile still exists with the default WPA name for the ssid.  Will delete it.");
                        this.deleteProfile("WPA: " + string4);
                        bl2 = true;
                    } else {
                        log.info((Object)("Profile found by name 'WPA: " + string4 + "' but either (a) our profile is new or (b) the unique IDs are different."));
                    }
                }
                log.info((Object)("Will look by default profile name 'WPA2: " + string4 + "'..."));
                leopardEapProfile3 = this.getProfileByName("WPA2: " + string4);
                if (leopardEapProfile3 != null) {
                    log.info((Object)("  - Found profile by default name at " + leopardEapProfile3.getUniqueIdentifier()));
                    if (string3 == null || !string3.equals(leopardEapProfile3.getUniqueIdentifier())) {
                        log.info((Object)"An EAP profile still exists with the default WPA2 name for the ssid.  Will delete it.");
                        this.deleteProfile("WPA2: " + string4);
                        bl2 = true;
                    } else {
                        log.info((Object)("Profile found by name 'WPA2: " + string4 + "' but either (a) our profile is new or (b) the unique IDs are different."));
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)"An exception occurred while resolving conflicts.", (Throwable)exception);
        }
        log.info((Object)("Done resolving conflicts.  CommitOnChanges: " + bl + ", ChangesOccurred: " + bl2));
        if (bl && bl2) {
            try {
                log.info((Object)"Will commit changes...");
                this.commit(string2, false);
            }
            catch (Exception exception) {
                log.error((Object)"Failed to commit changes after cleaning up conflicts.", (Throwable)exception);
            }
        }
        log.info((Object)"Done resolving conflicts.");
    }
}

