/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.snowleopard.network;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.common.network.airport.SsidManager;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportNetwork;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportPreferencePlist;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardSsid;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapBinding;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapBindingPlist;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfile;
import com.cloudpath.common.os.mac.snowleopard.network.eap.SnowLeopardEapProfileManager;
import com.cloudpath.common.os.mac.snowleopard.network.networksetup.SnowLeopardNetworkSetupReader;
import com.cloudpath.common.util.FileHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SnowLeopardSsidManager
implements SsidManager {
    private static final Logger log = Logger.getLogger(SnowLeopardSsidManager.class);
    private static final String PSK_SERVICE_NAME = "AirPort Network";
    private static final String PSK_KIND = "AirPort network password";
    private final HashMap<String, LeopardSsid> cls_Ssids = new HashMap();
    private final Vector<LeopardSsid> cls_DeletedSsids = new Vector();
    private final Vector<LeopardSsid> cls_AddedSsids = new Vector();
    private final Maccmd cls_Maccmd;
    private final LeopardEapBindingPlist cls_EapBindings;
    private final SnowLeopardEapProfileManager cls_EapProfileManager;
    private final SnowLeopardNetworkSetupReader cls_NetworkSetup;
    private String cls_InterfaceName = "";
    private final LeopardAirportPreferencePlist cls_AirportPreferences;

    public SnowLeopardSsidManager(FileHandler fileHandler, CommandHandler commandHandler, Maccmd maccmd, LeopardEapBindingPlist leopardEapBindingPlist, SnowLeopardNetworkSetupReader snowLeopardNetworkSetupReader, SnowLeopardEapProfileManager snowLeopardEapProfileManager) {
        this.cls_Maccmd = maccmd;
        this.cls_AirportPreferences = new LeopardAirportPreferencePlist(fileHandler, commandHandler, maccmd);
        this.cls_EapBindings = leopardEapBindingPlist;
        this.cls_EapProfileManager = snowLeopardEapProfileManager;
        this.cls_NetworkSetup = snowLeopardNetworkSetupReader;
    }

    public void refresh(String string, String string2) {
        log.info((Object)("Refreshing SSID manager with interface '" + string + "' and mac address '" + string2 + "'."));
        this.cls_InterfaceName = string;
        this.cls_AirportPreferences.refresh();
        this.cls_EapBindings.refresh();
        this.cls_EapProfileManager.refresh(this.cls_InterfaceName);
        this.cls_Ssids.clear();
        this.cls_DeletedSsids.clear();
        this.cls_AddedSsids.clear();
        log.debug((Object)(" - Will load preferred wireless networks for interface '" + this.cls_InterfaceName + "'."));
        String[] stringArray = this.cls_NetworkSetup.getPreferredWirelessNetworks(this.cls_InterfaceName);
        for (int i = 0; i < stringArray.length; ++i) {
            log.debug((Object)("   - Loading ssid " + i + " with ssid '" + stringArray[i] + "'."));
            LeopardSsid leopardSsid = new LeopardSsid();
            leopardSsid.setSsid(stringArray[i]);
            leopardSsid.setIndex(i);
            leopardSsid.setDot1xProfile("WPA: " + stringArray[i]);
            boolean bl = false;
            LeopardEapBinding[] leopardEapBindingArray = this.cls_EapBindings.getBindingsBySsid(string2, stringArray[i]);
            if (leopardEapBindingArray != null && leopardEapBindingArray.length > 0) {
                log.debug((Object)("   - Loading " + leopardEapBindingArray.length + " bindings for ssid."));
                for (int j = 0; !bl && j < leopardEapBindingArray.length; ++j) {
                    if (leopardEapBindingArray[j] == null) continue;
                    String string3 = leopardEapBindingArray[j].getUniqueIdentifier();
                    LeopardEapProfile leopardEapProfile = this.cls_EapProfileManager.getProfileByUniqueIdentifier(string3);
                    if (leopardEapProfile != null) {
                        String string4 = leopardEapProfile.getUserDefinedName();
                        log.debug((Object)("   - Profile name is '" + string4 + "' for '" + string3 + "'."));
                        if (string4 == null || string4.length() <= 0) continue;
                        leopardSsid.setDot1xProfile(string4);
                        leopardSsid.setDot1xUniqueProfileId(leopardEapProfile.getUniqueIdentifier());
                        bl = true;
                        continue;
                    }
                    log.debug((Object)("   - ID " + string3 + " found in binding but profile doesn't exist."));
                }
            }
            try {
                LeopardAirportNetwork leopardAirportNetwork = this.cls_AirportPreferences.getKnownNetworkBySsid(stringArray[i]);
                if (leopardAirportNetwork != null) {
                    leopardSsid.setSecurityType(leopardAirportNetwork.getSecurityType());
                    leopardSsid.setUniqueNetworkId(leopardAirportNetwork.getUniqueNetworkId());
                    leopardSsid.setRememberedChannels(leopardAirportNetwork.getRememberedChannels());
                    leopardSsid.setScanDirected(leopardAirportNetwork.getScanDirected());
                }
            }
            catch (Exception exception) {
                log.warn((Object)"An error occurred while loading airport preferences information.", (Throwable)exception);
            }
            log.debug((Object)("   - Done loading ssid " + i + " with ssid '" + stringArray[i] + "'."));
            this.cls_Ssids.put(leopardSsid.getSsid(), leopardSsid);
        }
    }

    public int getSsidCount() {
        return this.cls_Ssids.size();
    }

    public LeopardSsid getSsid(String string) {
        LeopardSsid leopardSsid = this.cls_Ssids.get(string);
        if (leopardSsid != null) {
            leopardSsid = (LeopardSsid)leopardSsid.clone();
        }
        return leopardSsid;
    }

    public void setSsid(LeopardSsid leopardSsid) {
        log.debug((Object)("Setting ssid: " + leopardSsid));
        if (leopardSsid != null) {
            if (this.cls_Ssids.containsKey(leopardSsid.getSsid())) {
                log.debug((Object)"  - SSID already exists.  Will remove existing one.");
                this.removeSsid(leopardSsid.getSsid());
            }
            this.cls_Ssids.put(leopardSsid.getSsid(), leopardSsid);
            this.cls_AddedSsids.add(leopardSsid);
        }
    }

    public void removeSsid(String string) {
        log.debug((Object)("Will remove ssid '" + string + "'."));
        if (string != null) {
            LeopardSsid leopardSsid = this.cls_Ssids.remove(string);
            if (leopardSsid != null) {
                log.debug((Object)("  - Adding ssid '" + string + "' to list to be deleted."));
                this.cls_DeletedSsids.add((LeopardSsid)leopardSsid.clone());
            }
            for (int i = 0; i < this.cls_AddedSsids.size(); ++i) {
                if (!string.equals(this.cls_AddedSsids.get(i).getSsid())) continue;
                log.debug((Object)("  - SSID '" + string + "' was previously added.  Will remove add reference."));
                this.cls_AddedSsids.remove(i);
            }
        }
    }

    public void commit(String string, String string2) throws IOException {
        int n;
        log.info((Object)("Will commit wireless configuration for '" + string + "' and '" + string2 + "'..."));
        this.cls_EapBindings.refresh();
        for (n = 0; n < this.cls_DeletedSsids.size(); ++n) {
            if (this.cls_DeletedSsids.get(n) == null) continue;
            this.doDeleteSsid(this.cls_DeletedSsids.get(n), string, string2);
        }
        for (n = 0; n < this.cls_AddedSsids.size(); ++n) {
            if (this.cls_AddedSsids.get(n) == null) continue;
            this.doAddSsid(this.cls_AddedSsids.get(n), string, string2);
        }
        log.debug((Object)"  - Will persist the eap binding changes.");
        this.cls_EapBindings.write();
        log.info((Object)"Done committing wireless configuration.");
    }

    private void doDeleteSsid(LeopardSsid leopardSsid, String string, String string2) {
        if (leopardSsid != null) {
            log.info((Object)("   -  Will perform deletion of ssid '" + leopardSsid.getSsid() + "' from interface '" + string + "' with mac '" + string2 + "'."));
            this.cls_NetworkSetup.deletePreferredWirelessNetwork(this.cls_InterfaceName, leopardSsid.getSsid());
            this.cls_EapBindings.removeEapBinding(string2, leopardSsid.getSsid());
        }
    }

    private void doAddSsid(LeopardSsid leopardSsid, String string, String string2) throws IOException {
        if (leopardSsid != null) {
            Object object;
            String string3;
            log.info((Object)("Adding ssid " + leopardSsid.getSsid() + " to interface " + string + " (" + string2 + ")"));
            if (leopardSsid.getSecurityType().IsPsk) {
                log.debug((Object)" - Ssid is PSK.  Will cache the psk.");
                string3 = leopardSsid.getSsid() + " Wireless Network";
                object = "This password is for the " + leopardSsid.getSsid() + " wireless network.  This network utilizes this password as a pre-shared key for encryption.";
                if (leopardSsid.getPskUniquePasswordId().length() == 0) {
                    leopardSsid.setPskUniquePasswordId(PlistUtil.generateGuid());
                }
                if (leopardSsid.getPsk() != null && leopardSsid.getPsk().length() > 0) {
                    int n = this.cls_Maccmd.setGenericPassword(Maccmd.Keychain.login, string3, leopardSsid.getSsid(), PSK_SERVICE_NAME, PSK_KIND, (String)object, leopardSsid.getPsk());
                    if (n != 0) {
                        log.error((Object)(" - Failed to add the generic psk password for the Leopard SSID " + leopardSsid.getSsid() + ".  Will continue without cached password.  Error code was " + n + "."));
                    }
                } else if (leopardSsid.getSecurityType().Is8021X) {
                    // empty if block
                }
            }
            if (leopardSsid.getSecurityType() != null && leopardSsid.getSecurityType().Is8021X) {
                log.debug((Object)(" - Will add the eap binding for " + leopardSsid.getSsid() + " to " + leopardSsid.getDot1xProfile() + " (" + leopardSsid.getDot1xUniqueProfileId() + ")."));
                if (leopardSsid.getDot1xUniqueProfileId() == null || leopardSsid.getDot1xUniqueProfileId().length() == 0) {
                    string3 = leopardSsid.getDot1xProfile();
                    log.debug((Object)(" - Profile name is '" + string3 + "'."));
                    if (string3 != null && string3.length() > 0) {
                        object = this.cls_EapProfileManager.getProfileByName(string3);
                        if (object != null) {
                            log.debug((Object)(" - Found EAP profile at '" + ((LeopardEapProfile)object).getUniqueIdentifier() + "'."));
                            leopardSsid.setDot1xUniqueProfileId(((LeopardEapProfile)object).getUniqueIdentifier());
                        } else {
                            log.debug((Object)" - Could not find EAP profile.");
                        }
                    }
                }
                log.debug((Object)" - Will update eap bindings.");
                this.cls_EapBindings.setEapBinding(string2, leopardSsid.getSsid(), leopardSsid.getDot1xUniqueProfileId());
                log.debug((Object)" - Done updating eap bindings.");
            }
            log.debug((Object)(" - Will add the preferred network '" + leopardSsid.getSsid() + "'."));
            this.cls_NetworkSetup.addPreferredWirelessNetwork(this.cls_InterfaceName, leopardSsid.getSsid(), leopardSsid.getIndex(), leopardSsid.getSecurityType(), leopardSsid.getPsk());
        }
        log.debug((Object)("Done adding ssid " + leopardSsid.getSsid()));
    }

    public boolean isKeychainPskCorrect(String string, String string2) {
        log.debug((Object)("Will check if keychain PSK is correct for ssid '" + string + "'."));
        return this.cls_Maccmd.doesGenericPasswordMatch(Maccmd.Keychain.login, string, PSK_SERVICE_NAME, string2);
    }
}

