/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.lion;

import com.cloudpath.common.cert.CertUtil;
import com.cloudpath.common.os.mac.common.plist.PlistConstants;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEap;
import com.cloudpath.common.parse.InvalidXmlException;
import com.cloudpath.common.parse.ParseManager;
import com.cloudpath.common.util.FileUtil;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class MobileConfigProfile {
    private static final Logger log = Logger.getLogger(MobileConfigProfile.class);
    private static final String TYPE_ETHERNET = "com.apple.firstactiveethernet.managed";
    private static final String TYPE_WIRELESS = "com.apple.wifi.managed";
    private static final String KEYCHAIN_ID_WIRELESS = "com.apple.network.eap.user.item.wlan.ssid.";
    private Plist cls_Plist;

    public MobileConfigProfile(String string) throws InvalidXmlException {
        log.info((Object)"Will parse mobileconfig information.");
        if (string != null) {
            if (string.contains("<?xml")) {
                string = string.substring(string.indexOf("<?xml"));
            }
            if (string.contains("</plist>")) {
                string = string.substring(0, string.lastIndexOf("</plist>") + 8);
            }
            log.info((Object)("Xml for parsing: " + string));
        }
        ParseManager parseManager = new ParseManager(PlistConstants.PLIST_ELEMENTS);
        this.cls_Plist = (Plist)parseManager.parse(string);
    }

    public String getXmlWithCredentialsForAdd(String string, String string2) {
        return this.getPlistWithCredentials(string, string2, true, false).getXml();
    }

    public Plist getPlistWithCredentials(String string, String string2, boolean bl, boolean bl2) {
        log.info((Object)"Will generate config information...");
        Plist plist = this.cls_Plist.clone();
        ValueArray valueArray = plist.getDict().getArray("PayloadContent", new ValueArray());
        for (int i = 0; i < valueArray.getValueCount(); ++i) {
            Object object;
            if (!(valueArray.getValue(i) instanceof Dict)) continue;
            log.info((Object)(" - Looking at " + i));
            Dict dict = (Dict)valueArray.getValue(i);
            String string3 = dict.getString("PayloadType", "");
            boolean bl3 = TYPE_WIRELESS.equals(string3);
            boolean bl4 = TYPE_ETHERNET.equals(string3);
            if (!bl3 && !bl4) continue;
            String string4 = null;
            if (bl3) {
                object = dict.getString("SSID_STR", "");
                string4 = KEYCHAIN_ID_WIRELESS + (String)object;
                log.info((Object)("  - Found wifi entry for ssid '" + (String)object + "'."));
            } else {
                log.info((Object)"  - Found ethernet entry.");
            }
            object = dict.getDict("EAPClientConfiguration", null);
            if (object != null) {
                log.info((Object)"  - Found EAP Client entry.");
                if (bl) {
                    if (((Dict)object).getBoolean("OneTimeUserPassword", false)) {
                        log.info((Object)"  - Profile has one-time-password set to true.  Will blank out password.");
                        string2 = "";
                    } else {
                        log.info((Object)"  - Profile is not one-time-password.");
                    }
                } else {
                    log.info((Object)"  - Request is to include even though OTP.");
                }
                ((Dict)object).removeKey("UserName");
                if (bl2 && string4 != null) {
                    ((Dict)object).removeKey("UserPasswordKeychainItemID");
                }
                if (string != null && string.length() > 0) {
                    log.info((Object)"  - Will populate username.");
                    ((Dict)object).addPair("UserName", string);
                    if (bl2 && string4 != null) {
                        log.info((Object)"  - Will add linkage.");
                        ((Dict)object).addPair("UserPasswordKeychainItemID", string4);
                    } else {
                        log.info((Object)"  - Will not add linkage.");
                    }
                } else {
                    log.info((Object)"  - Will not populate username.");
                }
                ((Dict)object).removeKey("UserPassword");
                if (string2 != null && string2.length() > 0) {
                    log.info((Object)"  - Will populate password.");
                    ((Dict)object).addPair("UserPassword", string2);
                    continue;
                }
                log.info((Object)"  - Will not populate password.");
                continue;
            }
            log.warn((Object)"EapConfigDict is null.  Unable to inject credentials.");
            log.warn((Object)dict.getXml(""));
        }
        return plist;
    }

    public LeopardEap getEapConfigForReconnect(String string, String string2, int n, String string3) {
        log.debug((Object)("Will find eapconfig in mobileconfig profile for interface type '" + n + "' and ssid '" + string3 + "'."));
        Dict dict = this.getEapClientConfigDictForReconnect(string, string2, n, string3);
        log.debug((Object)("Got Dict: " + dict));
        if (dict != null) {
            log.debug((Object)"Will parse dict into eapConfig.");
            LeopardEap leopardEap = new LeopardEap();
            leopardEap.parse(dict);
            return leopardEap;
        }
        log.debug((Object)"Dict is null.  Will not attempt to parse.");
        return null;
    }

    public Dict getEapClientConfigDictForReconnect(String string, String string2, int n, String string3) {
        log.info((Object)("Will find EapClientConfig for interface type '" + n + "' and SSID '" + string3 + "'."));
        Plist plist = this.getPlistWithCredentials(string, string2, false, true);
        ValueArray valueArray = plist.getDict().getArray("PayloadContent", new ValueArray());
        for (int i = 0; i < valueArray.getValueCount(); ++i) {
            Dict dict;
            Dict dict2;
            if (!(valueArray.getValue(i) instanceof Dict) || (dict2 = (Dict)valueArray.getValue(i)) == null) continue;
            String string4 = dict2.getString("PayloadType", "");
            log.debug((Object)("  - Payload Type: " + string4));
            if (n == 2 && TYPE_WIRELESS.equals(string4)) {
                log.debug((Object)("  - Will check vs SSID '" + string3 + "' vs '" + dict2.getString("SSID_STR", "") + "'..."));
                if (!string3.equals(dict2.getString("SSID_STR", ""))) continue;
                log.debug((Object)"  - Will get EapClientConfig");
                dict = dict2.getDict("EAPClientConfiguration", null);
                if (dict == null) continue;
                log.debug((Object)"  - Found eapclientconfig.");
                return dict;
            }
            if (n != 1 || !TYPE_ETHERNET.equals(string4)) continue;
            log.debug((Object)"  - Will get Wired EapClientConfig");
            dict = dict2.getDict("EAPClientConfiguration", null);
            if (dict == null) continue;
            log.debug((Object)"  - Found eapclientconfig.");
            return dict;
        }
        log.debug((Object)"  - DID NOT FIND EAP CLIENT CONFIG.");
        return null;
    }

    public String getPayloadDisplayName() {
        return this.cls_Plist.getDict().getString("PayloadDisplayName", null);
    }

    public String getPayloadPayloadIdentifier() {
        return this.cls_Plist.getDict().getString("PayloadIdentifier", null);
    }

    public String getFirstSsid() {
        log.info((Object)"Will find ssid in profile...");
        ValueArray valueArray = this.cls_Plist.getDict().getArray("PayloadContent", new ValueArray());
        for (int i = 0; i < valueArray.getValueCount(); ++i) {
            Dict dict;
            if (!(valueArray.getValue(i) instanceof Dict) || (dict = (Dict)valueArray.getValue(i)) == null) continue;
            String string = dict.getString("PayloadType", "");
            log.debug((Object)("  - Payload Type: " + string));
            if (!TYPE_WIRELESS.equals(string)) continue;
            String string2 = dict.getString("SSID_STR", null);
            log.info((Object)(" - Found wireless profile with ssid '" + string2 + "'."));
            if (string2 == null) continue;
            return string2;
        }
        log.debug((Object)"*** Could not find ssid in profile.");
        return null;
    }

    public String getPsk() {
        log.info((Object)"Will find psk in profile...");
        ValueArray valueArray = this.cls_Plist.getDict().getArray("PayloadContent", new ValueArray());
        for (int i = 0; i < valueArray.getValueCount(); ++i) {
            Dict dict;
            if (!(valueArray.getValue(i) instanceof Dict) || (dict = (Dict)valueArray.getValue(i)) == null) continue;
            String string = dict.getString("PayloadType", "");
            log.debug((Object)("  - Payload Type: " + string));
            if (!TYPE_WIRELESS.equals(string)) continue;
            String string2 = dict.getString("Password", null);
            log.info((Object)" - Found psk.");
            if (string2 == null) continue;
            return string2;
        }
        log.debug((Object)"*** Could not find psk in profile.");
        return null;
    }

    public String getEncryptionType() {
        log.info((Object)"Will find encryption type in profile...");
        ValueArray valueArray = this.cls_Plist.getDict().getArray("PayloadContent", new ValueArray());
        for (int i = 0; i < valueArray.getValueCount(); ++i) {
            Dict dict;
            if (!(valueArray.getValue(i) instanceof Dict) || (dict = (Dict)valueArray.getValue(i)) == null) continue;
            String string = dict.getString("PayloadType", "");
            log.debug((Object)("  - Payload Type: " + string));
            if (!TYPE_WIRELESS.equals(string)) continue;
            String string2 = dict.getString("EncryptionType", null);
            log.info((Object)(" - Found encryption type '" + string2 + "'."));
            if (string2 == null) continue;
            return string2;
        }
        log.debug((Object)"*** Could not find encryptionType in profile.");
        return null;
    }

    public String[] getDot1XPayloadUUIDs(boolean bl, boolean bl2) {
        Object object;
        log.debug((Object)"Will find dot1x UUIDs...");
        Vector<String> vector = new Vector<String>();
        if (this.cls_Plist != null && this.cls_Plist.getDict() != null) {
            object = this.cls_Plist.getDict().getArray("PayloadContent", new ValueArray());
            for (int i = 0; i < ((ValueArray)object).getValueCount(); ++i) {
                String string;
                log.debug((Object)("- Looking at entry " + i));
                if (!(((ValueArray)object).getValue(i) instanceof Dict)) continue;
                log.debug((Object)" - Entry is dict.");
                Dict dict = (Dict)((ValueArray)object).getValue(i);
                String string2 = dict.getString("PayloadType", "");
                log.debug((Object)(" - Entry type is '" + string2 + "'."));
                if (bl && TYPE_WIRELESS.equals(string2)) {
                    String string3;
                    string = dict.getString("SSID_STR", "");
                    log.info((Object)(" - Found wifi entry for ssid '" + string + "'."));
                    String string4 = dict.getString("PayloadDisplayName", null);
                    if (string4 != null && string4.startsWith("Disable ")) {
                        string3 = dict.getString("PayloadUUID", null);
                        log.info((Object)(" - Ignoring UUID " + string3 + " for conflicting SSID."));
                        continue;
                    }
                    string3 = dict.getString("PayloadUUID", null);
                    log.info((Object)(" - UUID is " + string3));
                    if (string3 == null) continue;
                    vector.add(string3);
                    continue;
                }
                if (bl2 && TYPE_ETHERNET.equals(string2)) {
                    log.info((Object)" - Found ethernet entry.");
                    string = dict.getString("PayloadUUID", null);
                    log.info((Object)(" - UUID is " + string));
                    if (string == null) continue;
                    vector.add(string);
                    continue;
                }
                log.info((Object)" - Entry is neither wireless nor wired.");
            }
        }
        object = new String[vector.size()];
        vector.toArray((T[])object);
        log.debug((Object)("Array size is " + ((String[])object).length));
        return object;
    }

    public static MobileConfigProfile loadMobileConfigProfile(String string) {
        log.info((Object)("Will load mobileconfig: " + string));
        String string2 = null;
        try {
            string2 = FileUtil.read(string);
        }
        catch (Exception exception) {
            log.error((Object)("Unable to read profile: " + string), (Throwable)exception);
        }
        if (string2 != null) {
            try {
                return new MobileConfigProfile(string2);
            }
            catch (InvalidXmlException invalidXmlException) {
                log.error((Object)("XML is Invalid: " + string2), (Throwable)invalidXmlException);
            }
        }
        return null;
    }

    public static MobileConfigProfile loadMobileConfigProfile(File file) {
        log.info((Object)("Will load mobileconfig: " + file.getAbsolutePath()));
        String string = null;
        try {
            string = FileUtil.read(file);
        }
        catch (Exception exception) {
            log.error((Object)("Unable to read profile: " + file.getAbsolutePath()), (Throwable)exception);
        }
        if (string != null) {
            try {
                return new MobileConfigProfile(string);
            }
            catch (InvalidXmlException invalidXmlException) {
                log.error((Object)("XML is Invalid: " + string), (Throwable)invalidXmlException);
            }
        }
        return null;
    }

    public X509Certificate getClientPk12() {
        log.info((Object)"Will find client p12.");
        ValueArray valueArray = this.cls_Plist.getDict().getArray("PayloadContent", new ValueArray());
        for (int i = 0; i < valueArray.getValueCount(); ++i) {
            Dict dict;
            if (!(valueArray.getValue(i) instanceof Dict) || (dict = (Dict)valueArray.getValue(i)) == null) continue;
            String string = dict.getString("PayloadType", "");
            log.debug((Object)("  - Payload Type: " + string));
            if (!"com.apple.security.pkcs12".equals(string)) continue;
            String string2 = dict.getString("Password", "");
            String string3 = dict.getData("PayloadContent", "");
            try {
                BASE64Decoder bASE64Decoder = new BASE64Decoder();
                byte[] byArray = bASE64Decoder.decodeBuffer(string3);
                return CertUtil.getPublicKeyFromP12(byArray, string2);
            }
            catch (Exception exception) {
                log.info((Object)"Unable to parse P12 from mobileconfig.", (Throwable)exception);
                return null;
            }
        }
        log.debug((Object)"  - Did not find p12 in mobileconfig.");
        return null;
    }
}

