/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.security;

import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Pair;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.leopard.security.LeopardTrustSetting;
import com.cloudpath.common.util.OrderedMap;
import com.cloudpath.common.util.Util;
import org.apache.log4j.Logger;

public class LeopardTrustSettingPlist {
    private static final Logger log = Logger.getLogger(LeopardTrustSettingPlist.class);
    public static final String TRUST_LIST = "trustList";
    public static final String TRUST_VERSION = "trustVersion";
    private final OrderedMap cls_ThumbprintToTrustSetting = new OrderedMap();
    private int cls_TrustVersion = 1;

    public void setTrustVersion(int n) {
        this.cls_TrustVersion = n;
    }

    public int getTrustVersion() {
        return this.cls_TrustVersion;
    }

    public LeopardTrustSetting getTrustSettingByThumbprint(String string) {
        log.debug((Object)("Will get trust settings for thumbprint " + string));
        LeopardTrustSetting leopardTrustSetting = (LeopardTrustSetting)this.cls_ThumbprintToTrustSetting.get(Util.formatCertificateThumbprint(string));
        log.debug((Object)("Trust settings for thumbprint is " + leopardTrustSetting));
        return leopardTrustSetting;
    }

    public boolean isCertificateTrusted(String string, LeopardTrustSetting.SettingType[] settingTypeArray) {
        LeopardTrustSetting leopardTrustSetting = this.getTrustSettingByThumbprint(string);
        if (leopardTrustSetting != null) {
            return leopardTrustSetting.isAlwaysTrusted(settingTypeArray);
        }
        return false;
    }

    public synchronized void parse(Plist plist) {
        log.debug((Object)"Will parse trust settings...");
        this.cls_ThumbprintToTrustSetting.clear();
        if (plist.getDict() == null) {
            plist.setDict(new Dict());
        }
        Dict dict = plist.getDict().getDict(TRUST_LIST, new Dict());
        for (int i = 0; i < dict.getPairCount(); ++i) {
            Pair pair = dict.getPair(i);
            if (pair == null) continue;
            String string = pair.getKey();
            log.debug((Object)(" - Loading thumbprint " + string));
            PairValue pairValue = pair.getValue();
            if (pairValue == null || !(pairValue instanceof Dict)) continue;
            LeopardTrustSetting leopardTrustSetting = new LeopardTrustSetting();
            leopardTrustSetting.parse(string, (Dict)pairValue);
            this.cls_ThumbprintToTrustSetting.put(string, leopardTrustSetting);
        }
        plist.getDict().getInteger(TRUST_VERSION, this.getTrustVersion());
    }

    public Plist generatePlist() {
        if (this.cls_ThumbprintToTrustSetting.size() == 0) {
            return null;
        }
        Dict dict = new Dict();
        Dict dict2 = new Dict();
        dict.addPair(TRUST_LIST, dict2);
        for (int i = 0; i < this.cls_ThumbprintToTrustSetting.size(); ++i) {
            String string = (String)this.cls_ThumbprintToTrustSetting.getKeyAt(i);
            LeopardTrustSetting leopardTrustSetting = (LeopardTrustSetting)this.cls_ThumbprintToTrustSetting.getValueAt(i);
            if (string == null || string.length() <= 0 || leopardTrustSetting == null) continue;
            dict2.addPair(string, leopardTrustSetting.generate());
        }
        dict.addPair(TRUST_VERSION, this.getTrustVersion());
        Plist plist = new Plist();
        plist.setDict(dict);
        return plist;
    }
}

