/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.security;

import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueData;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueDate;
import com.cloudpath.common.util.OrderedMap;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LeopardTrustSetting {
    private static final Logger log = Logger.getLogger(LeopardTrustSetting.class);
    public static final String ISSUER_NAME = "issuerName";
    public static final String MOD_DATE = "modDate";
    public static final String SERIAL_NUMBER = "serialNumber";
    public static final String TRUST_SETTINGS = "trustSettings";
    public static final String TRUST_SETTINGS_POLICY = "kSecTrustSettingsPolicy";
    public static final String TRUST_SETTINGS_RESULT = "kSecTrustSettingsResult";
    public static final String TRUST_SETTINGS_ALLOWED_ERROR = "kSecTrustSettingsAllowedError";
    private String cls_Thumbprint = "";
    private String cls_IssuerName = "";
    private long cls_ModDate = 0L;
    private String cls_SerialNumber = "";
    private OrderedMap cls_TrustLevels = new OrderedMap();
    private OrderedMap cls_AllowedErrors = new OrderedMap();
    private HashMap<String, Vector<String>> cls_AllowedErrorsPolicy = new HashMap();
    private boolean cls_AllTrusted = false;

    public void setThumbprint(String string) {
        this.cls_Thumbprint = string;
    }

    public String getThumbprint() {
        return this.cls_Thumbprint;
    }

    public void setIssuerName(String string) {
        this.cls_IssuerName = string;
    }

    public String getIssuerName() {
        return this.cls_IssuerName;
    }

    public void setModDate(long l) {
        this.cls_ModDate = l;
    }

    public long getModDate() {
        return this.cls_ModDate;
    }

    public void setSerialNumber(String string) {
        this.cls_SerialNumber = string;
    }

    public String getSerialNumber() {
        return this.cls_SerialNumber;
    }

    public void addTrustLevel(String string, SecTrustSettingsResult secTrustSettingsResult) {
        this.cls_TrustLevels.put(string, (Object)secTrustSettingsResult);
    }

    public void addAllowedError(long l, long l2, String string) {
        this.cls_AllowedErrors.put((Object)l, (Object)l2);
        String string2 = l + "_" + l2;
        Vector<String> vector = this.cls_AllowedErrorsPolicy.get(string2);
        if (vector == null) {
            vector = new Vector();
            this.cls_AllowedErrorsPolicy.put(string2, vector);
        }
        vector.add(string);
    }

    public SecTrustSettingsResult getTrustLevel(SettingType settingType) {
        if (this.cls_TrustLevels.size() == 0 || !this.cls_TrustLevels.containsKey(settingType.Key)) {
            log.debug((Object)"  - Looking for wildcard.");
            if (this.cls_TrustLevels.containsKey(SettingType.WILDCARD.Key)) {
                return (SecTrustSettingsResult)((Object)this.cls_TrustLevels.get(SettingType.WILDCARD.Key));
            }
            return SecTrustSettingsResult.DENY;
        }
        SecTrustSettingsResult secTrustSettingsResult = (SecTrustSettingsResult)((Object)this.cls_TrustLevels.get(settingType.Key));
        log.debug((Object)("  - Found level: " + (Object)((Object)secTrustSettingsResult)));
        return secTrustSettingsResult;
    }

    public boolean isAlwaysTrusted(SettingType[] settingTypeArray) {
        log.debug((Object)"Will check if certificate is trusted...");
        for (int i = 0; i < settingTypeArray.length; ++i) {
            SecTrustSettingsResult secTrustSettingsResult = this.getTrustLevel(settingTypeArray[i]);
            log.debug((Object)("  - Item " + i + " - Checking '" + (Object)((Object)settingTypeArray[i]) + "'"));
            if (settingTypeArray[i].equals((Object)SettingType.WILDCARD)) {
                log.debug((Object)"    - Type is a wildcard...");
                SettingType[] settingTypeArray2 = SettingType.getNonWildcards();
                return this.isAlwaysTrusted(settingTypeArray2);
            }
            if (secTrustSettingsResult == SecTrustSettingsResult.TRUST_ROOT || secTrustSettingsResult == SecTrustSettingsResult.TRUST_AS_ROOT) continue;
            log.debug((Object)("    - Type '" + (Object)((Object)settingTypeArray[i]) + "' is not trusted."));
            return false;
        }
        log.debug((Object)"Types specified are trusted.");
        return true;
    }

    public synchronized void parse(String string, Dict dict) {
        log.debug((Object)"  - Parsing certificate.");
        this.setThumbprint(string);
        this.setIssuerName(dict.getString(ISSUER_NAME, this.getIssuerName()));
        this.setModDate(dict.getDate(MOD_DATE, this.getModDate()));
        this.setSerialNumber(dict.getString(SERIAL_NUMBER, this.getSerialNumber()));
        this.cls_TrustLevels.clear();
        this.cls_AllowedErrors.clear();
        ValueArray valueArray = dict.getArray(TRUST_SETTINGS, null);
        if (valueArray == null) {
            this.cls_AllTrusted = true;
            for (int i = 0; i < SettingType.values().length; ++i) {
                this.cls_TrustLevels.put(SettingType.values()[i].Key, (Object)SecTrustSettingsResult.TRUST_ROOT);
            }
        } else {
            for (int i = 0; i < valueArray.getValueCount(); ++i) {
                long l;
                Object object;
                PairValue pairValue;
                PairValue pairValue2 = valueArray.getValue(i);
                if (pairValue2 == null || !(pairValue2 instanceof Dict) || ((Dict)pairValue2).getPairCount() <= 0) continue;
                log.debug((Object)("    - Looking at dict " + i));
                PairValue pairValue3 = ((Dict)pairValue2).getKeyValue(TRUST_SETTINGS_ALLOWED_ERROR);
                if (pairValue3 != null) {
                    log.debug((Object)"     - AllowedError Found.");
                    pairValue = ((Dict)pairValue2).getKeyValue(TRUST_SETTINGS_POLICY);
                    object = pairValue != null ? pairValue.getString() : "";
                    l = ((Dict)pairValue2).getInteger(TRUST_SETTINGS_ALLOWED_ERROR, 0L);
                    long l2 = ((Dict)pairValue2).getInteger(TRUST_SETTINGS_RESULT, -1L);
                    this.addAllowedError(l, l2, (String)object);
                    log.debug((Object)("     - Allowed error '" + l + "' is " + l2 + " for '" + (String)object + "'."));
                    if (((String)object).length() > 0 && !this.cls_TrustLevels.containsKey(object)) {
                        this.addTrustLevel((String)object, SecTrustSettingsResult.parse(l2));
                    }
                }
                if (pairValue3 != null) continue;
                pairValue = ((Dict)pairValue2).getKeyValue(TRUST_SETTINGS_POLICY);
                if (pairValue != null) {
                    log.debug((Object)"     - Policy Found.");
                    object = pairValue.getString();
                    l = ((Dict)pairValue2).getInteger(TRUST_SETTINGS_RESULT, 1L);
                    log.debug((Object)("        - Policy name '" + (String)object + "' is " + l));
                    this.addTrustLevel((String)object, SecTrustSettingsResult.parse(l));
                }
                if (pairValue != null || (object = ((Dict)pairValue2).getKeyValue(TRUST_SETTINGS_RESULT)) == null) continue;
                log.debug((Object)"     - TrustResult Found.");
                l = ((Dict)pairValue2).getInteger(TRUST_SETTINGS_RESULT, 1L);
                log.debug((Object)("        - Result is " + l));
                this.cls_TrustLevels.put(SettingType.WILDCARD.Key, (Object)SecTrustSettingsResult.parse(l));
            }
        }
    }

    public Dict generate() {
        Dict dict = new Dict();
        dict.addPair(ISSUER_NAME, new ValueData(this.getIssuerName()));
        dict.addPair(MOD_DATE, new ValueDate(this.getModDate()));
        dict.addPair(SERIAL_NUMBER, new ValueData(this.getSerialNumber()));
        if (!(this.cls_AllTrusted || this.cls_TrustLevels.size() <= 0 && this.cls_AllowedErrors.size() <= 0)) {
            int n;
            ValueArray valueArray = new ValueArray();
            dict.addPair(TRUST_SETTINGS, valueArray);
            for (n = 0; n < this.cls_TrustLevels.size(); ++n) {
                String string = (String)this.cls_TrustLevels.getKeyAt(n);
                SecTrustSettingsResult secTrustSettingsResult = (SecTrustSettingsResult)((Object)this.cls_TrustLevels.getValueAt(n));
                Dict dict2 = new Dict();
                valueArray.addValue(dict2);
                dict2.addPair(TRUST_SETTINGS_POLICY, new ValueData(string));
                dict2.addPair(TRUST_SETTINGS_RESULT, secTrustSettingsResult.IntValue);
            }
            for (n = 0; n < this.cls_AllowedErrors.size(); ++n) {
                long l = (Long)this.cls_AllowedErrors.getKeyAt(n);
                long l2 = (Long)this.cls_AllowedErrors.getValueAt(n);
                String string = l + "_" + l2;
                Vector<String> vector = this.cls_AllowedErrorsPolicy.get(string);
                for (int i = 0; i < vector.size(); ++i) {
                    Dict dict3 = new Dict();
                    valueArray.addValue(dict3);
                    dict3.addPair(TRUST_SETTINGS_ALLOWED_ERROR, l);
                    if (vector.get(i).length() > 0) {
                        dict3.addPair(TRUST_SETTINGS_POLICY, vector.get(i));
                    }
                    dict3.addPair(TRUST_SETTINGS_RESULT, l2);
                }
            }
        }
        return dict;
    }

    public String toString() {
        return "[LeopardTrustSetting thumbprint=" + this.getThumbprint() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SecTrustSettingsResult {
        TRUST_ROOT(1),
        TRUST_AS_ROOT(2),
        DENY(3),
        UNSPECIFIED(4);

        int IntValue;

        private SecTrustSettingsResult(int n2) {
            this.IntValue = n2;
        }

        public static SecTrustSettingsResult parse(long l) {
            for (int i = 0; i < SecTrustSettingsResult.values().length; ++i) {
                if (l != (long)SecTrustSettingsResult.values()[i].IntValue) continue;
                return SecTrustSettingsResult.values()[i];
            }
            return DENY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SettingType {
        WILDCARD("*", "*"),
        SSL("KoZIhvdjZAED", "ssl"),
        SMIME("KoZIhvdjZAEI", "smime"),
        EAP("KoZIhvdjZAEJ", "eap"),
        IPSEC("KoZIhvdjZAEL", "IPSec"),
        ICHAT("KoZIhvdjZAEM", "iChat"),
        KERBEROS_CLIENT("KoZIhvdjZAEO", "pkinitClient"),
        KERBEROS_SERVER("KoZIhvdjZAEP", "pkinitServer"),
        CODE_SIGNING("KoZIhvdjZAEQ", "codeSign"),
        X509("KoZIhvdjZAEC", "basic");

        public String Key;
        public String Name;

        private SettingType(String string2, String string3) {
            this.Key = string2;
            this.Name = string3;
        }

        public static SettingType[] getNonWildcards() {
            SettingType[] settingTypeArray = new SettingType[SettingType.values().length - 1];
            System.arraycopy(SettingType.values(), 1, settingTypeArray, 0, settingTypeArray.length);
            return settingTypeArray;
        }
    }
}

