/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.security;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.security.LeopardTrustSetting;
import com.cloudpath.common.os.mac.leopard.security.LeopardTrustSettingPlist;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class LeopardSecurity {
    private static final Logger log = Logger.getLogger(LeopardSecurity.class);
    private final FileHandler cls_FileHandler;
    private final CommandHandler cls_Command;
    private final Maccmd cls_Maccmd;

    public LeopardSecurity(FileHandler fileHandler, CommandHandler commandHandler, Maccmd maccmd) {
        this.cls_FileHandler = fileHandler;
        this.cls_Command = commandHandler;
        this.cls_Maccmd = maccmd;
    }

    public boolean isCaTrustedForDot1x(String string) {
        return this.isCertificateTrustedForDot1x(Maccmd.KeychainType.SYSTEM_ROOT, string);
    }

    public boolean isCaTrustedForBasic(String string) {
        return this.isCertificateTrustedForBasic(Maccmd.KeychainType.SYSTEM_ROOT, string);
    }

    public boolean isCaTrustedForSsl(String string) {
        return this.isCertificateTrustedForSsl(Maccmd.KeychainType.SYSTEM_ROOT, string);
    }

    public boolean isCaTrustedForIchat(String string) {
        return this.isCertificateTrustedForIchat(Maccmd.KeychainType.SYSTEM_ROOT, string);
    }

    public void setCaToTrustedFor8021X(File file) {
        this.setCertificateToTrustedFor8021X(Maccmd.KeychainType.SYSTEM_ROOT, file);
    }

    public void setCaToTrustedForIchat(File file) {
        this.setCertificateToTrustedForIchat(Maccmd.KeychainType.SYSTEM_ROOT, file);
    }

    public void setCaToTrustedForEverything(File file) {
        this.setCertificateToTrustedForEverything(Maccmd.KeychainType.SYSTEM_ROOT, file);
    }

    public void setCaToTrusted(File file, LeopardTrustSetting.SettingType settingType) {
        this.setCertificateToTrusted(Maccmd.KeychainType.SYSTEM_ROOT, settingType, file);
    }

    public void setCaToUntrusted(File file) {
        this.setCertificateToUntrusted(Maccmd.KeychainType.SYSTEM_ROOT, file);
    }

    public void setCertificateToTrustedFor8021X(Maccmd.KeychainType keychainType, File file) {
        this.setCertificateToTrusted(keychainType, LeopardTrustSetting.SettingType.EAP, file);
    }

    public void setCertificateToTrustedForIchat(Maccmd.KeychainType keychainType, File file) {
        this.setCertificateToTrusted(keychainType, LeopardTrustSetting.SettingType.ICHAT, file);
    }

    public void setCertificateToTrustedForEverything(Maccmd.KeychainType keychainType, File file) {
        this.setCertificateToTrusted(keychainType, null, file);
    }

    public void setCertificateToTrusted(Maccmd.KeychainType keychainType, LeopardTrustSetting.SettingType settingType, File file) {
        this.cls_Maccmd.addTrustedCertificate(keychainType, settingType, file);
    }

    public void setCertificateToUntrusted(Maccmd.KeychainType keychainType, File file) {
        this.cls_Maccmd.removeTrustedCertificate(keychainType, file);
    }

    public boolean isCertificateTrustedForDot1x(Maccmd.KeychainType keychainType, String string) {
        return this.isCertificateTrusted(keychainType, string, new LeopardTrustSetting.SettingType[]{LeopardTrustSetting.SettingType.EAP});
    }

    public boolean isCertificateTrustedForIchat(Maccmd.KeychainType keychainType, String string) {
        return this.isCertificateTrusted(keychainType, string, new LeopardTrustSetting.SettingType[]{LeopardTrustSetting.SettingType.ICHAT});
    }

    public boolean isCertificateTrustedForCodeSigning(Maccmd.KeychainType keychainType, String string) {
        return this.isCertificateTrusted(keychainType, string, new LeopardTrustSetting.SettingType[]{LeopardTrustSetting.SettingType.CODE_SIGNING});
    }

    public boolean isCertificateTrustedForX509(Maccmd.KeychainType keychainType, String string) {
        return this.isCertificateTrusted(keychainType, string, new LeopardTrustSetting.SettingType[]{LeopardTrustSetting.SettingType.X509});
    }

    public boolean isCertificateTrustedForBasic(Maccmd.KeychainType keychainType, String string) {
        return this.isCertificateTrusted(keychainType, string, new LeopardTrustSetting.SettingType[]{LeopardTrustSetting.SettingType.X509});
    }

    public boolean isCertificateTrustedForSsl(Maccmd.KeychainType keychainType, String string) {
        return this.isCertificateTrusted(keychainType, string, new LeopardTrustSetting.SettingType[]{LeopardTrustSetting.SettingType.SSL});
    }

    private boolean isCertificateTrusted(Maccmd.KeychainType keychainType, String string, LeopardTrustSetting.SettingType[] settingTypeArray) {
        File file;
        string = Util.formatCertificateThumbprint(string);
        try {
            file = File.createTempFile("XPC_CERT_", ".tmp");
        }
        catch (IOException iOException) {
            file = new File("XPC_CaTrust.tmp");
        }
        file.deleteOnExit();
        String[] stringArray = keychainType.IsLogin ? new String[]{"security", "trust-settings-export", file.getAbsolutePath()} : new String[]{"security", "trust-settings-export", "-d", file.getAbsolutePath()};
        try {
            CommandResponse commandResponse = this.cls_Command.executeCommand(stringArray);
            commandResponse.waitFor();
            if (Util.join(commandResponse.getError()).length() == 0) {
                Plist plist = PlistUtil.getCurrentPlist(this.cls_FileHandler, this.cls_Command, file, new Plist());
                LeopardTrustSettingPlist leopardTrustSettingPlist = new LeopardTrustSettingPlist();
                leopardTrustSettingPlist.parse(plist);
                file.delete();
                return leopardTrustSettingPlist.isCertificateTrusted(string, settingTypeArray);
            }
            file.delete();
            return false;
        }
        catch (Exception exception) {
            log.error((Object)"An error occurred while querying security-trust-settings-export.", (Throwable)exception);
            file.delete();
            return false;
        }
    }

    public String getAuthorizationRules(String string) {
        String[] stringArray = new String[]{"security", "authorizationdb", "read", string};
        try {
            CommandResponse commandResponse = this.cls_Command.executeCommand(stringArray);
            commandResponse.waitFor();
            return Util.join(commandResponse.getOutput());
        }
        catch (IOException iOException) {
            log.warn((Object)("An exception occurred while checking auth right " + string + "."), (Throwable)iOException);
            return "";
        }
    }

    public boolean isAuthorizationRightDefined(String string) {
        return this.getAuthorizationRules(string).length() > 0;
    }
}

