/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.systemconfig;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Pair;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.network.systemconfig.LeopardLocation;
import com.cloudpath.common.util.FileHandler;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LeopardPreferencePlist {
    private static final Logger log = Logger.getLogger(LeopardPreferencePlist.class);
    public static final String DIRECTORY = "/Library/Preferences/SystemConfiguration";
    public static final String FILE = "/Library/Preferences/SystemConfiguration/preferences.plist";
    private static final String CURRENT_SET = "CurrentSet";
    private static final String SETS = "Sets";
    private final FileHandler cls_FileHandler;
    private final CommandHandler cls_CommandHandler;
    private final Maccmd cls_Maccmd;
    private final File cls_File;
    private final Plist cls_TestPlist;
    private String cls_CurrentLocation = "";
    private Vector<LeopardLocation> cls_Locations = new Vector();

    public LeopardPreferencePlist(FileHandler fileHandler, CommandHandler commandHandler, Maccmd maccmd) {
        this.cls_FileHandler = fileHandler;
        this.cls_CommandHandler = commandHandler;
        this.cls_Maccmd = maccmd;
        this.cls_File = new File("/", FILE);
        this.cls_TestPlist = null;
    }

    public LeopardPreferencePlist(Plist plist) {
        this.cls_TestPlist = plist;
        this.cls_FileHandler = null;
        this.cls_Maccmd = null;
        this.cls_CommandHandler = null;
        this.cls_File = null;
    }

    public File getFile() {
        return this.cls_File;
    }

    public void refresh() {
        log.info((Object)"Will refresh preferences plist.");
        this.parse(this.getCurrentPlist());
    }

    public boolean write() throws IOException {
        boolean bl;
        log.info((Object)"Will write eap bindings plist.");
        Plist plist = this.generatePlist(false);
        String string = plist.getXml();
        if (this.cls_Maccmd == null) {
            this.cls_FileHandler.writeFile(this.cls_File, string);
            bl = true;
        } else {
            File file = File.createTempFile("xpc_", ".tmp");
            this.cls_FileHandler.writeFile(file, string);
            log.debug((Object)"Will copy preferences file to system.");
            bl = this.cls_Maccmd.copyFileAsAdmin(file, Maccmd.Destination.preferences);
            file.delete();
        }
        if (!bl) {
            log.warn((Object)"Failed to write the preferences file.");
        }
        return bl;
    }

    public Plist getCurrentPlist() {
        if (this.cls_TestPlist != null) {
            return this.cls_TestPlist;
        }
        return PlistUtil.getCurrentPlist(this.cls_FileHandler, this.cls_CommandHandler, this.cls_File, new Plist());
    }

    public void setCurrentLocationId(String string) {
        this.cls_CurrentLocation = string;
    }

    public String getCurrentLocationId() {
        return this.cls_CurrentLocation;
    }

    public int getLocationCount() {
        return this.cls_Locations.size();
    }

    public LeopardLocation getCurrentLocation() {
        LeopardLocation leopardLocation = this.getLocation(this.getCurrentLocationId());
        if (leopardLocation == null) {
            leopardLocation = new LeopardLocation();
            leopardLocation.setUniqueIdentifier(PlistUtil.generateGuid());
            this.cls_Locations.add(leopardLocation);
            this.setCurrentLocationId(leopardLocation.getUniqueIdentifier());
        }
        return leopardLocation;
    }

    public LeopardLocation getLocation(String string) {
        for (int i = 0; i < this.cls_Locations.size(); ++i) {
            if (!string.equals(this.cls_Locations.get(i).getUniqueIdentifier())) continue;
            return this.cls_Locations.get(i);
        }
        return null;
    }

    public synchronized void parse(Plist plist) {
        String string;
        log.debug((Object)"Will parse preferences plist.");
        Dict dict = plist.getDict();
        if (dict == null) {
            log.debug((Object)" - Creating new Dict.");
            dict = new Dict();
        }
        if ((string = dict.getString(CURRENT_SET, null)) == null) {
            log.debug((Object)"Current location does not exist.  Will create.");
            string = PlistUtil.generateGuid();
        } else {
            string = string.replace("/Sets/", "");
            log.debug((Object)("Found current location to be " + string));
        }
        this.setCurrentLocationId(string);
        Dict dict2 = dict.getDict(SETS, new Dict());
        log.debug((Object)"Will parse locations...");
        this.cls_Locations.clear();
        for (int i = 0; i < dict2.getPairCount(); ++i) {
            Pair pair = dict2.getPair(i);
            if (pair == null) continue;
            String string2 = pair.getKey();
            if (pair.getValue() == null || !(pair.getValue() instanceof Dict)) continue;
            log.debug((Object)(" - Will add location " + string2));
            LeopardLocation leopardLocation = new LeopardLocation();
            leopardLocation.parse(string2, (Dict)pair.getValue());
            this.cls_Locations.add(leopardLocation);
        }
    }

    public Plist generatePlist(boolean bl) {
        Dict dict;
        Dict dict2;
        log.debug((Object)"Will generate plist for LeopardPreferencePlist.");
        Plist plist = this.getCurrentPlist();
        Dict dict3 = plist.getDict();
        if (dict3 == null) {
            dict3 = new Dict();
            plist.setDict(dict3);
        }
        if ((dict2 = (dict = dict3.getDict(SETS, new Dict())).getDict(this.getCurrentLocationId(), null)) == null) {
            dict2 = new Dict();
            dict.addPair(this.getCurrentLocationId(), dict2);
        }
        this.getCurrentLocation().popuplate(dict2, bl);
        log.debug((Object)"Returning generated preferences plist.");
        return plist;
    }
}

