/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.systemconfig;

import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.leopard.network.systemconfig.LeopardLocationEapolLoginProfile;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LeopardLocationEapolLoginProfiles {
    private static final Logger log = Logger.getLogger(LeopardLocationEapolLoginProfiles.class);
    public static final String OLD_STYLE_PROFILE_GUID = "AD231044-DF43-4AA1-91F8-9ED61141BAD2";
    private Vector<String> cls_Keys = new Vector();
    private Vector<LeopardLocationEapolLoginProfile> cls_Profiles = new Vector();

    public int getCount() {
        return this.cls_Keys.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Vector<String> vector = this.cls_Keys;
        synchronized (vector) {
            this.cls_Keys.clear();
            this.cls_Profiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKey(String string, LeopardLocationEapolLoginProfile leopardLocationEapolLoginProfile) {
        Vector<String> vector = this.cls_Keys;
        synchronized (vector) {
            this.cls_Keys.add(string);
            this.cls_Profiles.add(leopardLocationEapolLoginProfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProfile(int n) {
        Vector<String> vector = this.cls_Keys;
        synchronized (vector) {
            this.cls_Keys.remove(n);
            this.cls_Profiles.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeopardLocationEapolLoginProfile getProfile(int n) {
        Vector<String> vector = this.cls_Keys;
        synchronized (vector) {
            return this.cls_Profiles.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeopardLocationEapolLoginProfile getProfileForKey(String string) {
        Vector<String> vector = this.cls_Keys;
        synchronized (vector) {
            int n = this.cls_Keys.indexOf(string);
            if (n >= 0) {
                return this.cls_Profiles.get(n);
            }
        }
        return null;
    }

    public void parse(Dict dict) {
        for (int i = 0; i < dict.getPairCount(); ++i) {
            String string = dict.getPair(i).getKey();
            PairValue pairValue = dict.getPair(i).getValue();
            log.debug((Object)("       - Parsing key " + string + "."));
            if (MacUtil.isUUID(string)) {
                log.debug((Object)"         - Key is post-10.5.4 style.");
                if (pairValue instanceof Dict) {
                    this.parseSingleProfile(string, (Dict)pairValue);
                    continue;
                }
                log.debug((Object)("       - Not a login profile (" + dict + ")"));
                continue;
            }
            log.debug((Object)"         - Key is pre-10.5.4 style.");
            this.parseSingleProfile(OLD_STYLE_PROFILE_GUID, dict);
            i = dict.getPairCount() + 1;
        }
    }

    private void parseSingleProfile(String string, Dict dict) {
        log.debug((Object)("         - Adding profile as key " + string));
        LeopardLocationEapolLoginProfile leopardLocationEapolLoginProfile = new LeopardLocationEapolLoginProfile();
        leopardLocationEapolLoginProfile.parse(dict);
        this.addKey(string, leopardLocationEapolLoginProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dict generate() {
        Dict dict = new Dict();
        Vector<String> vector = this.cls_Keys;
        synchronized (vector) {
            for (int i = 0; i < this.cls_Keys.size(); ++i) {
                dict.addPair(this.cls_Keys.get(i), this.cls_Profiles.get(i).generate());
            }
        }
        return dict;
    }
}

