/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.systemconfig;

import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Pair;
import com.cloudpath.common.os.mac.leopard.network.systemconfig.LeopardLocationInterface;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LeopardLocation {
    private static final Logger log = Logger.getLogger(LeopardLocation.class);
    private static final String NETWORK = "Network";
    private static final String INTERFACE = "Interface";
    private String cls_UniqueIdentifier = "";
    private Vector<LeopardLocationInterface> cls_Interfaces = new Vector();

    public void setUniqueIdentifier(String string) {
        this.cls_UniqueIdentifier = string;
    }

    public String getUniqueIdentifier() {
        return this.cls_UniqueIdentifier;
    }

    public int getInterfaceCount() {
        return this.cls_Interfaces.size();
    }

    public LeopardLocationInterface getInterface(int n) {
        return this.cls_Interfaces.get(n);
    }

    public LeopardLocationInterface getInterface(String string) {
        for (int i = 0; i < this.cls_Interfaces.size(); ++i) {
            if (!string.equals(this.cls_Interfaces.get(i).getInterfaceName())) continue;
            return this.cls_Interfaces.get(i);
        }
        LeopardLocationInterface leopardLocationInterface = new LeopardLocationInterface();
        leopardLocationInterface.setInterfaceName(string);
        this.cls_Interfaces.add(leopardLocationInterface);
        return leopardLocationInterface;
    }

    public void addInterface(LeopardLocationInterface leopardLocationInterface) {
        this.cls_Interfaces.add(leopardLocationInterface);
    }

    public synchronized void parse(String string, Dict dict) {
        log.debug((Object)(" - Will parse location " + string));
        this.setUniqueIdentifier(string);
        Dict dict2 = dict.getDict(NETWORK, new Dict());
        Dict dict3 = dict2.getDict(INTERFACE, new Dict());
        this.cls_Interfaces.clear();
        for (int i = 0; i < dict3.getPairCount(); ++i) {
            Pair pair = dict3.getPair(i);
            if (pair == null) continue;
            String string2 = pair.getKey();
            if (pair.getValue() == null || !(pair.getValue() instanceof Dict)) continue;
            log.debug((Object)("   - Adding interface " + string2));
            LeopardLocationInterface leopardLocationInterface = new LeopardLocationInterface();
            leopardLocationInterface.parse(string2, (Dict)pair.getValue());
            this.cls_Interfaces.add(leopardLocationInterface);
        }
    }

    public void popuplate(Dict dict, boolean bl) {
        log.debug((Object)"Will populate information for Location...");
        Dict dict2 = dict.getDict(NETWORK, new Dict());
        Dict dict3 = dict2.getDict(INTERFACE, new Dict());
        dict3.clear();
        for (int i = 0; i < this.cls_Interfaces.size(); ++i) {
            log.debug((Object)(" - Will add interface '" + this.cls_Interfaces.get(i).getInterfaceName() + "'."));
            dict3.addPair(this.cls_Interfaces.get(i).getInterfaceName(), this.cls_Interfaces.get(i).generate(bl), true);
        }
    }
}

