/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.eap;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfile;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LeopardEapProfilePlist {
    private static final Logger log = Logger.getLogger(LeopardEapProfilePlist.class);
    public static final String DIRECTORY = "/Library/Preferences";
    public static final String FILE = "/Library/Preferences/com.apple.eap.profiles.plist";
    public static final String PROFILES = "Profiles";
    private final FileHandler cls_FileHandler;
    private final CommandHandler cls_CommandHandler;
    private final File cls_File;
    private final Vector<LeopardEapProfile> cls_Profiles = new Vector();

    public LeopardEapProfilePlist(FileHandler fileHandler, CommandHandler commandHandler) {
        this.cls_FileHandler = fileHandler;
        this.cls_CommandHandler = commandHandler;
        this.cls_File = new File(FileUtil.getUserHome(), FILE);
    }

    public File getFile() {
        return this.cls_File;
    }

    public void refresh() {
        log.info((Object)"Will refresh current eap profile plist.");
        this.parse(this.getCurrentPlist());
    }

    public void write() throws IOException {
        log.info((Object)"Will write eap profile plist.");
        Plist plist = this.generatePlist();
        log.debug((Object)("Will write file " + this.cls_File + " to handler."));
        this.cls_FileHandler.writeFile(this.cls_File, plist.getXml());
    }

    public int getProfileCount() {
        return this.cls_Profiles.size();
    }

    public LeopardEapProfile getProfile(int n) {
        return this.cls_Profiles.get(n);
    }

    public LeopardEapProfile getProfileByName(String string) {
        log.debug((Object)("Looking for EAP profile '" + string + "'."));
        for (int i = 0; i < this.cls_Profiles.size(); ++i) {
            log.debug((Object)("  - Looking at '" + this.cls_Profiles.get(i).getUserDefinedName() + "'."));
            if (!string.equals(this.cls_Profiles.get(i).getUserDefinedName())) continue;
            return this.cls_Profiles.get(i);
        }
        return null;
    }

    public LeopardEapProfile getProfileByUniqueIdentifier(String string) {
        for (int i = 0; i < this.cls_Profiles.size(); ++i) {
            if (!string.equals(this.cls_Profiles.get(i).getUniqueIdentifier())) continue;
            return this.cls_Profiles.get(i);
        }
        return null;
    }

    public void removeProfile(String string) {
        for (int i = 0; i < this.cls_Profiles.size(); ++i) {
            if (!string.equals(this.cls_Profiles.get(i).getUserDefinedName())) continue;
            this.cls_Profiles.remove(i);
        }
    }

    public void setProfile(LeopardEapProfile leopardEapProfile) {
        log.debug((Object)("Setting eap profile: " + leopardEapProfile));
        this.removeProfile(leopardEapProfile.getUserDefinedName());
        this.cls_Profiles.insertElementAt(leopardEapProfile, 0);
    }

    public Plist getCurrentPlist() {
        return PlistUtil.getCurrentPlist(this.cls_FileHandler, this.cls_CommandHandler, this.cls_File, new Plist());
    }

    protected synchronized void parse(Plist plist) {
        log.debug((Object)("Will clear " + this.cls_Profiles.size() + " old profiles."));
        this.cls_Profiles.clear();
        if (plist.getDict() == null) {
            plist.setDict(new Dict());
        }
        ValueArray valueArray = plist.getDict().getArray(PROFILES, new ValueArray());
        for (int i = 0; i < valueArray.getValueCount(); ++i) {
            PairValue pairValue = valueArray.getValue(i);
            if (!(pairValue instanceof Dict)) continue;
            LeopardEapProfile leopardEapProfile = new LeopardEapProfile();
            leopardEapProfile.parse((Dict)pairValue);
            log.debug((Object)("  - Adding profile " + leopardEapProfile.getUserDefinedName()));
            this.cls_Profiles.add(leopardEapProfile);
        }
        log.debug((Object)("Loaded " + this.cls_Profiles.size() + " eap profiles during refresh."));
    }

    protected Plist generatePlist() {
        Dict dict = new Dict();
        ValueArray valueArray = new ValueArray();
        dict.addPair(PROFILES, valueArray);
        for (int i = 0; i < this.cls_Profiles.size(); ++i) {
            Dict dict2 = this.cls_Profiles.get(i).generate(false, false);
            valueArray.addValue(dict2);
        }
        Plist plist = new Plist();
        plist.setDict(dict);
        return plist;
    }
}

