/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.eap;

import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueBoolean;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueString;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEap;
import com.cloudpath.common.util.Util;

public class LeopardEapProfile
implements Cloneable {
    public static final String CONNECT_BY_DEFAULT = "ConnectByDefault";
    public static final String EAP_CLIENT_CONFIG = "EAPClientConfiguration";
    public static final String UNIQUE_IDENTIFIER = "UniqueIdentifier";
    public static final String USER_DEFINED_NAME = "UserDefinedName";
    public static final String WIRELESS_NETWORK = "Wireless Network";
    public static final String WIRELESS_SECURITY = "Wireless Security";
    public static final String INACTIVE = "__INACTIVE__";
    public static final String SYSTEM_PROFILE = "[SYSTEM]";
    public static final String LOGIN_PROFILE = "LOGIN:";
    private String cls_DesiredPassword = "";
    private String cls_UniqueIdentifier = "";
    private boolean cls_ConnectByDefault = false;
    private String cls_UserDefinedName = "";
    private LeopardEap cls_EapConfig = new LeopardEap();
    private String cls_WirelessNetwork = "";
    private String cls_WirelessSecurity = "";
    private boolean cls_Inactive = false;

    public void setInactive(boolean bl) {
        this.cls_Inactive = bl;
    }

    public boolean getInactive() {
        return this.cls_Inactive;
    }

    public void setDesiredPassword(String string) {
        this.cls_DesiredPassword = string;
    }

    public String getDesiredPassword() {
        return this.cls_DesiredPassword;
    }

    public String getUniqueIdentifier() {
        return this.cls_UniqueIdentifier;
    }

    public void setUniqueIdentifier(String string) {
        this.cls_UniqueIdentifier = string;
    }

    public void setConnectByDefault(boolean bl) {
        this.cls_ConnectByDefault = bl;
    }

    public boolean getConnectByDefault() {
        return this.cls_ConnectByDefault;
    }

    public void setUserDefinedName(String string) {
        this.cls_UserDefinedName = Util.getNonNull(string);
    }

    public String getUserDefinedName() {
        return this.cls_UserDefinedName;
    }

    public LeopardEap getEapConfig() {
        return this.cls_EapConfig;
    }

    public void setEapConfig(LeopardEap leopardEap) {
        this.cls_EapConfig = leopardEap;
    }

    public void setWirelessNetwork(String string) {
        this.cls_WirelessNetwork = string;
    }

    public String getWirelessNetwork() {
        return this.cls_WirelessNetwork;
    }

    public void setWirelessSecurity(String string) {
        this.cls_WirelessSecurity = string;
    }

    public String getWirelessSecurity() {
        return this.cls_WirelessSecurity;
    }

    public void parse(Dict dict) {
        this.setConnectByDefault(PlistUtil.getBooleanValue(dict, CONNECT_BY_DEFAULT, this.getConnectByDefault()));
        this.setUniqueIdentifier(PlistUtil.getStringValue(dict, UNIQUE_IDENTIFIER, this.getUniqueIdentifier()));
        this.setUserDefinedName(PlistUtil.getStringValue(dict, USER_DEFINED_NAME, this.getUserDefinedName()));
        this.setWirelessNetwork(PlistUtil.getStringValue(dict, WIRELESS_NETWORK, this.getWirelessNetwork()));
        this.setWirelessSecurity(PlistUtil.getStringValue(dict, WIRELESS_SECURITY, this.getWirelessSecurity()));
        this.setInactive(dict.getBoolean(INACTIVE, this.getInactive()));
        Dict dict2 = dict.getDict(EAP_CLIENT_CONFIG, dict);
        this.cls_EapConfig = new LeopardEap();
        this.cls_EapConfig.parse(dict2);
    }

    public Dict generate(boolean bl, boolean bl2) {
        Dict dict = new Dict();
        if (this.getConnectByDefault()) {
            dict.addPair(CONNECT_BY_DEFAULT, new ValueBoolean(this.getConnectByDefault()));
        }
        Dict dict2 = this.cls_EapConfig.generate(false, "", bl, bl2);
        dict.addPair(EAP_CLIENT_CONFIG, dict2);
        dict.addPair(UNIQUE_IDENTIFIER, new ValueString(this.getUniqueIdentifier()));
        String string = this.getUserDefinedName();
        if (bl && string != null && string.startsWith(LOGIN_PROFILE)) {
            string = string.substring(LOGIN_PROFILE.length());
        }
        dict.addPair(USER_DEFINED_NAME, new ValueString(string));
        if (this.getWirelessNetwork() != null && this.getWirelessNetwork().length() > 0) {
            dict.addPair(WIRELESS_NETWORK, new ValueString(this.getWirelessNetwork()));
        }
        if (this.getWirelessSecurity() != null && this.getWirelessSecurity().length() > 0) {
            dict.addPair(WIRELESS_SECURITY, new ValueString(this.getWirelessSecurity()));
        }
        if (this.getInactive()) {
            dict.addPair(INACTIVE, this.getInactive());
        }
        return dict;
    }

    public Object clone() {
        try {
            LeopardEapProfile leopardEapProfile = (LeopardEapProfile)super.clone();
            leopardEapProfile.cls_EapConfig = (LeopardEap)this.cls_EapConfig.clone();
            return leopardEapProfile;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return "[LeopardEapProfile name=" + this.getUserDefinedName() + "]";
    }

    public String getSummary() {
        String string = "Leapard Eap Profile:\nName: " + this.cls_UserDefinedName + "\n" + "Eap Config: " + this.cls_EapConfig.getSummary();
        return string;
    }

    public static boolean isLoginProfile(String string) {
        return string != null && string.startsWith(LOGIN_PROFILE);
    }

    public boolean isLoginProfile() {
        return LeopardEapProfile.isLoginProfile(this.getUserDefinedName());
    }

    public static boolean isSystemProfile(String string) {
        return string != null && string.startsWith(SYSTEM_PROFILE);
    }

    public boolean isSystemProfile() {
        return LeopardEapProfile.isSystemProfile(this.getUserDefinedName());
    }
}

