/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.eap;

import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueBoolean;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueData;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueInteger;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueString;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfile;
import com.cloudpath.common.os.mac.tiger.network.networkconnect.NetworkConnectPlist;
import com.cloudpath.common.util.InvalidValueException;
import com.cloudpath.common.util.Util;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LeopardEap
implements Cloneable {
    private static final Logger log = Logger.getLogger(LeopardEapProfile.class);
    public static final String EAPTYPE_MD5 = "MD5";
    public static final String EAPTYPE_TLS = "TLS";
    public static final String EAPTYPE_LEAP = "LEAP";
    public static final String EAPTYPE_TTLS = "TTLS";
    public static final String EAPTYPE_PEAP = "PEAP";
    public static final String EAPTYPE_EAP_FAST = "EAP-FAST";
    public static final long EAPTYPE_MD5_ID = 4L;
    public static final long EAPTYPE_TLS_ID = 13L;
    public static final long EAPTYPE_LEAP_ID = 17L;
    public static final long EAPTYPE_TTLS_ID = 21L;
    public static final long EAPTYPE_PEAP_ID = 25L;
    public static final long EAPTYPE_EAP_FAST_ID = 43L;
    public static final String ACCEPT_EAP_TYPES = "AcceptEAPTypes";
    public static final String ONE_TIME_USER_PASSWORD = "OneTimeUserPassword";
    public static final String USER_NAME = "UserName";
    public static final String USER_PASSWORD_KEYCHAIN_ITEM_ID = "UserPasswordKeychainItemID";
    public static final String DESCRIPTION = "Description";
    public static final String EAPFAST_PROVISION_PAC = "EAPFASTProvisionPAC";
    public static final String EAPFAST_PROVISION_PAC_ANON = "EAPFASTProvisionPACAnonymously";
    public static final String EAPFAST_USE_PAC = "EAPFASTUsePAC";
    public static final String OUTER_IDENTITY = "OuterIdentity";
    public static final String TLS_VERIFY_SERVER_CERTIFICATE = "TLSVerifyServerCertificate";
    public static final String TTLS_INNER_AUTHENTICATION = "TTLSInnerAuthentication";
    public static final String INACTIVE = "__INACTIVE__";
    public static final String TLS_IDENTITY_HANDLE = "TLSIdentityHandle";
    public static final String TLS_IDENTITY_HANDLE_DATA = "IdentityHandleData";
    public static final String TLS_IDENTITY_HANDLE_TYPE = "IdentityHandleType";
    public static final String IDENTITY_HANDLE_TYPE_CERT = "CertificateData";
    public static final String TLS_TRUSTED_CERTIFICATES = "TLSTrustedCertificates";
    public static final String TLS_TRUSTED_SERVER_NAMES = "TLSTrustedServerNames";
    public static final String WIRELESS_NETWORK = "Wireless Network";
    public static final String WIRELESS_SECURITY = "Wireless Security";
    private String cls_DesiredPassword = "";
    private long[] cls_EapTypes = new long[]{25L, 21L, 43L};
    private boolean cls_OneTimeUserPassword = false;
    private String cls_UserName = "";
    private String cls_UserPasswordKeychainItemID = "";
    private String cls_Description = "Automatic";
    private NetworkConnectPlist.EapFastPacFlag cls_EapFastPacFlag = NetworkConnectPlist.EapFastPacFlag.USE_AUTO_PAC;
    private String cls_OuterIdentity = "";
    private boolean cls_TlsVerifyServerCertificate = true;
    private NetworkConnectPlist.TtlsInnerAuthentication cls_TtlsInnerAuthentication = NetworkConnectPlist.TtlsInnerAuthentication.NONE;
    private boolean cls_Inactive = false;
    private String cls_IdentityHandleType = "";
    private String cls_IdentityHandleData = "";
    private Vector<String> cls_TlsTrustedCertificates = new Vector();
    private Vector<String> cls_TlsTrustedServerNames = new Vector();
    private String cls_WirelessNetwork = "";
    private String cls_WirelessSecurity = "";

    public void setOneTimeUserPassword(boolean bl) {
        this.cls_OneTimeUserPassword = bl;
    }

    public boolean getOneTimeUserPassword() {
        return this.cls_OneTimeUserPassword;
    }

    public void setInactive(boolean bl) {
        this.cls_Inactive = bl;
    }

    public boolean getInactive() {
        return this.cls_Inactive;
    }

    public String getUserName() {
        return this.cls_UserName;
    }

    public void setUserName(String string) {
        this.cls_UserName = Util.getNonNull(string);
    }

    public void setEapTypes(long[] lArray) {
        this.cls_EapTypes = lArray == null ? new long[]{} : lArray;
    }

    public long[] getEapTypes() {
        return this.cls_EapTypes;
    }

    public String getUserPasswordKeychainItemId() {
        return this.cls_UserPasswordKeychainItemID;
    }

    public void setUserPasswordKeychainItemId(String string) {
        this.cls_UserPasswordKeychainItemID = string;
    }

    public String getDescription() {
        return this.cls_Description;
    }

    public void setDescription(String string) {
        this.cls_Description = string;
    }

    public void setTtlsInnerAuthentication(NetworkConnectPlist.TtlsInnerAuthentication ttlsInnerAuthentication) {
        this.cls_TtlsInnerAuthentication = ttlsInnerAuthentication == null ? NetworkConnectPlist.TtlsInnerAuthentication.NONE : ttlsInnerAuthentication;
    }

    public NetworkConnectPlist.TtlsInnerAuthentication getTtlsInnerAuthentication() {
        return this.cls_TtlsInnerAuthentication;
    }

    public void setOuterIdentity(String string) {
        this.cls_OuterIdentity = Util.getNonNull(string);
    }

    public String getOuterIdentity() {
        return this.cls_OuterIdentity;
    }

    public void setEapFastPacFlag(NetworkConnectPlist.EapFastPacFlag eapFastPacFlag) {
        this.cls_EapFastPacFlag = eapFastPacFlag == null ? NetworkConnectPlist.EapFastPacFlag.NO_PAC : eapFastPacFlag;
    }

    public NetworkConnectPlist.EapFastPacFlag getEapFastPacFlag() {
        return this.cls_EapFastPacFlag;
    }

    public void setTlsVerifyServerCertificate(boolean bl) {
        this.cls_TlsVerifyServerCertificate = bl;
    }

    public boolean getTlsVerifyServerCertificate() {
        return this.cls_TlsVerifyServerCertificate;
    }

    public void setIdentityHandleData(String string) {
        this.cls_IdentityHandleData = string;
    }

    public String getIdentityHandleData() {
        return this.cls_IdentityHandleData;
    }

    public void setIdentityHandleType(String string) {
        this.cls_IdentityHandleType = string;
    }

    public String getIdentityHandleType() {
        return this.cls_IdentityHandleType;
    }

    public int getTlsTrustedCertificateCount() {
        return this.cls_TlsTrustedCertificates.size();
    }

    public String getTlsTrustedCertificate(int n) {
        return n < this.cls_TlsTrustedCertificates.size() ? this.cls_TlsTrustedCertificates.get(n) : null;
    }

    public void addTlsTrustedCertificate(String string) {
        if (!this.hasTlsTrustedCertificate(string)) {
            this.cls_TlsTrustedCertificates.add(string);
        }
    }

    public boolean hasTlsTrustedCertificate(String string) {
        return this.cls_TlsTrustedCertificates.contains(string);
    }

    public void removeAllTlsTrustedCertificates() {
        this.cls_TlsTrustedCertificates.clear();
    }

    public int getTlsTrustedServerNameCount() {
        return this.cls_TlsTrustedServerNames.size();
    }

    public String getTlsTrustedServerName(int n) {
        return n < this.cls_TlsTrustedServerNames.size() ? this.cls_TlsTrustedServerNames.get(n) : null;
    }

    public void setWirelessNetwork_SPECIAL(String string) {
        this.cls_WirelessNetwork = string;
    }

    public String getWirelessNetwork_SPECIAL() {
        return this.cls_WirelessNetwork;
    }

    public void setWirelessSecurity_SPECIAL(String string) {
        this.cls_WirelessSecurity = string;
    }

    public String getWirelessSecurity_SPECIAL() {
        return this.cls_WirelessSecurity;
    }

    public void setDesiredPassword_SPECIAL(String string) {
        this.cls_DesiredPassword = string;
    }

    public String getDesiredPassword_SPECIAL() {
        return this.cls_DesiredPassword;
    }

    public void addTlsTrustedServerName(String string) {
        if (string != null && string.length() > 0) {
            this.cls_TlsTrustedServerNames.add(string);
        }
    }

    public void setTlsTrustedServerNames(String[] stringArray) {
        this.cls_TlsTrustedServerNames.clear();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addTlsTrustedServerName(stringArray[i]);
            }
        }
    }

    public void setTlsTrustedServerNamesList(String string) {
        this.cls_TlsTrustedServerNames.clear();
        if (string != null) {
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                this.addTlsTrustedServerName(stringArray[i]);
            }
        }
    }

    public String getTlsTrustedServerNamesList() {
        return Util.join(this.getTlsTrustedServerNames(), ";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTlsTrustedServerNames() {
        if (this.cls_TlsTrustedServerNames.size() > 0) {
            String[] stringArray;
            Vector<String> vector = this.cls_TlsTrustedServerNames;
            synchronized (vector) {
                stringArray = new String[this.cls_TlsTrustedServerNames.size()];
                this.cls_TlsTrustedServerNames.toArray(stringArray);
            }
            return stringArray;
        }
        return new String[0];
    }

    public void populateFrom(LeopardEap leopardEap) {
        int n;
        this.setInactive(leopardEap.getInactive());
        this.setUserName(leopardEap.getUserName());
        this.setEapTypes(leopardEap.getEapTypes());
        this.setUserPasswordKeychainItemId(leopardEap.getUserPasswordKeychainItemId());
        this.setDescription(leopardEap.getDescription());
        this.setTtlsInnerAuthentication(leopardEap.getTtlsInnerAuthentication());
        this.setOuterIdentity(leopardEap.getOuterIdentity());
        this.setEapFastPacFlag(leopardEap.getEapFastPacFlag());
        this.setTlsVerifyServerCertificate(leopardEap.getTlsVerifyServerCertificate());
        this.setIdentityHandleData(leopardEap.getIdentityHandleData());
        this.setIdentityHandleType(leopardEap.getIdentityHandleType());
        this.setOneTimeUserPassword(leopardEap.getOneTimeUserPassword());
        this.setWirelessNetwork_SPECIAL(leopardEap.getWirelessNetwork_SPECIAL());
        this.setWirelessSecurity_SPECIAL(leopardEap.getWirelessSecurity_SPECIAL());
        for (n = 0; n < leopardEap.getTlsTrustedCertificateCount(); ++n) {
            this.addTlsTrustedCertificate(leopardEap.getTlsTrustedCertificate(n));
        }
        for (n = 0; n < leopardEap.getTlsTrustedServerNameCount(); ++n) {
            this.addTlsTrustedServerName(leopardEap.getTlsTrustedServerName(n));
        }
    }

    public String getEapTypesString() {
        String string = "";
        long[] lArray = this.getEapTypes();
        for (int i = 0; i < lArray.length; ++i) {
            if (string.length() > 0) {
                string = string + ";";
            }
            string = string + LeopardEap.convertEapType(lArray[i]);
        }
        return string;
    }

    public boolean includesEapType(String string) {
        log.debug((Object)("Will check if eap type " + string + " is included."));
        long l = LeopardEap.convertEapType(string);
        for (int i = 0; i < this.cls_EapTypes.length; ++i) {
            if (this.cls_EapTypes[i] != l) continue;
            return true;
        }
        return false;
    }

    public void setEapTypes(String string) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            this.setEapTypes(new long[0]);
        } else {
            String[] stringArray = string.split(";");
            long[] lArray = new long[stringArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = LeopardEap.convertEapType(stringArray[i]);
            }
            this.setEapTypes(lArray);
        }
    }

    private static final long convertEapType(String string) {
        if (string == null) {
            string = "";
        }
        if (EAPTYPE_TTLS.equals(string = string.toUpperCase())) {
            return 21L;
        }
        if (EAPTYPE_PEAP.equals(string)) {
            return 25L;
        }
        if (EAPTYPE_MD5.equals(string)) {
            return 4L;
        }
        if (EAPTYPE_TLS.equals(string)) {
            return 13L;
        }
        if (EAPTYPE_EAP_FAST.equals(string)) {
            return 43L;
        }
        if (EAPTYPE_LEAP.equals(string)) {
            return 17L;
        }
        return 0L;
    }

    private static final String convertEapType(long l) {
        if (l == 21L) {
            return EAPTYPE_TTLS;
        }
        if (l == 25L) {
            return EAPTYPE_PEAP;
        }
        if (l == 4L) {
            return EAPTYPE_MD5;
        }
        if (l == 13L) {
            return EAPTYPE_TLS;
        }
        if (l == 43L) {
            return EAPTYPE_EAP_FAST;
        }
        if (l == 17L) {
            return EAPTYPE_LEAP;
        }
        return "";
    }

    public void parse(Dict dict) {
        String string;
        int n;
        PairValue pairValue;
        this.setUserName(dict.getString(USER_NAME, this.getUserName()));
        this.setUserPasswordKeychainItemId(dict.getString(USER_PASSWORD_KEYCHAIN_ITEM_ID, this.getUserPasswordKeychainItemId()));
        this.setEapTypes(PlistUtil.getIntArrayValue(dict, ACCEPT_EAP_TYPES));
        this.setDescription(dict.getString(DESCRIPTION, this.getDescription()));
        this.setOuterIdentity(dict.getString(OUTER_IDENTITY, this.getOuterIdentity()));
        this.setTlsVerifyServerCertificate(dict.getBoolean(TLS_VERIFY_SERVER_CERTIFICATE, this.getTlsVerifyServerCertificate()));
        String string2 = dict.getString(TTLS_INNER_AUTHENTICATION, "");
        this.setTtlsInnerAuthentication(NetworkConnectPlist.TtlsInnerAuthentication.getByOsName(string2));
        this.setEapFastPacFlag(NetworkConnectPlist.EapFastPacFlag.getInstance(dict.getBoolean(EAPFAST_USE_PAC, this.getEapFastPacFlag().getUsePac()), dict.getBoolean(EAPFAST_PROVISION_PAC, this.getEapFastPacFlag().getAutoPac()), dict.getBoolean(EAPFAST_PROVISION_PAC_ANON, this.getEapFastPacFlag().getAnonPac())));
        String string3 = dict.getData(TLS_IDENTITY_HANDLE, null);
        if (string3 == null) {
            pairValue = dict.getDict(TLS_IDENTITY_HANDLE, null);
            if (pairValue != null) {
                this.setIdentityHandleData(((Dict)pairValue).getString(TLS_IDENTITY_HANDLE_DATA, ""));
                this.setIdentityHandleType(((Dict)pairValue).getString(TLS_IDENTITY_HANDLE_TYPE, ""));
            }
        } else {
            this.setIdentityHandleType("");
            this.setIdentityHandleData(string3);
        }
        this.cls_TlsTrustedCertificates.clear();
        pairValue = dict.getArray(TLS_TRUSTED_CERTIFICATES, new ValueArray());
        for (n = 0; n < ((ValueArray)pairValue).getValueCount(); ++n) {
            string = ((ValueArray)pairValue).getValue(n).getString();
            this.cls_TlsTrustedCertificates.add(string);
        }
        this.cls_TlsTrustedServerNames.clear();
        pairValue = dict.getArray(TLS_TRUSTED_SERVER_NAMES, new ValueArray());
        for (n = 0; n < ((ValueArray)pairValue).getValueCount(); ++n) {
            string = ((ValueArray)pairValue).getValue(n).getString();
            this.cls_TlsTrustedServerNames.add(string);
        }
        this.setInactive(dict.getBoolean(INACTIVE, this.getInactive()));
        this.setOneTimeUserPassword(dict.getBoolean(ONE_TIME_USER_PASSWORD, this.getOneTimeUserPassword()));
        this.setWirelessNetwork_SPECIAL(dict.getString(WIRELESS_NETWORK, this.getWirelessNetwork_SPECIAL()));
        this.setWirelessSecurity_SPECIAL(dict.getString(WIRELESS_SECURITY, this.getWirelessSecurity_SPECIAL()));
    }

    public Dict generate() {
        return this.generate(false, "", false, false);
    }

    public Dict generateForPreferences(boolean bl, boolean bl2) {
        return this.generate(false, "", bl, bl2);
    }

    public Dict generate(boolean bl, String string, boolean bl2, boolean bl3) {
        Object object;
        String string2;
        boolean bl4 = bl2 || bl3;
        Dict dict = new Dict();
        ValueArray valueArray = new ValueArray();
        long[] lArray = this.getEapTypes();
        for (int i = 0; i < lArray.length; ++i) {
            valueArray.addValue(new ValueInteger(lArray[i]));
        }
        dict.addPair(ACCEPT_EAP_TYPES, valueArray);
        if (this.getDescription().length() > 0 && !bl4) {
            dict.addPair(DESCRIPTION, new ValueString(this.getDescription()));
        }
        if (this.getOneTimeUserPassword()) {
            dict.addPair(ONE_TIME_USER_PASSWORD, new ValueBoolean(this.getOneTimeUserPassword()));
        }
        if (!bl4 || !NetworkConnectPlist.EapFastPacFlag.USE_AUTO_PAC.equals((Object)this.getEapFastPacFlag())) {
            dict.addPair(EAPFAST_PROVISION_PAC, this.getEapFastPacFlag().getAutoPac());
            dict.addPair(EAPFAST_PROVISION_PAC_ANON, this.getEapFastPacFlag().getAnonPac());
            dict.addPair(EAPFAST_USE_PAC, this.getEapFastPacFlag().getUsePac());
        }
        if (!bl4 || this.getOuterIdentity().length() > 0) {
            dict.addPair(OUTER_IDENTITY, this.getOuterIdentity());
        }
        if ((string2 = this.getIdentityHandleData()) != null && string2.length() > 0) {
            object = this.getIdentityHandleType();
            if (object != null && ((String)object).length() > 0) {
                Dict dict2 = new Dict();
                dict2.addPair(TLS_IDENTITY_HANDLE_DATA, new ValueData(string2));
                dict2.addPair(TLS_IDENTITY_HANDLE_TYPE, (String)object);
                dict.addPair(TLS_IDENTITY_HANDLE, dict2);
            } else {
                dict.addPair(TLS_IDENTITY_HANDLE, new ValueData(string2));
            }
        }
        if (!bl4 || !this.getTlsVerifyServerCertificate()) {
            dict.addPair(TLS_VERIFY_SERVER_CERTIFICATE, this.getTlsVerifyServerCertificate());
        }
        if (!NetworkConnectPlist.TtlsInnerAuthentication.NONE.equals((Object)this.getTtlsInnerAuthentication())) {
            dict.addPair(TTLS_INNER_AUTHENTICATION, this.getTtlsInnerAuthentication().OsName);
        }
        if (this.cls_TlsTrustedCertificates.size() > 0) {
            object = new ValueArray();
            for (int i = 0; i < this.cls_TlsTrustedCertificates.size(); ++i) {
                ((ValueArray)object).addValue(new ValueData(this.cls_TlsTrustedCertificates.get(i)));
            }
            dict.addPair(TLS_TRUSTED_CERTIFICATES, (PairValue)object);
        }
        if (this.cls_TlsTrustedServerNames.size() > 0) {
            object = new ValueArray();
            for (int i = 0; i < this.cls_TlsTrustedServerNames.size(); ++i) {
                ((ValueArray)object).addValue(new ValueString(this.cls_TlsTrustedServerNames.get(i)));
            }
            dict.addPair(TLS_TRUSTED_SERVER_NAMES, (PairValue)object);
        }
        if (!bl4 || this.getUserName().length() > 0) {
            dict.addPair(USER_NAME, this.getUserName());
        }
        if (bl) {
            dict.addPair("UserPassword", string);
        } else if (this.isTlsOnly()) {
            log.debug((Object)" -- Not including password id due to TLS.");
        } else if (bl2) {
            log.debug((Object)(" -- Not including password id due to login profile. (" + this.getUserPasswordKeychainItemId() + ")"));
        } else if (this.getOneTimeUserPassword() && string != null && string.length() > 0) {
            dict.addPair("UserPassword", string);
        } else if (this.getUserPasswordKeychainItemId().length() > 0) {
            log.debug((Object)(" -- Including non-blank password id (" + this.getUserPasswordKeychainItemId() + ")."));
            dict.addPair(USER_PASSWORD_KEYCHAIN_ITEM_ID, this.getUserPasswordKeychainItemId());
        } else {
            log.debug((Object)" -- Not including password id.");
        }
        if (bl3 && this.getWirelessNetwork_SPECIAL().length() > 0) {
            dict.addPair(WIRELESS_NETWORK, this.getWirelessNetwork_SPECIAL());
        }
        if (bl3 && this.getWirelessSecurity_SPECIAL().length() > 0) {
            dict.addPair(WIRELESS_SECURITY, this.getWirelessSecurity_SPECIAL());
        }
        if (this.getInactive()) {
            dict.addPair(INACTIVE, this.getInactive());
        }
        return dict;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getSummary() {
        String string = "Leopard EAP:\n  Description   : " + this.cls_Description + "\n" + "  Eap Types     : " + Util.join(this.cls_EapTypes) + "\n" + "  User Name     : " + this.cls_UserName + "\n" + "  Outer Identity: " + this.cls_OuterIdentity;
        return string;
    }

    public boolean isTlsOnly() {
        long[] lArray = this.getEapTypes();
        if (lArray.length == 1) {
            return lArray[0] == 13L;
        }
        return false;
    }

    public boolean isTls() {
        long[] lArray = this.getEapTypes();
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] != 13L) continue;
            return true;
        }
        return false;
    }
}

