/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.eap;

import com.cloudpath.common.os.mac.common.network.airport.AuthenticationListener;
import com.cloudpath.common.os.mac.leopard.eapol.LeopardEapState;
import com.cloudpath.common.os.mac.leopard.eapol.MacEapCmd;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEap;
import com.cloudpath.common.util.Util;
import org.apache.log4j.Logger;

public class LeopardAuthenticationMonitor
implements Runnable {
    private static final Logger log = Logger.getLogger(LeopardAuthenticationMonitor.class);
    private boolean cls_Continue = true;
    private final String cls_InterfaceName;
    private final Thread cls_Thread;
    private final int cls_BackoffRate;
    private int cls_PollingInterval;
    private final long cls_Timeout;
    private final AuthenticationListener cls_AuthenticationListener;
    private final MacEapCmd cls_MacEapCmd;
    private final LeopardEap cls_EapConfig;
    private final String cls_UserPassword;
    private final boolean cls_RestartIfNecessary;
    private final int cls_RetryCount;
    private int cls_DelayedCount = 0;

    public LeopardAuthenticationMonitor(String string, String string2, int n, int n2, long l, AuthenticationListener authenticationListener, LeopardEap leopardEap, String string3, MacEapCmd macEapCmd, boolean bl, int n3) {
        log.info((Object)"\n\n\n***** STARTING AUTH MONITOR ***********\n\n\n");
        this.cls_InterfaceName = string2;
        this.cls_PollingInterval = n;
        this.cls_BackoffRate = n2;
        log.info((Object)("Authentication timeout is " + l));
        this.cls_Timeout = l > 0L ? System.currentTimeMillis() + l : 35000L;
        this.cls_AuthenticationListener = authenticationListener;
        this.cls_MacEapCmd = macEapCmd;
        this.cls_EapConfig = leopardEap;
        this.cls_UserPassword = string3;
        this.cls_RestartIfNecessary = bl;
        this.cls_RetryCount = n3;
        this.cls_Thread = Util.runThread(this.getClass().getSimpleName() + "-" + string, this);
    }

    public void stop(boolean bl) {
        this.cls_Continue = false;
        this.cls_Thread.interrupt();
        if (bl) {
            try {
                this.cls_Thread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isClosed() {
        return !this.cls_Thread.isAlive();
    }

    public void run() {
        int n = 3;
        boolean bl = false;
        int n2 = 0;
        while (this.cls_Continue && System.currentTimeMillis() < this.cls_Timeout) {
            block16: {
                try {
                    LeopardEapState leopardEapState = this.cls_MacEapCmd.getEapState(this.cls_InterfaceName);
                    LeopardEapState.SummaryState summaryState = leopardEapState.getSummaryState();
                    log.debug((Object)("State is " + (Object)((Object)summaryState) + " Count: " + ++n2 + " EveryNotDisconnected? " + bl));
                    if (summaryState.equals((Object)LeopardEapState.SummaryState.DISCONNECTED)) {
                        log.debug((Object)"Supplicant remains in 'Disconnected' state.");
                        if (n2 > 10 || !bl && n2 >= n) {
                            log.debug((Object)("Supplicant is still disconnected.  BackoffCount: " + ++n + " EapStateChecks: " + n2));
                            if (n == 5 || n == 10) {
                                log.debug((Object)"Will attempt to restart authentication using method B.");
                                this.authenticationDelayed();
                            } else {
                                log.debug((Object)"Will attempt to restart authentication using method A.");
                                this.authenticationHung();
                            }
                            n2 = 0;
                        } else {
                            log.debug((Object)"Will wait for supplicant to activate.");
                        }
                    } else if (summaryState.equals((Object)LeopardEapState.SummaryState.AUTHENTICATED)) {
                        log.debug((Object)"Authentication has completed successfully.");
                        this.authenticationSuccessful();
                        this.cls_Continue = false;
                    } else {
                        log.debug((Object)("Eap state checks is " + n2));
                        if (!bl) {
                            log.debug((Object)"Supplicant has remained at 'Disconnected' state the entire time.");
                            n2 = 0;
                        }
                        bl = true;
                        if (n2 > 5) {
                            log.debug((Object)"Will attempt to spur the supplicant along.");
                            this.authenticationDelayed();
                            n2 = 0;
                        }
                    }
                }
                catch (Exception exception) {
                    log.error((Object)"ERROR", (Throwable)exception);
                }
                if (!this.cls_Continue) continue;
                try {
                    Thread.sleep(this.cls_PollingInterval);
                }
                catch (Exception exception) {
                    if (!this.cls_Continue) break block16;
                    log.debug((Object)"Thread failed to sleep.", (Throwable)exception);
                }
            }
            this.cls_PollingInterval += this.cls_BackoffRate;
        }
        if (this.cls_Continue) {
            log.debug((Object)"Will notify authentication listener that authentication timed out.");
            this.cls_AuthenticationListener.authenticationTimedout(this.cls_RetryCount);
        }
        log.debug((Object)(this.getClass().getSimpleName() + " thread is exiting."));
    }

    public void authenticationHung() {
        if (this.cls_RestartIfNecessary) {
            log.debug((Object)"Notified that authentication is hung.  Will restart it.");
            if (this.cls_EapConfig != null) {
                this.cls_MacEapCmd.start8021x(this.cls_InterfaceName, this.cls_UserPassword, this.cls_EapConfig);
            } else {
                log.debug((Object)"Profile is null.  Unable to start 802.1X.");
            }
        } else {
            log.debug((Object)"Notified that authentication is hung.  Will nnot restart it due to lack of cached creds.");
        }
    }

    public void authenticationDelayed() {
        ++this.cls_DelayedCount;
        if (this.cls_RestartIfNecessary) {
            log.debug((Object)"Notified that authentication is delayed.  Will retry it.");
            if (this.cls_DelayedCount % 2 == 0) {
                if (this.cls_EapConfig != null) {
                    log.info((Object)"Stopping 802.1X.");
                    this.cls_MacEapCmd.stop8021x(this.cls_InterfaceName);
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    log.info((Object)"Starting 802.1X.");
                    this.cls_MacEapCmd.start8021x(this.cls_InterfaceName, this.cls_UserPassword, this.cls_EapConfig);
                }
            } else {
                log.info((Object)"Retrying 802.1X");
                this.cls_MacEapCmd.retry8021x(this.cls_InterfaceName);
            }
        } else {
            log.debug((Object)"Notified that authentication is delayed.  Will not retry it due to lack of cached creds.");
        }
    }

    public void authenticationSuccessful() {
        log.debug((Object)"Notified that authentication was successful.");
        this.cls_AuthenticationListener.authenticationSuccessful();
    }
}

