/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.airport;

import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueBoolean;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueDate;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueInteger;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueString;
import com.cloudpath.common.util.EnumUtil;
import org.apache.log4j.Logger;

public class LeopardAirportNetwork {
    private static final Logger log = Logger.getLogger(LeopardAirportNetwork.class);
    public static final String REMEMBERED_CHANNELS = "Remembered channels";
    public static final String SCAN_DIRECTED = "SCAN_DIRECTED";
    public static final String SSID_STR = "SSID_STR";
    public static final String SECURITY_TYPE = "SecurityType";
    public static final String UNIQUE_PASSWORD_ID = "Unique Password ID";
    public static final String TIMESTAMP = "_timeStamp";
    public static final String UNIQUE_NETWORK_ID = "Unique Network ID";
    public static final String WEP_40 = "WEP40";
    private String cls_UniqueNetworkId = "";
    private long[] cls_RememberedChannels = new long[0];
    private boolean cls_ScanDirected = false;
    private String cls_Ssid = "";
    private SecurityType cls_SecurityType = SecurityType.ANY;
    private String cls_UniquePasswordId = "";
    private long cls_Timestamp = System.currentTimeMillis();
    private boolean cls_IsWep40 = false;

    public void setUniqueNetworkId(String string) {
        this.cls_UniqueNetworkId = string;
    }

    public String getUniqueNetworkId() {
        return this.cls_UniqueNetworkId;
    }

    public void setRememberedChannels(long[] lArray) {
        this.cls_RememberedChannels = lArray;
    }

    public long[] getRememberedChannels() {
        return this.cls_RememberedChannels != null ? this.cls_RememberedChannels : new long[]{};
    }

    public void setScanDirected(boolean bl) {
        this.cls_ScanDirected = bl;
    }

    public boolean getScanDirected() {
        return this.cls_ScanDirected;
    }

    public void setSsid(String string) {
        this.cls_Ssid = string;
    }

    public String getSsid() {
        return this.cls_Ssid;
    }

    public void setSecurityType(SecurityType securityType) {
        this.cls_SecurityType = securityType;
    }

    public SecurityType getSecurityType() {
        return this.cls_SecurityType;
    }

    public void setUniquePasswordId(String string) {
        this.cls_UniquePasswordId = string;
    }

    public String getUniquePasswordId() {
        return this.cls_UniquePasswordId;
    }

    public void setTimestamp(long l) {
        this.cls_Timestamp = l;
    }

    public long getTimestamp() {
        return this.cls_Timestamp;
    }

    public void setIsWep40(boolean bl) {
        this.cls_IsWep40 = bl;
    }

    public boolean getIsWep40() {
        return this.cls_IsWep40;
    }

    public void parse(String string, Dict dict) {
        this.setUniqueNetworkId(string);
        this.setUniqueNetworkId(dict.getString(UNIQUE_NETWORK_ID, this.getUniqueNetworkId()));
        log.debug((Object)("   - Parsing network " + this.getUniqueNetworkId()));
        this.setRememberedChannels(PlistUtil.getIntArrayValue(dict, REMEMBERED_CHANNELS));
        this.setScanDirected(dict.getBoolean(SCAN_DIRECTED, this.getScanDirected()));
        this.setSsid(dict.getString(SSID_STR, this.getSsid()));
        String string2 = dict.getString(SECURITY_TYPE, this.getSecurityType().name());
        this.setSecurityType(SecurityType.getByOsName(string2, SecurityType.ANY));
        this.setUniquePasswordId(dict.getString(UNIQUE_PASSWORD_ID, this.getUniquePasswordId()));
        this.setTimestamp(dict.getDate(TIMESTAMP, this.getTimestamp()));
        this.setIsWep40(dict.getBoolean(WEP_40, this.getIsWep40()));
    }

    public Dict generateKnownNetwork() {
        Dict dict = new Dict();
        long[] lArray = this.getRememberedChannels();
        if (lArray.length > 0) {
            ValueArray valueArray = new ValueArray();
            for (int i = 0; i < lArray.length; ++i) {
                valueArray.addValue(new ValueInteger(lArray[i]));
            }
            dict.addPair(REMEMBERED_CHANNELS, valueArray);
        }
        if (this.getScanDirected()) {
            dict.addPair(SCAN_DIRECTED, this.getScanDirected());
        }
        dict.addPair(SSID_STR, this.getSsid());
        dict.addPair(SECURITY_TYPE, this.getSecurityType().OsName);
        if (this.getUniquePasswordId().length() > 0) {
            dict.addPair(UNIQUE_PASSWORD_ID, this.getUniquePasswordId());
        }
        if (this.getIsWep40()) {
            dict.addPair(WEP_40, new ValueBoolean(this.getIsWep40()));
        }
        dict.addPair(TIMESTAMP, new ValueDate(this.getTimestamp()));
        return dict;
    }

    public Dict generateRecentNetwork() {
        Dict dict = new Dict();
        dict.addPair(SSID_STR, new ValueString(this.getSsid()));
        if (!SecurityType.ANY.equals((Object)this.getSecurityType())) {
            dict.addPair(SECURITY_TYPE, this.getSecurityType().OsName);
        }
        dict.addPair(UNIQUE_NETWORK_ID, this.getUniqueNetworkId());
        if (this.getSecurityType().IsOpen && this.getUniquePasswordId() != null && this.getUniquePasswordId().length() > 0 || this.getSecurityType().IsPsk) {
            dict.addPair(UNIQUE_PASSWORD_ID, new ValueString(this.getUniquePasswordId()));
        }
        if (this.getIsWep40()) {
            dict.addPair(WEP_40, new ValueBoolean(this.getIsWep40()));
        }
        return dict;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SecurityType {
        ANY("Any", "ANY", false, false, false, false),
        OPEN("Open", "OPEN", false, false, false, true),
        WEP("WEP", "WEP", true, false, true, false),
        DOT1X_WEP("802.1X WEP", "8021XWEP", false, true, true, false),
        WPA_PERSONAL("WPA Personal", "WPA", true, false, false, false),
        WPA_ENTERPRISE("WPA Enterprise", "WPAE", false, true, false, false),
        WPA2_PERSONAL("WPA2 Personal", "WPA2", true, false, false, false),
        WPA2_ENTERPRISE("WPA2 Enterprise", "WPA2E", false, true, false, false);

        public String OsName;
        public boolean IsPsk;
        public boolean Is8021X;
        public boolean IsWep;
        public boolean IsOpen;
        public String SnowLeopardOsName;

        private SecurityType(String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.OsName = string2;
            this.IsPsk = bl;
            this.Is8021X = bl2;
            this.IsWep = bl3;
            this.IsOpen = bl4;
            this.SnowLeopardOsName = string3;
        }

        public static SecurityType getByOsName(String string, SecurityType securityType) {
            SecurityType[] securityTypeArray = SecurityType.values();
            for (int i = 0; i < securityTypeArray.length; ++i) {
                if (!string.equals(securityTypeArray[i].OsName)) continue;
                return securityTypeArray[i];
            }
            return securityType;
        }

        public static SecurityType parseSecurityType(String string) {
            return (SecurityType)EnumUtil.parse(SecurityType.class, string, WPA_ENTERPRISE);
        }
    }
}

