/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.airport;

import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.util.XmlUtil;
import org.apache.log4j.Logger;

public class LeopardAirportAssociation
implements WirelessAssociation {
    private static final Logger log = Logger.getLogger(LeopardAirportAssociation.class);
    private static final String SSID = "SSID: ";
    private static final String STATE = "state: ";
    private static final String LAST_ASSOCIATION_STATUS = "lastAssocStatus: ";
    private static final String LAST_TX_RATE = "lastTxRate: ";
    private static final String AIRPORT_OFF = "AirPort: Off";
    private static final String LINK_AUTH = "link auth: ";
    private static final String LINK_STATUS_SCANNING = "scanning";
    private static final String LINK_AUTH_WPA2 = "wpa2";
    private static final String LINK_AUTH_WPA = "wpa";
    private boolean cls_IsEnabled = true;
    private String cls_Ssid = "";
    private int cls_LastAssociationStatus = 0;
    private String cls_State = "";
    private int cls_LastTxRate = 0;
    private Status cls_Status;
    private String cls_LinkAuth = "";

    public LeopardAirportAssociation(String string) {
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            this.parseLine(stringArray[i]);
        }
        this.cls_Status = !this.isEnabled() || LINK_STATUS_SCANNING.equals(this.getState()) || this.getSsid() == null || this.getSsid().length() == 0 ? Status.DISCONNECTED : Status.ASSOCIATED;
        log.debug((Object)("Determined status to be " + (Object)((Object)this.cls_Status)));
    }

    public boolean isEnabled() {
        return this.cls_IsEnabled;
    }

    public boolean isAssociated() {
        return Status.ASSOCIATED.equals((Object)this.cls_Status);
    }

    public String getSsid() {
        return this.cls_Ssid;
    }

    public String getState() {
        return this.cls_State;
    }

    public int getLastAssociationStatus() {
        return this.cls_LastAssociationStatus;
    }

    public int getLastTxRate() {
        return this.cls_LastTxRate;
    }

    public String getLinkAuth() {
        return this.cls_LinkAuth;
    }

    public boolean isWpa2() {
        return LINK_AUTH_WPA2.equals(this.getLinkAuth());
    }

    public boolean isWpa() {
        return LINK_AUTH_WPA.equals(this.getLinkAuth());
    }

    private void parseLine(String string) {
        if (string != null) {
            if ((string = string.trim()).startsWith(SSID)) {
                this.cls_Ssid = MacUtil.parseSetting(string, SSID, null);
            } else if (string.startsWith(STATE)) {
                this.cls_State = MacUtil.parseSetting(string, STATE, null);
            } else if (string.startsWith(LINK_AUTH)) {
                this.cls_LinkAuth = MacUtil.parseSetting(string, LINK_AUTH, null);
            } else if (string.startsWith(LAST_ASSOCIATION_STATUS)) {
                this.cls_LastAssociationStatus = XmlUtil.getStringAsInt(MacUtil.parseSetting(string, LAST_ASSOCIATION_STATUS, null), this.cls_LastAssociationStatus);
            } else if (string.startsWith(LAST_TX_RATE)) {
                this.cls_LastTxRate = XmlUtil.getStringAsInt(MacUtil.parseSetting(string, LAST_TX_RATE, null), this.cls_LastTxRate);
            } else if (string.startsWith(AIRPORT_OFF)) {
                this.cls_IsEnabled = false;
            }
        }
    }

    public String toString() {
        return "[Association enabled: " + this.isEnabled() + " associated: " + this.isAssociated() + " ssid: " + this.getSsid() + "]";
    }

    public boolean isAssociatedTo(String string) {
        return this.isEnabled() && this.isAssociated() && this.getSsid().equals(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        DISCONNECTED,
        STARTING_AUTH,
        WAITING_FOR_CERT,
        ASSOCIATED;

    }
}

