/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.cmd;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.network.networksetup.HttpProxyBehavior;
import com.cloudpath.common.os.mac.common.util.Defaults;
import com.cloudpath.common.os.mac.common.util.MacExeWrapper;
import com.cloudpath.common.os.mac.leopard.cert.CertificateLoader;
import com.cloudpath.common.os.mac.leopard.security.LeopardTrustSetting;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class Maccmd
extends MacExeWrapper {
    private static final Logger log = Logger.getLogger(Maccmd.class);
    private static int INSTANCE_COUNT = 0;
    private static final String ADMIN_USER_INSTALL = "admin-user-install";
    private static final String STANDARD_USER_INSTALL = "standard-user-install";
    private static final String GUEST_USER_INSTALL = "guest-user-install";
    private static final String HELPER_INSTALL = "helper-install";
    private static final File DEBUG_FILE = new File("/tmp/xpc-debug");

    public Maccmd(CommandHandler commandHandler) {
        super(commandHandler, "maccmd", "Network Wizard");
        if (INSTANCE_COUNT++ > 0) {
            log.error((Object)"Invalid duplicant instantiation.", (Throwable)new Exception("Duplicate instantiation of " + this.getClass().getName()));
        }
    }

    public CommandHandler getCommandHandler() {
        return this.cls_CommandHandler;
    }

    public void doComputerLogout() {
        log.debug((Object)"Will request a computer logout...");
        String[] stringArray = new String[]{"logout"};
        this.runMaccmdForBoolean(false, stringArray);
    }

    public void disassociate() {
        log.debug((Object)"Will request a disassociate...");
        String[] stringArray = new String[]{"disassociate"};
        this.runMaccmdForBoolean(true, stringArray);
    }

    public boolean kill() {
        log.debug((Object)"Will kill elevated session.  This is for test use only.");
        String[] stringArray = new String[]{"kill"};
        boolean bl = this.runMaccmdForBoolean(false, stringArray);
        return bl;
    }

    public boolean associate(String string, String string2) {
        log.debug((Object)("Will associate to ssid '" + string + "'."));
        String[] stringArray = new String[]{"associate", string, string2};
        boolean bl = this.runMaccmdForBoolean(true, stringArray);
        return bl;
    }

    public boolean addPreferredWirelessNetwork(String string, String string2, int n, String string3, String string4) {
        log.debug((Object)("Will add preferred wireless network '" + string2 + "' to interface '" + string + "' with security '" + string3 + "'."));
        String[] stringArray = new String[]{"add-wireless-network", string, string2, "" + n, string3, string4 != null ? string4 : ""};
        boolean bl = this.runMaccmdForBoolean(true, stringArray);
        return bl;
    }

    public boolean addPreferredWirelessNetworkWithAPI(String string, String string2) {
        log.debug((Object)("Will add preferred wireless network (via API) '" + string2 + "' to interface '" + string + "'."));
        String[] stringArray = new String[]{"set-ssid-priority-first", string, string2};
        boolean bl = this.runMaccmdForBoolean(true, stringArray);
        return bl;
    }

    public boolean removePreferredWirelessNetwork(String string, String string2) {
        log.debug((Object)("Will remove preferred wireless network '" + string2 + "' on interface '" + string + "'."));
        String[] stringArray = new String[]{"remove-wireless-network", string, string2};
        boolean bl = this.runMaccmdForBoolean(true, stringArray);
        return bl;
    }

    public boolean verify() {
        return this.verify(null, null);
    }

    public boolean verify(String string, String string2) {
        return this.verify(string, string2, false);
    }

    public boolean verify(String string, String string2, boolean bl) {
        log.debug((Object)("Will verify that user can provide " + (string == null ? "administrator" : " standard") + " credentials."));
        String[] stringArray = bl || this.isDebugMode() ? new String[]{"debug", "verify"} : new String[]{"verify"};
        boolean bl2 = this.runMaccmdForBoolean(true, stringArray, string, string2, bl);
        return bl2;
    }

    public boolean copyFileAsAdmin(File file, Destination destination) {
        log.debug((Object)("Will copy '" + file.getAbsolutePath() + "' to destination with common name '" + destination.InternalName + "'."));
        File file2 = new File(destination.ActualPath);
        long l = 0L;
        if (file2.exists()) {
            l = file2.lastModified();
        }
        String string = "copy-file";
        String[] stringArray = new String[]{string, file.getAbsolutePath(), destination.InternalName};
        boolean bl = this.runMaccmdForBoolean(true, stringArray);
        if (bl) {
            if (!file2.exists()) {
                log.warn((Object)("Copying file from " + file.getAbsolutePath() + "' to " + destination.ActualPath + " failed (file doesn't exist)."));
                bl = false;
            } else if (file2.lastModified() == l) {
                log.warn((Object)("Copying file from " + file.getAbsolutePath() + "' to " + destination.ActualPath + " may have failed (timestamp didn't change)."));
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSystemProfile(byte[] byArray) {
        log.debug((Object)"Will add system profile.");
        boolean bl = false;
        File file = null;
        try {
            try {
                file = File.createTempFile("XPC_", ".bin");
                FileUtil.writeFileBytes(file, byArray);
                String string = "add-system-profile";
                String[] stringArray = new String[]{string, file.getAbsolutePath()};
                bl = this.runMaccmdForBoolean(true, stringArray);
            }
            catch (IOException iOException) {
                log.error((Object)"Error while adding system profile.", (Throwable)iOException);
                Object var7_8 = null;
                if (file != null && !file.delete()) {
                    file.deleteOnExit();
                }
            }
            Object var7_7 = null;
            if (file != null && !file.delete()) {
                file.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (file != null && !file.delete()) {
                file.deleteOnExit();
            }
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUserProfile(byte[] byArray) {
        log.debug((Object)"Will add user profile via maccmd.");
        boolean bl = false;
        File file = null;
        try {
            try {
                file = File.createTempFile("XPC_", ".bin");
                FileUtil.writeFileBytes(file, byArray);
                String string = "add-user-profile";
                String[] stringArray = new String[]{string, file.getAbsolutePath()};
                bl = this.runMaccmdForBoolean(true, stringArray);
            }
            catch (IOException iOException) {
                log.error((Object)"Error while adding user profile.", (Throwable)iOException);
                Object var7_8 = null;
                if (file != null && !file.delete()) {
                    file.deleteOnExit();
                }
            }
            Object var7_7 = null;
            if (file != null && !file.delete()) {
                file.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (file != null && !file.delete()) {
                file.deleteOnExit();
            }
            throw throwable;
        }
        return bl;
    }

    public String[] getInstalledSystemProfiles() {
        log.debug((Object)"Will get installed system profiles.");
        String string = "list-system-profiles";
        String[] stringArray = new String[]{string};
        String[] stringArray2 = this.runMaccmdForOutput2(true, stringArray);
        return stringArray2;
    }

    public int setGenericPassword(Keychain keychain, String string, String string2, String string3, String string4, String string5, String string6) {
        log.debug((Object)("Will set generic password in keychain " + keychain.Path + " for account '" + string2 + "' and service '" + string3 + "'."));
        String string7 = Keychain.system.equals((Object)keychain) ? "add-system-password" : "add-user-password";
        String[] stringArray = new String[]{string7, keychain.Path, string, string2, string3, string4, string5, string6};
        int n = this.runMaccmdForResponseCode(string7.contentEquals("add-system-password"), stringArray, null, null);
        return n;
    }

    public boolean deleteGenericPassword(Keychain keychain, String string, String string2) {
        String string3 = Keychain.system.equals((Object)keychain) ? "delete-system-password" : "delete-user-password";
        String[] stringArray = new String[]{string3, keychain.Path, string, string2};
        boolean bl = this.runMaccmdForBoolean(string3.contentEquals("delete-system-password"), stringArray);
        return bl;
    }

    public boolean doesGenericPasswordMatch(Keychain keychain, String string, String string2, String string3) {
        String string4 = Keychain.system.equals((Object)keychain) ? "check-system-password" : "check-user-password";
        String[] stringArray = new String[]{string4, keychain.Path, string, string2, string3};
        try {
            CommandResponse commandResponse = string4.contentEquals("check-system-password") ? this.runElevatedExeFull(stringArray, null, null) : this.runStandardExeFull(stringArray, null, null);
            commandResponse.waitFor();
            if (this.hasError(commandResponse)) {
                commandResponse = string4.contentEquals("check-system-password") ? this.runElevatedExeFull(stringArray, null, null) : this.runStandardExeFull(stringArray, null, null);
                commandResponse.waitFor();
                if (this.hasError(commandResponse)) {
                    log.warn((Object)("An error was returned while running maccmd.  Error: " + Util.join(commandResponse.getError())));
                    return false;
                }
            }
            return Util.join(commandResponse.getOutput()).indexOf("SUCCESS:") >= 0;
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while running maccmd.", (Throwable)iOException);
            return false;
        }
    }

    public boolean addTrustedRootCertificateAuthority(LeopardTrustSetting.SettingType settingType, File file) {
        log.debug((Object)("Will add trusted cert '" + file.getAbsolutePath() + "' to keychain."));
        String string = "add-trusted-cert";
        String[] stringArray = settingType == null ? new String[]{string, "all", KeychainType.SYSTEM_ROOT.Command, file.getAbsolutePath()} : (LeopardTrustSetting.SettingType.EAP.equals((Object)settingType) ? new String[]{string, "basic -p eap -p ssl ", KeychainType.SYSTEM_ROOT.Command, file.getAbsolutePath()} : new String[]{string, settingType.Name, KeychainType.SYSTEM_ROOT.Command, file.getAbsolutePath()});
        boolean bl = this.runMaccmdForBoolean(true, stringArray);
        return bl;
    }

    public boolean removeTrustedRootCertificateAuthority(File file) {
        log.debug((Object)("Will remove trusted cert '" + file.getAbsolutePath() + "' to keychain."));
        String string = "remove-trusted-cert";
        String[] stringArray = new String[]{string, KeychainType.SYSTEM_ROOT.Command, file.getAbsolutePath()};
        boolean bl = this.runMaccmdForBoolean(true, stringArray);
        return bl;
    }

    public boolean addTrustedCertificate(KeychainType keychainType, LeopardTrustSetting.SettingType settingType, File file) {
        log.debug((Object)("Will add trusted server cert '" + file.getAbsolutePath() + "' to keychain '" + (Object)((Object)keychainType) + "'."));
        String string = "add-trusted-cert";
        String[] stringArray = settingType == null ? new String[]{string, "all", keychainType.Command, file.getAbsolutePath()} : (LeopardTrustSetting.SettingType.EAP.equals((Object)settingType) ? new String[]{string, "basic -p eap -p ssl ", keychainType.Command, file.getAbsolutePath()} : new String[]{string, settingType.Name, keychainType.Command, file.getAbsolutePath()});
        if (this.isDebugMode()) {
            log.info((Object)("Running: " + Util.join(stringArray)));
        }
        boolean bl = this.runMaccmdForBoolean(!keychainType.IsLogin, stringArray);
        return bl;
    }

    public boolean removeTrustedCertificate(KeychainType keychainType, File file) {
        log.debug((Object)("Will remove trusted server cert '" + file.getAbsolutePath() + "' to keychain."));
        String string = "remove-trusted-cert";
        String[] stringArray = new String[]{string, keychainType.Command, file.getAbsolutePath()};
        boolean bl = this.runMaccmdForBoolean(!keychainType.IsLogin, stringArray);
        return bl;
    }

    public boolean addSystemCertificate(File file, File file2) {
        log.debug((Object)("Will add system cert '" + file.getAbsolutePath() + "' to keychain."));
        String string = "add-system-cert";
        String[] stringArray = new String[]{string, file.getAbsolutePath(), file2.getAbsolutePath()};
        boolean bl = this.runMaccmdForBoolean(true, stringArray);
        return bl;
    }

    public boolean stopSupplicant(String string) {
        log.debug((Object)("Will stop supplicant on interface " + string + "."));
        String string2 = "stop-supplicant";
        String[] stringArray = new String[]{string2, string};
        return this.runMaccmdForBoolean(true, stringArray);
    }

    public boolean runAdhocScriptAsAdmin(File file) {
        log.debug((Object)("Will run adhoc script at '" + file.getAbsolutePath() + "' as admin."));
        String string = "run-adhoc-script";
        String[] stringArray = new String[]{string, file.getAbsolutePath()};
        boolean bl = this.runMaccmdForBoolean(true, stringArray);
        return bl;
    }

    private boolean installMavericksOrHigherHelper() {
        String[] stringArray = new String[]{"install-helper"};
        return this.runMaccmdForBoolean(true, stringArray, null, null, false);
    }

    public boolean installForAdminUser() {
        return this.installForAdminUser(false);
    }

    public boolean installForAdminUser(boolean bl) {
        if (OsConstants.isMacMavericksOrGreater()) {
            return this.installMavericksOrHigherHelper();
        }
        log.info((Object)"Will install maccmd for admin users.");
        String[] stringArray = bl || this.isDebugMode() ? new String[]{"debug", ADMIN_USER_INSTALL} : new String[]{ADMIN_USER_INSTALL};
        return this.runMaccmdForBoolean(false, stringArray, null, null, bl);
    }

    public boolean installForStandardUser(String string, String string2) {
        log.debug((Object)"Will install maccmd for standard users.");
        String[] stringArray = new String[]{STANDARD_USER_INSTALL};
        return this.runMaccmdForBoolean(false, stringArray, string, string2);
    }

    public boolean installForGuestUser() {
        log.debug((Object)"Will install maccmd for guest users.");
        String[] stringArray = new String[]{GUEST_USER_INSTALL};
        return this.runMaccmdForBoolean(false, stringArray);
    }

    public void setFirewallState(FirewallState firewallState, boolean bl) {
        String[] stringArray = new String[]{"set-firewall", (firewallState != null ? firewallState.OsValue : FirewallState.ON_WITH_STEALTH_MODE.OsValue) + "", bl ? "1" : "0"};
        this.runMaccmdForBoolean(true, stringArray);
    }

    public FirewallState getFirewallState() {
        return FirewallState.getByOsValue(Defaults.getInt(this.cls_CommandHandler, new File("/Library/Preferences/com.apple.alf.plist"), "globalstate"));
    }

    public boolean getFirewallStealthMode() {
        if (OsConstants.isMacLeopardOrBefore()) {
            return Defaults.getBoolean(this.cls_CommandHandler, new File("/Library/Preferences/com.apple.alf.plist"), "stealthenabled", false);
        }
        return this.getFirewallState() == FirewallState.ON_WITH_STEALTH_MODE;
    }

    public boolean installApplication(File file, boolean bl) throws IOException {
        String[] stringArray = new String[]{"install-app", file.getAbsolutePath(), bl ? "Utilities" : "Applications"};
        boolean bl2 = this.runMaccmdForBoolean(true, stringArray);
        return bl2;
    }

    public String getIdentityHandle(String string, String string2) throws IOException {
        String[] stringArray = new String[]{"get-identity-handle", string, string2};
        String string3 = this.runMaccmdForOutput(false, stringArray);
        return string3;
    }

    public String deleteConflictingCertificates(File file) throws IOException {
        String[] stringArray = new String[]{"delete-conflicting-certs", file.getAbsolutePath()};
        String string = this.runMaccmdForOutput(false, stringArray);
        return string;
    }

    public boolean deleteCertificate(String string, String string2) throws IOException {
        String[] stringArray = new String[]{"delete-certificate", string, string2};
        boolean bl = this.runMaccmdForBoolean(true, stringArray);
        return bl;
    }

    public boolean changeUpdateSettings(int n, int n2, int n3, int n4) {
        String[] stringArray = new String[]{"change-update-settings", "\"\"", "\"\"", "\"\"", "\"\""};
        if (n == 1 || n == 0) {
            stringArray[1] = "" + n;
        }
        if (n != 0) {
            if (n2 >= 0) {
                stringArray[2] = "" + n2;
            }
        } else {
            stringArray[2] = "-1";
        }
        if (n3 == 1 || n3 == 0) {
            stringArray[3] = "" + n3;
        }
        if (n4 == 1 || n4 == 0) {
            stringArray[4] = "" + n4;
        }
        boolean bl = this.runMaccmdForBoolean(true, stringArray, null, null, true);
        return bl;
    }

    private boolean hasError(CommandResponse commandResponse) {
        String[] stringArray = commandResponse.getError();
        if (stringArray.length > 1 || stringArray.length == 1 && stringArray[0] != null && stringArray[0].length() > 0) {
            return true;
        }
        String[] stringArray2 = commandResponse.getOutput();
        String string = Util.join(stringArray2);
        if (string != null && string.startsWith("ERROR:")) {
            return true;
        }
        return stringArray.length == 1 && stringArray2.length == 1 && stringArray[0].length() == 0 && stringArray2[0].length() == 0;
    }

    static int getErrorId(String[] stringArray, String[] stringArray2) {
        int n = Maccmd.getErrorId(stringArray2);
        if (n == 0 || n == -1) {
            n = Maccmd.getErrorId(stringArray);
        }
        return n;
    }

    private static int getErrorId(String[] stringArray) {
        int n;
        int n2;
        String string = Util.join(stringArray);
        if (string != null && (n2 = string.lastIndexOf("ERROR:")) >= 0 && (n = string.lastIndexOf("-")) >= 0 && n > (n2 += 6)) {
            String string2 = string.substring(n2, n);
            if ((string2 = string2.trim()).length() > 0) {
                try {
                    return new Integer(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
        }
        return -1;
    }

    private boolean runMaccmdForBoolean(boolean bl, String[] stringArray) {
        return this.runMaccmdForBoolean(bl, stringArray, null, null);
    }

    private boolean runMaccmdForBoolean(boolean bl, String[] stringArray, String string, String string2) {
        return this.runMaccmdForBoolean(bl, stringArray, string, string2, false);
    }

    private boolean runMaccmdForBoolean(boolean bl, String[] stringArray, String string, String string2, boolean bl2) {
        try {
            CommandResponse commandResponse;
            if (bl) {
                if (this.isDebugMode()) {
                    log.info((Object)" - Will run elevated.");
                }
                commandResponse = this.runElevatedExeFull(stringArray, string, string2);
            } else {
                if (this.isDebugMode()) {
                    log.info((Object)" - Will run not elevated.");
                }
                commandResponse = this.runStandardExeFull(stringArray, string, string2);
            }
            commandResponse.waitFor();
            if (bl2 || this.isDebugMode()) {
                log.info((Object)("STDOUT: " + Util.join(commandResponse.getOutput())));
                log.info((Object)("STDERR: " + Util.join(commandResponse.getError())));
            }
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                Maccmd.clearSudo(this.cls_CommandHandler);
            }
            if (this.hasError(commandResponse)) {
                log.warn((Object)("An error was returned while running maccmd.  Error: " + Util.join(commandResponse.getError())));
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while running maccmd.", (Throwable)iOException);
            return false;
        }
    }

    private int runMaccmdForResponseCode(boolean bl, String[] stringArray, String string, String string2) {
        try {
            CommandResponse commandResponse = bl ? this.runElevatedExeFull(stringArray, string, string2) : this.runStandardExeFull(stringArray, string, string2);
            commandResponse.waitFor();
            if (this.isDebugMode()) {
                log.info((Object)("STDOUT: " + Util.join(commandResponse.getOutput())));
                log.info((Object)("STDERR: " + Util.join(commandResponse.getError())));
            }
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                Maccmd.clearSudo(this.cls_CommandHandler);
            }
            if (this.hasError(commandResponse)) {
                log.warn((Object)("An error was returned while running maccmd.  Error: " + Util.join(commandResponse.getError())));
                return Maccmd.getErrorId(commandResponse.getOutput(), commandResponse.getError());
            }
            return 0;
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while running maccmd.", (Throwable)iOException);
            return -2;
        }
    }

    private String runMaccmdForOutput(boolean bl, String[] stringArray) {
        try {
            CommandResponse commandResponse = bl ? this.runElevatedExeFull(stringArray, null, null) : this.runStandardExeFull(stringArray, null, null);
            commandResponse.waitFor();
            if (this.isDebugMode()) {
                log.info((Object)("STDOUT: " + Util.join(commandResponse.getOutput())));
                log.info((Object)("STDERR: " + Util.join(commandResponse.getError())));
            }
            if (this.hasError(commandResponse)) {
                log.warn((Object)("An error was returned while running maccmd.  Error: " + Util.join(commandResponse.getError())));
            }
            return Util.join(commandResponse.getOutput(), "");
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while running maccmd.", (Throwable)iOException);
            return "";
        }
    }

    private String[] runMaccmdForOutput2(boolean bl, String[] stringArray) {
        try {
            CommandResponse commandResponse = bl ? this.runElevatedExeFull(stringArray, null, null) : this.runStandardExeFull(stringArray, null, null);
            commandResponse.waitFor();
            if (this.isDebugMode()) {
                log.info((Object)("STDOUT: " + Util.join(commandResponse.getOutput())));
                log.info((Object)("STDERR: " + Util.join(commandResponse.getError())));
            }
            if (this.hasError(commandResponse)) {
                log.warn((Object)("An error was returned while running maccmd.  Error: " + Util.join(commandResponse.getError())));
            }
            return commandResponse.getOutput();
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while running maccmd.", (Throwable)iOException);
            return new String[0];
        }
    }

    private boolean isDebugMode() {
        return DEBUG_FILE.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTlsIdentityOnUserProfile(String string, CertificateLoader.CertificateResponse certificateResponse) {
        File file = null;
        try {
            try {
                file = File.createTempFile("cpn_pkcs12_", ".pkcs12");
                FileUtil.writeFileBytes(file, certificateResponse.getPkcs12Certificate());
                String[] stringArray = new String[]{"networksetup", "-settlsidentityonuserprofile", string, file.getAbsolutePath(), certificateResponse.getPkcs12Password()};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
                if (Util.join(commandResponse.getError()).length() > 0) {
                    log.warn((Object)("Error information was returned: " + Util.join(commandResponse.getError())));
                }
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                log.warn((Object)"Error occurred while processing TLS identity.", (Throwable)exception);
                Object var7_8 = null;
                if (file != null && !file.delete()) {
                    file.deleteOnExit();
                }
            }
            Object var7_7 = null;
            if (file != null && !file.delete()) {
                file.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (file != null && !file.delete()) {
                file.deleteOnExit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTlsIdentityOnSystemProfile(String string, CertificateLoader.CertificateResponse certificateResponse) {
        log.info((Object)("Will set identity for system profile on service '" + string + "'."));
        File file = null;
        try {
            try {
                file = File.createTempFile("cpn_pkcs12_", ".pkcs12");
                FileUtil.writeFileBytes(file, certificateResponse.getPkcs12Certificate());
                String[] stringArray = new String[]{"set-tls-system-identity", string, file.getAbsolutePath(), certificateResponse.getPkcs12Password()};
                boolean bl = this.runMaccmdForBoolean(true, stringArray);
                log.debug((Object)("Result of setting identity: " + bl));
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                log.warn((Object)"Error occurred while processing TLS identity.", (Throwable)exception);
                Object var7_8 = null;
                if (file != null && !file.delete()) {
                    file.deleteOnExit();
                }
            }
            Object var7_7 = null;
            if (file != null && !file.delete()) {
                file.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (file != null && !file.delete()) {
                file.deleteOnExit();
            }
            throw throwable;
        }
    }

    public void setProxy(NetworkInterface networkInterface, HttpProxyBehavior httpProxyBehavior) {
        if (httpProxyBehavior.isManual()) {
            log.info((Object)("Setting proxy to manual with " + networkInterface.getServiceName() + ", " + httpProxyBehavior.getServerOnly() + ", " + httpProxyBehavior.getHttpProxyPort()));
            this.runMaccmdForOutput(true, new String[]{"set-proxy", "1", networkInterface.getServiceName(), httpProxyBehavior.getServerOnly(), httpProxyBehavior.getHttpProxyPort(), ""});
        } else if (httpProxyBehavior.isAutodetect() || httpProxyBehavior.isAutoOrByUrl()) {
            log.info((Object)("Setting proxy to autoDetect with " + networkInterface.getServiceName()));
            this.runMaccmdForOutput(true, new String[]{"set-proxy", "2", networkInterface.getServiceName(), "", "", ""});
        } else if (httpProxyBehavior.isAutoByUrl()) {
            log.info((Object)("Setting proxy to autoByUrl with " + networkInterface.getServiceName() + ", " + httpProxyBehavior.getHttpProxyAutoconfUrl()));
            this.runMaccmdForOutput(true, new String[]{"set-proxy", "3", networkInterface.getServiceName(), "", "", httpProxyBehavior.getHttpProxyAutoconfUrl()});
        } else if (httpProxyBehavior.isDisabled()) {
            log.info((Object)"Setting proxy to disabled.");
            this.runMaccmdForOutput(true, new String[]{"set-proxy", "4", networkInterface.getServiceName(), "", "", ""});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Destination {
        preferences("preferences", "/Library/Preferences/SystemConfiguration/preferences.plist"),
        airport_preferences("airport-preferences", "/Library/Preferences/SystemConfiguration/com.apple.airport.preferences.plist"),
        profiles("profiles", "/Library/Preferences/SystemConfiguration/com.apple.network.eapolclient.configuration.plist");

        public String InternalName;
        public String ActualPath;

        private Destination(String string2, String string3) {
            this.InternalName = string2;
            this.ActualPath = string3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Keychain {
        login(System.getProperty("user.home") + "/Library/Keychains/login.keychain"),
        system("system");

        public String Path;

        private Keychain(String string2) {
            this.Path = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeychainType {
        LOGIN("login", true),
        SYSTEM("system", false),
        SYSTEM_ROOT("system-root", false);

        public String Command;
        public boolean IsLogin;

        private KeychainType(String string2, boolean bl) {
            this.Command = string2;
            this.IsLogin = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FirewallState {
        OFF(0),
        MANUAL(1),
        ON_WITH_STEALTH_MODE(2);

        public int OsValue;

        private FirewallState(int n2) {
            this.OsValue = n2;
        }

        public static FirewallState getByOsValue(int n) {
            for (int i = 0; i < FirewallState.values().length; ++i) {
                if (FirewallState.values()[i].OsValue != n) continue;
                return FirewallState.values()[i];
            }
            return OFF;
        }

        public static FirewallState getByOsValue(int n, FirewallState firewallState) {
            for (int i = 0; i < FirewallState.values().length; ++i) {
                if (FirewallState.values()[i].OsValue != n) continue;
                return FirewallState.values()[i];
            }
            return firewallState;
        }
    }
}

