/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.cert;

import com.cloudpath.common.cert.CertUtil;
import com.cloudpath.common.cert.IssuedCertificate;
import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.util.BanishedWords;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.UrlLoader2;
import com.cloudpath.common.util.Util;
import com.cloudpath.common.util.UtilBasic;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import javax.security.cert.X509Certificate;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateLoader {
    private static final Logger log = Logger.getLogger(CertificateLoader.class);
    private static String CACHE_LAST_COMMONNAME = null;
    private static String CACHE_LAST_PRIVATE_KEY = null;
    private static String CACHE_LAST_CSR = null;

    public static IssuedCertificate generateClientCertificate(CommandHandler commandHandler, String string, String string2, String string3, HashMap<String, String> hashMap) throws CertificateGenerationException {
        log.info((Object)("Will retrieve certificate from '" + string + "' for '" + string2 + "'."));
        String[] stringArray = CertificateLoader.generateCsr(commandHandler, string2);
        if (stringArray == null || stringArray.length != 2) {
            throw new CertificateGenerationException(GenerationResult.CSR_AND_PRIVATE_KEY_ERROR, "Did not receive CSR nor private key.", null);
        }
        if (stringArray[0] == null) {
            throw new CertificateGenerationException(GenerationResult.CSR_ERROR, "Did not receive CSR.", null);
        }
        if (stringArray[1] == null) {
            throw new CertificateGenerationException(GenerationResult.PRIVATE_KEY_ERROR, "Did not receive private key.", null);
        }
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        log.debug((Object)("Will query URL: " + string));
        byte[] byArray = CertificateLoader.sendCsr(string, string4, string2, string3, hashMap);
        String string6 = new String(byArray);
        log.debug((Object)("Public Cert is:\n" + string6));
        if (string6 != null && string6.toLowerCase().contains("<html>")) {
            throw new CertificateGenerationException(GenerationResult.SERVER_ERROR, "It appears we received an HTML page instead of the certificate.", null);
        }
        if (string6 != null && string6.toLowerCase().contains("payloadcontent")) {
            log.info((Object)"The response appears to be a mobileconfig file.");
        }
        if (string6 == null || string6.length() == 0) {
            throw new CertificateGenerationException(GenerationResult.SERVER_ERROR, "Did not receive certificate.", null);
        }
        return new IssuedCertificate(byArray, string5, string2);
    }

    public static CertificateResponse saveClientCertificate(Maccmd maccmd, IssuedCertificate issuedCertificate, boolean bl) throws CertificateGenerationException {
        Object object;
        String string = issuedCertificate.getCertificateData();
        String string2 = CertificateLoader.convertTextToPem(maccmd.getCommandHandler(), string);
        String string3 = issuedCertificate.getDefaultCommonName();
        String string4 = issuedCertificate.getDefaultCommonName();
        try {
            log.debug((Object)"Will convert certificate to DER...");
            object = CertificateLoader.convertTextToDer(maccmd.getCommandHandler(), string2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            X509Certificate x509Certificate = X509Certificate.getInstance(byteArrayInputStream);
            string3 = CertUtil.getCommonName(x509Certificate);
            string4 = CertUtil.getEmailAddress(x509Certificate);
            log.debug((Object)("Common name is '" + string3 + "'.  Email address is '" + string4 + "'."));
            maccmd.deleteCertificate(string3, string4);
        }
        catch (Exception exception) {
            log.error((Object)"An error occurred while converting cert types.", (Throwable)exception);
            log.debug((Object)("CERT: " + string));
            log.debug((Object)("PEM CERT: " + string2));
        }
        object = CertificateLoader.saveCertificate(maccmd, maccmd.getCommandHandler(), string2, issuedCertificate.getPrivateKey(), "", bl);
        ((CertificateResponse)object).setCommonName(string3);
        ((CertificateResponse)object).setEmailAddress(string4);
        return object;
    }

    public static String getCnfContents(String string) {
        if (string == null || string.length() == 0) {
            string = "USER";
        }
        String string2 = "RANDFILE=$ENV::HOME/.rnd\n[ req ]\ndefault_bits = 2048\ndistinguished_name = req_distinguished_name\nprompt = no\n\n[ req_distinguished_name ]\nCN = " + string + "\n";
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] generateCsr(CommandHandler commandHandler, String string) throws CertificateGenerationException {
        if (CACHE_LAST_COMMONNAME != null && CACHE_LAST_COMMONNAME.equals(string) && CACHE_LAST_PRIVATE_KEY != null && CACHE_LAST_CSR != null) {
            log.info((Object)("Cached CSR exists for common name '" + string + "'.  Will use it."));
            return new String[]{CACHE_LAST_CSR, CACHE_LAST_PRIVATE_KEY};
        }
        String string2 = Util.generateGuid();
        File file = new File("/tmp/" + string2);
        File file2 = new File(file, "openssl.cnf");
        if (!file.exists()) {
            file.mkdirs();
        }
        File file3 = new File(file, "newreq.pem");
        File file4 = new File(file, "tmp.pem");
        if (file3.exists()) {
            file3.delete();
        }
        if (file4.exists()) {
            file4.delete();
        }
        try {
            String string3;
            CommandResponse commandResponse;
            Object object;
            String string4 = CertificateLoader.getCnfContents(string);
            try {
                FileUtil.write(file2.getAbsolutePath(), string4);
            }
            catch (IOException iOException) {
                throw new CertificateGenerationException(GenerationResult.FILE_ERROR, "Error creating CNF file.", iOException);
            }
            try {
                object = new String[]{"openssl", "req", "-nodes", "-new", "-x509", "-keyout", file3.getAbsolutePath(), "-out", file3.getAbsolutePath(), "-days", "365", "-config", file2.getAbsolutePath()};
                commandResponse = commandHandler.executeCommand((String[])object);
                commandResponse.waitFor();
                log.debug((Object)Util.join(commandResponse.getOutput()));
                log.debug((Object)Util.join(commandResponse.getError()));
            }
            catch (IOException iOException) {
                throw new CertificateGenerationException(GenerationResult.EXEC_ERROR, "Error creating private key.", iOException);
            }
            try {
                object = new String[]{"openssl", "x509", "-x509toreq", "-in", file3.getAbsolutePath(), "-signkey", file3.getAbsolutePath(), "-out", file4.getAbsolutePath()};
                commandResponse = commandHandler.executeCommand((String[])object);
                commandResponse.waitFor();
                log.debug((Object)Util.join(commandResponse.getOutput()));
                log.debug((Object)Util.join(commandResponse.getError()));
            }
            catch (IOException iOException) {
                throw new CertificateGenerationException(GenerationResult.EXEC_ERROR, "Error creating csr.", iOException);
            }
            if (!file4.exists()) {
                throw new CertificateGenerationException(GenerationResult.EXEC_ERROR, "CSR file does not exist.", null);
            }
            try {
                object = FileUtil.read(file4);
                log.debug((Object)("CSR: " + (String)object));
            }
            catch (IOException iOException) {
                throw new CertificateGenerationException(GenerationResult.FILE_ERROR, "Error reading csr.", iOException);
            }
            if (object != null) {
                object = ((String)object).replace("-----BEGIN CERTIFICATE REQUEST-----", "-----BEGIN NEW CERTIFICATE REQUEST-----");
                object = ((String)object).replace("-----END CERTIFICATE REQUEST-----", "-----END NEW CERTIFICATE REQUEST-----");
            }
            try {
                string3 = FileUtil.read(file3);
                log.debug((Object)("Private Key Length: " + string3.length()));
            }
            catch (IOException iOException) {
                throw new CertificateGenerationException(GenerationResult.FILE_ERROR, "Error reading private key.", iOException);
            }
            CACHE_LAST_COMMONNAME = string;
            CACHE_LAST_PRIVATE_KEY = string3;
            CACHE_LAST_CSR = object;
            String[] stringArray = new String[]{object, string3};
            return stringArray;
        }
        finally {
            if (file3 != null && !file3.delete()) {
                file3.deleteOnExit();
            }
            if (file4 != null && !file4.delete()) {
                file4.deleteOnExit();
            }
            if (file != null && !file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public static byte[] sendCsr(String string, String string2, String string3, String string4, HashMap<String, String> hashMap) throws CertificateGenerationException {
        byte[] byArray;
        Object object;
        string = UtilBasic.replaceVariable(string, "CSR", string2, true);
        string = Util.replaceVariables(string, hashMap, true);
        String string5 = "";
        if (string.indexOf("?") > 0) {
            object = string;
            string = ((String)object).substring(0, ((String)object).indexOf("?"));
            string5 = ((String)object).substring(((String)object).indexOf("?") + 1);
        }
        try {
            new URL(string);
        }
        catch (IOException iOException) {
            throw new CertificateGenerationException(GenerationResult.URL_ERROR, "Error creating url '" + string + "'.", iOException);
        }
        log.info((Object)("Will query URL: " + string));
        object = new byte[0];
        try {
            object = string5.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)"UTF-8 not supported.", (Throwable)unsupportedEncodingException);
            object = string5.getBytes();
        }
        UrlLoader2.flushWwwCache();
        try {
            String string6;
            byArray = UrlLoader2.fetchURLAsBinary(string, string3, string4, true, (byte[])object, 40000, null, true);
            if (byArray == null) {
                byArray = new byte[]{};
            }
            if ((string6 = new String(byArray)).startsWith("ERROR:")) {
                log.debug((Object)("RESPONSE: " + string6));
                throw new CertificateGenerationException(GenerationResult.SERVER_ERROR, string6.substring(7));
            }
            if (string6.startsWith("AUTH_FAILURE:")) {
                throw new CertificateGenerationException(GenerationResult.AUTHENTICATION_ERROR, string6.toString(), null);
            }
            if (string6.startsWith("MACHINE_FAILURE:")) {
                throw new CertificateGenerationException(GenerationResult.MACHINE_ERROR, string6.toString(), null);
            }
        }
        catch (IOException iOException) {
            throw new CertificateGenerationException(GenerationResult.SERVER_ERROR, iOException.getMessage(), iOException);
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CertificateResponse saveCertificate(Maccmd maccmd, CommandHandler commandHandler, String string, String string2, String string3, boolean bl) throws CertificateGenerationException {
        boolean bl2 = new File("/tmp/cloudpath.debug").exists();
        File file = null;
        File file2 = null;
        File file3 = null;
        CertificateResponse certificateResponse = null;
        try {
            String[] stringArray;
            Object object;
            try {
                file = File.createTempFile("cpn_pvk_", ".cer");
                FileUtil.write(file.getAbsolutePath(), string2);
                file2 = File.createTempFile("cpn_pub_", ".pem");
                FileUtil.write(file2.getAbsolutePath(), string);
                log.debug((Object)("CERT exists (A): " + file2.exists()));
            }
            catch (IOException iOException) {
                throw new CertificateGenerationException(GenerationResult.FILE_ERROR, "Error while handling private key and cert files.", iOException);
            }
            try {
                log.debug((Object)"Will delete conflicting certificates...");
                log.debug((Object)FileUtil.read(file2));
                object = maccmd.deleteConflictingCertificates(file2);
                log.debug((Object)("RESPONSE: " + (String)object));
                log.debug((Object)"Done deleting conflicting certificates.");
            }
            catch (Exception exception) {
                log.error((Object)"Error occurred while trying to delete conflicting certs.", (Throwable)exception);
            }
            log.debug((Object)"Will import certificate...");
            log.debug((Object)("CERT exists (B): " + file2.exists()));
            try {
                if (bl) {
                    log.debug((Object)"Will add system certificate...");
                    boolean bl3 = maccmd.addSystemCertificate(file2, file);
                    log.debug((Object)("Added system certificate.  Result=" + bl3));
                    if (!bl3) {
                        throw new CertificateGenerationException(GenerationResult.EXEC_ERROR, "Error while importing system certificate into keychain.", null);
                    }
                } else {
                    log.debug((Object)"Will add user certificate...");
                    object = null;
                    if (string3 != null && string3.length() > 0) {
                        log.debug((Object)("Will add to keychain: " + string3));
                        stringArray = new String[]{"certtool", "i", file2.getAbsolutePath(), "k=" + string3, "r=" + file.getAbsolutePath()};
                    } else {
                        log.debug((Object)"Will add to default keychain");
                        stringArray = new String[]{"certtool", "i", file2.getAbsolutePath(), "r=" + file.getAbsolutePath()};
                    }
                    if (bl2) {
                        log.debug((Object)Util.join(stringArray));
                    }
                    object = commandHandler.executeCommand(stringArray);
                    ((CommandResponse)object).waitFor();
                    if (object == null) {
                        log.debug((Object)"Response is null.");
                        throw new CertificateGenerationException(GenerationResult.EXEC_ERROR, "Error while importing certificate into keychain.  Received null response.", null);
                    }
                    if (bl2) {
                        log.info((Object)("Standard Out: " + Util.join(((CommandResponse)object).getOutput(), "\n")));
                        log.info((Object)("Standard Err: " + Util.join(((CommandResponse)object).getError(), "\n")));
                        log.debug((Object)("CERT FILE: " + file2.getAbsolutePath()));
                        log.debug((Object)("CERT: " + file2.exists()));
                    }
                    if (Util.join(((CommandResponse)object).getError()).length() > 0) {
                        log.debug((Object)("CERT FILE: " + file2.getAbsolutePath()));
                        log.debug((Object)("CERT: " + file2.exists()));
                        log.debug((Object)("STDERR: " + Util.join(((CommandResponse)object).getError())));
                        log.debug((Object)("STDOUT: " + Util.join(((CommandResponse)object).getOutput())));
                        throw new CertificateGenerationException(GenerationResult.SAVE_TO_KEYCHAIN_ERROR, "Error writing to keychain: " + Util.join(((CommandResponse)object).getError()), null);
                    }
                }
            }
            catch (IOException iOException) {
                throw new CertificateGenerationException(GenerationResult.EXEC_ERROR, "Error while importing certificate into keychain.", iOException);
            }
            stringArray = Math.random() + "-" + Util.generateGuid() + Util.generateGuid();
            BanishedWords.add((String)stringArray, "[PKCS12]");
            try {
                file3 = File.createTempFile("cpn_pub_", ".pkcs12");
                String[] stringArray2 = new String[]{"openssl", "pkcs12", "-export", "-in", file2.getAbsolutePath(), "-inkey", file.getAbsolutePath(), "-out", file3.getAbsolutePath(), "-password", "pass:" + (String)stringArray};
                if (bl2) {
                    log.debug((Object)stringArray2);
                }
                CommandResponse commandResponse = commandHandler.executeCommand(stringArray2);
                commandResponse.waitFor();
                if (Util.join(commandResponse.getError()).length() > 0) {
                    log.warn((Object)("An error occurred while processing pkcs12 file.  Err: " + Util.join(commandResponse.getError())));
                } else {
                    byte[] byArray = FileUtil.readBytes(file3);
                    certificateResponse = new CertificateResponse((String)stringArray, byArray);
                }
            }
            catch (IOException iOException) {
                log.info((Object)"Error while creating P12.");
                throw new CertificateGenerationException(GenerationResult.EXEC_ERROR, "Error while importing certificate into keychain.", iOException);
            }
            Object var16_21 = null;
            if (!bl2 && file != null && !file.delete()) {
                file.deleteOnExit();
            }
            if (!bl2 && file2 != null && !file2.delete()) {
                file2.deleteOnExit();
            }
            if (!bl2 && file3 != null && !file3.delete()) {
                file3.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            Object var16_22 = null;
            if (!bl2 && file != null && !file.delete()) {
                file.deleteOnExit();
            }
            if (!bl2 && file2 != null && !file2.delete()) {
                file2.deleteOnExit();
            }
            if (!bl2 && file3 != null && !file3.delete()) {
                file3.deleteOnExit();
            }
            throw throwable;
        }
        if (bl2 && certificateResponse != null) {
            log.debug((Object)("COMMON NAME: " + certificateResponse.getCommonName()));
            log.debug((Object)("EMAIL: " + certificateResponse.getEmailAddress()));
            log.debug((Object)("P12 PWD: " + certificateResponse.getPkcs12Password()));
            log.debug("P12 CERT: " + certificateResponse.getPkcs12Certificate() != null ? Integer.valueOf(certificateResponse.getPkcs12Certificate().length) : "-1");
        }
        return certificateResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertTextToDer(CommandHandler commandHandler, String string) throws CertificateGenerationException {
        log.debug((Object)"Will convert cert to DER...");
        File file = null;
        boolean bl = string != null && string.toUpperCase().indexOf("-----BEGIN PKCS7-----") >= 0;
        boolean bl2 = string != null && string.toUpperCase().indexOf("-----BEGIN CERTIFICATE-----") >= 0;
        log.debug((Object)("  Cert is:  PKCS#7: " + bl + "  PEM: " + bl2));
        if (!bl && !bl2) {
            log.debug((Object)"Certificate text appears to already be a DER.");
            return string.getBytes();
        }
        string = CertificateLoader.convertTextToPem(commandHandler, string);
        try {
            Object[] objectArray;
            Object[] objectArray2;
            try {
                file = File.createTempFile("cpn_pem_", ".pem");
                FileUtil.write(file.getAbsolutePath(), string);
                log.debug((Object)("  Temp file is " + file.getAbsolutePath()));
            }
            catch (IOException iOException) {
                throw new CertificateGenerationException(GenerationResult.FILE_ERROR, "Error while creating private key and cert files.", iOException);
            }
            try {
                log.debug((Object)"Will convert PEM...");
                objectArray2 = new String[]{"openssl", "x509", "-inform", "PEM", "-outform", "DER", "-in", file.getAbsolutePath(), "-out", file.getAbsolutePath()};
                objectArray = commandHandler.executeCommand((String[])objectArray2);
                objectArray.waitFor();
                log.debug((Object)("  Cert file: " + file.exists()));
                log.debug((Object)("  Cert File AS DER: " + FileUtil.read(file)));
                if (Util.join(objectArray.getError()).length() > 0) {
                    throw new CertificateGenerationException(GenerationResult.EXEC_ERROR, "Error received while transform certificate.", null);
                }
            }
            catch (IOException iOException) {
                throw new CertificateGenerationException(GenerationResult.EXEC_ERROR, "Error while transforming certificate.", iOException);
            }
            try {
                log.debug((Object)("  Cert file at reading bytes: " + file.exists()));
                objectArray2 = FileUtil.readBytes(file);
            }
            catch (IOException iOException) {
                throw new CertificateGenerationException(GenerationResult.FILE_ERROR, "Error while reading DER certificate.", iOException);
            }
            objectArray = objectArray2;
            Object var8_10 = null;
            if (file != null && !file.delete()) {
                file.deleteOnExit();
            }
            return objectArray;
        }
        catch (Throwable throwable) {
            block11: {
                Object var8_11 = null;
                if (file == null || file.delete()) break block11;
                file.deleteOnExit();
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String convertTextToPem(CommandHandler commandHandler, String string) throws CertificateGenerationException {
        Throwable throwable2;
        String[] stringArray;
        log.debug((Object)"Will convert cert to Pem...");
        File file = null;
        boolean bl = string != null && string.toUpperCase().indexOf("-----BEGIN PKCS7-----") >= 0;
        boolean bl2 = string != null && string.toUpperCase().indexOf("-----BEGIN CERTIFICATE-----") >= 0;
        log.debug((Object)("  Cert is:  PKCS#7: " + bl + "  PEM: " + bl2));
        if (bl2) {
            return string;
        }
        try {
            file = File.createTempFile("cpn_pkcs7_", ".p7b");
            FileUtil.write(file.getAbsolutePath(), string);
            log.debug((Object)("  Temp file is " + file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            throw new CertificateGenerationException(GenerationResult.FILE_ERROR, "Error while creating private key and cert files.", iOException);
        }
        if (bl) {
            log.debug((Object)"Will convert PKCS7...");
            try {
                stringArray = new String[]{"openssl", "pkcs7", "-print_certs", "-outform", "PEM", "-in", file.getAbsolutePath(), "-out", file.getAbsolutePath()};
                CommandResponse commandResponse = commandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
                log.debug((Object)("  Cert file: " + file.exists()));
                log.debug((Object)("  Cert File AS PEM: " + FileUtil.read(file)));
                if (Util.join(commandResponse.getError()).length() > 0) {
                    throw new CertificateGenerationException(GenerationResult.EXEC_ERROR, "Error received while transforming certificate from PKCS7 to PEM.", null);
                }
            }
            catch (IOException iOException) {
                throw new CertificateGenerationException(GenerationResult.EXEC_ERROR, "Error while transforming certificate from PKCS7 to PEM.", iOException);
            }
        }
        try {
            log.debug((Object)("  Cert file at reading bytes: " + file.exists()));
            stringArray = FileUtil.read(file);
        }
        catch (IOException iOException) {
            try {
                throw new CertificateGenerationException(GenerationResult.FILE_ERROR, "Error while reading PEM certificate.", iOException);
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                if (file == null || file.delete()) throw throwable2;
                file.deleteOnExit();
            }
        }
        Object var8_10 = null;
        if (file == null) return stringArray;
        if (file.delete()) return stringArray;
        file.deleteOnExit();
        return stringArray;
        throw throwable2;
    }

    public static class CertificateResponse {
        private final String cls_Pkcs12Password;
        private final byte[] cls_Pkcs12Certificate;
        private String cls_CommonName = "";
        private String cls_EmailAddress = "";

        public CertificateResponse(String string, byte[] byArray) {
            this.cls_Pkcs12Password = string;
            this.cls_Pkcs12Certificate = byArray;
        }

        public String getPkcs12Password() {
            return this.cls_Pkcs12Password;
        }

        public byte[] getPkcs12Certificate() {
            return this.cls_Pkcs12Certificate;
        }

        public void setCommonName(String string) {
            this.cls_CommonName = string;
        }

        public String getCommonName() {
            return this.cls_CommonName;
        }

        public void setEmailAddress(String string) {
            this.cls_EmailAddress = string;
        }

        public String getEmailAddress() {
            return this.cls_EmailAddress;
        }
    }

    public static class CertificateGenerationException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private GenerationResult cls_ErrorCode;
        private String cls_BasicMessage;

        public CertificateGenerationException(GenerationResult generationResult, String string, Exception exception) {
            super(string + "(ERROR: " + generationResult.name() + ")", exception);
            this.cls_BasicMessage = string;
            this.cls_ErrorCode = generationResult;
        }

        public CertificateGenerationException(GenerationResult generationResult, String string) {
            super(string, null);
            this.cls_BasicMessage = string;
            this.cls_ErrorCode = generationResult;
        }

        public String getBasicMessage() {
            return this.cls_BasicMessage;
        }

        public GenerationResult getErrorCode() {
            return this.cls_ErrorCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GenerationResult {
        SUCCESSFUL,
        ENCODING_ERROR,
        URL_ERROR,
        CSR_AND_PRIVATE_KEY_ERROR,
        CSR_ERROR,
        PRIVATE_KEY_ERROR,
        SERVER_ERROR,
        AUTHENTICATION_ERROR,
        MACHINE_ERROR,
        SAVE_TO_KEYCHAIN_ERROR,
        UNKNOWN_ERROR,
        FILE_ERROR,
        EXEC_ERROR;

    }
}

